/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.account.setup.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.exoplatform.commons.info.MissingProductInformationException;
import org.exoplatform.commons.info.ProductInformations;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.platform.common.software.register.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PingBackService {
    private static final Log LOG = ExoLogger.getExoLogger(PingBackService.class);
    private static final String LOOP_FUSE_FORM_DISPLAYED = "formDisplayed";
    private static final String COMMUNITY_EDITION = "community";
    private boolean loopfuseFormDisplayed = false;
    private String pingBackUrl;
    private ProductInformations productInformations;

    public PingBackService(InitParams initParams, ProductInformations productInformations) {
        if (initParams != null) {
            ValueParam pingBackUrlValueParam = initParams.getValueParam("pingBackUrl");
            this.pingBackUrl = pingBackUrlValueParam != null ? pingBackUrlValueParam.getValue() : "";
        }
        this.productInformations = productInformations;
    }

    public boolean isConnectedToInternet() {
        String pingServerURL = this.pingBackUrl.substring(0, this.pingBackUrl.indexOf("/", "http://url".length()));
        try {
            URL url = new URL(pingServerURL);
            HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
            urlConn.connect();
            return 404 != urlConn.getResponseCode();
        }
        catch (MalformedURLException e) {
            LOG.error((Object)("LeadCapture : Error creating HTTP connection to the server : " + pingServerURL));
        }
        catch (IOException e) {
            LOG.error((Object)("LeadCapture : Error creating HTTP connection to the server : " + pingServerURL));
        }
        return false;
    }

    public boolean isLandingPageDisplayed() throws MissingProductInformationException {
        String loopfuseFormDisplayedString = this.readFromFile(LOOP_FUSE_FORM_DISPLAYED, this.getPingBackFileLocation());
        if (loopfuseFormDisplayedString != null && !loopfuseFormDisplayedString.isEmpty()) {
            this.loopfuseFormDisplayed = Boolean.parseBoolean(loopfuseFormDisplayedString);
            if (this.getPlatformEdition(this.productInformations).equals("ENTERPRISE") && this.loopfuseFormDisplayed) {
                return false;
            }
        }
        return this.loopfuseFormDisplayed;
    }

    private String readFromFile(String key, String fileLocation) throws MissingProductInformationException {
        if (fileLocation != null && !fileLocation.isEmpty() && !new File(fileLocation).exists()) {
            this.writePingBackFormDisplayed(false);
            return "false";
        }
        try {
            Properties properties = new Properties();
            FileInputStream inputStream = new FileInputStream(fileLocation);
            properties.loadFromXML(inputStream);
            ((InputStream)inputStream).close();
            return (String)properties.get(key);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private String getPlatformEdition(ProductInformations platformInformations) {
        try {
            Class<?> c = Class.forName("org.exoplatform.platform.edition.PlatformEdition");
            Method getEditionMethod = c.getMethod("getEdition", new Class[0]);
            String platformEdition = (String)getEditionMethod.invoke(null, new Object[0]);
            if (platformEdition != null && platformEdition.equals("enterprise") && platformInformations.getEdition() != null && !platformInformations.getEdition().equals("")) {
                platformEdition = platformInformations.getEdition();
            }
            return platformEdition;
        }
        catch (Exception e) {
            LOG.error((Object)"An error occurred while getting the platform edition information.", (Throwable)e);
            return null;
        }
    }

    public void writePingBackFormDisplayed(boolean loopfuseFormDisplayed) throws MissingProductInformationException {
        this.loopfuseFormDisplayed = loopfuseFormDisplayed;
        this.writeToFile(LOOP_FUSE_FORM_DISPLAYED, Boolean.toString(loopfuseFormDisplayed), this.getPingBackFileLocation());
    }

    public String getPingBackUrl() {
        String edition = this.getPlatformEdition(this.productInformations);
        boolean enterpriseCheck = false;
        if (edition.equalsIgnoreCase(COMMUNITY_EDITION)) {
            return this.pingBackUrl;
        }
        try {
            String loopfuseFormDisplayedString = this.readFromFile(LOOP_FUSE_FORM_DISPLAYED, this.getPingBackFileLocation());
            enterpriseCheck = Boolean.parseBoolean(loopfuseFormDisplayedString);
        }
        catch (Exception MissingProductInformationException) {
            LOG.error((Object)"Platform version detection : Error loading the version from FileSystem, the default value will be used");
        }
        if (enterpriseCheck) {
            this.pingBackUrl = this.pingBackUrl.concat("-ent");
            return this.pingBackUrl;
        }
        this.pingBackUrl = this.pingBackUrl.concat("-ex");
        return this.pingBackUrl;
    }

    private String getPingBackFileLocation() throws MissingProductInformationException {
        String edition = this.getPlatformEdition(this.productInformations);
        if (edition != null && edition.equals(COMMUNITY_EDITION)) {
            return Utils.HOME_CONFIG_LOCATION + "/" + COMMUNITY_EDITION + ".xml";
        }
        return Utils.HOME_CONFIG_FILE_LOCATION;
    }

    private void writeToFile(String key, String value, String fileLocation) {
        block10: {
            if (fileLocation == null || fileLocation.isEmpty()) {
                throw new IllegalArgumentException("Illegal empty file Location parameter.");
            }
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                Properties properties = new Properties();
                File file = new File(fileLocation);
                if (file.exists()) {
                    inputStream = new FileInputStream(fileLocation);
                    properties.loadFromXML(inputStream);
                    inputStream.close();
                } else {
                    this.verifyAndCreateParentFolder(fileLocation);
                }
                properties.put(key, value);
                outputStream = new FileOutputStream(fileLocation);
                properties.storeToXML(outputStream, "");
                outputStream.close();
            }
            catch (Exception exception) {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException ioException) {
                        LOG.error((Object)"Error during close outputStream ", (Throwable)ioException);
                    }
                }
                if (inputStream == null) break block10;
                try {
                    inputStream.close();
                }
                catch (IOException ioException) {
                    LOG.error((Object)"Error during close inputStream ", (Throwable)ioException);
                }
            }
        }
    }

    private void verifyAndCreateParentFolder(String fileLocation) {
        String parentFolderPath = fileLocation.replace("\\", "/");
        int parentFolderPathEndIndex = fileLocation.lastIndexOf("/");
        if (parentFolderPathEndIndex >= 0) {
            parentFolderPath = fileLocation.substring(0, parentFolderPathEndIndex);
        }
        if (!new File(parentFolderPath).exists()) {
            new File(parentFolderPath).mkdirs();
        }
    }
}

