/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.gadget.services.LoginHistory;

import org.exoplatform.platform.gadget.services.LoginHistory.LoginHistoryService;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;

@Asynchronous
public class LoginHistoryListener
extends Listener<ConversationRegistry, ConversationState> {
    private static final Log LOG = ExoLogger.getLogger(LoginHistoryListener.class);
    private final LoginHistoryService loginHistoryService;

    public LoginHistoryListener(LoginHistoryService loginHistoryService) throws Exception {
        this.loginHistoryService = loginHistoryService;
    }

    public void onEvent(Event<ConversationRegistry, ConversationState> event) throws Exception {
        if (this.loginHistoryService.isEnabled()) {
            String userId = ((ConversationState)event.getData()).getIdentity().getUserId();
            try {
                long now = System.currentTimeMillis();
                if (now - this.loginHistoryService.getLastLogin(userId) > 180000L) {
                    this.loginHistoryService.addLoginHistoryEntry(userId, now);
                    LOG.info((Object)("User " + userId + " logged in."));
                }
            }
            catch (Exception e) {
                LOG.debug((Object)("Error while logging the login of user '" + userId + "': " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

