/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.software.register;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.info.MissingProductInformationException;
import org.exoplatform.commons.info.ProductInformations;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.platform.common.account.setup.web.PingBackService;
import org.exoplatform.platform.common.software.register.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class UnlockService
implements Startable {
    private static final Log LOG = ExoLogger.getExoLogger(UnlockService.class);
    private String registrationFormUrl;
    private String defaultPingBackUrl;
    private String extendFormUrl;
    private String subscriptionUrl;
    private String calledUrl = null;
    private String productCode = null;
    private String keyContent;
    private boolean unlocked = false;
    private boolean showTermsandConditions = true;
    private boolean outdated = false;
    private int delayPeriod;
    private int nbDaysBeforeExpiration = 0;
    private int nbDaysAfterExpiration = 0;
    private Calendar remindDate;
    private ScheduledExecutorService executor;
    public String ERROR = "";
    private ProductInformations productInformations;
    private PingBackService pingBackService;

    public UnlockService(ProductInformations productInformations, PingBackService pingBackService, InitParams params) throws MissingProductInformationException {
        this.productInformations = productInformations;
        this.pingBackService = pingBackService;
        this.registrationFormUrl = ((ValueParam)params.get((Object)"registrationFormUrl")).getValue();
        this.defaultPingBackUrl = ((ValueParam)params.get((Object)"defaultPingBackUrl")).getValue();
        this.extendFormUrl = ((ValueParam)params.get((Object)"extendFormUrl")).getValue();
        this.subscriptionUrl = ((ValueParam)params.get((Object)"subscriptionUrl")).getValue();
        this.keyContent = ((ValueParam)params.get((Object)"KeyContent")).getValue().trim();
        String tmpValue = ((ValueParam)params.get((Object)"delayPeriod")).getValue();
        this.delayPeriod = tmpValue == null || tmpValue.isEmpty() ? 30 : Integer.parseInt(tmpValue);
        String licensePath = params.getValueParam("exo.license.path").getValue();
        Utils.HOME_CONFIG_LOCATION = Utils.EXO_HOME_FOLDER + "/" + "Platform";
        Utils.HOME_CONFIG_FILE_LOCATION = Utils.HOME_CONFIG_LOCATION + "/" + "license.xml";
        if (StringUtils.isNotBlank((String)licensePath) && !StringUtils.equals((String)licensePath, (String)Utils.HOME_CONFIG_FILE_LOCATION)) {
            this.checkCustomizeFolder(licensePath);
        }
    }

    public void start() {
        int period;
        if (!new File(Utils.HOME_CONFIG_FILE_LOCATION).exists()) {
            if (this.checkLicenceInJcr()) {
                return;
            }
            String rdate = this.computeRemindDateFromTodayBase64();
            this.productCode = this.generateProductCode();
            Utils.writeToFile("license", "", Utils.HOME_CONFIG_FILE_LOCATION);
            Utils.writeToFile("ProductCode", this.productCode, Utils.HOME_CONFIG_FILE_LOCATION);
            Utils.writeToFile("remindDate", rdate, Utils.HOME_CONFIG_FILE_LOCATION);
        }
        this.productCode = Utils.readFromFile("ProductCode", Utils.HOME_CONFIG_FILE_LOCATION);
        String unlockKey = Utils.readFromFile("license", Utils.HOME_CONFIG_FILE_LOCATION);
        if (unlockKey != null && !unlockKey.equals("") && (period = this.decodeKey(this.productCode, unlockKey)) == -1) {
            try {
                this.pingBackService.writePingBackFormDisplayed(true);
            }
            catch (MissingProductInformationException e) {
                LOG.error((Object)"Product Information not found", (Throwable)e);
            }
            this.outdated = false;
            this.unlocked = true;
            this.showTermsandConditions = false;
            return;
        }
        if (this.checkLicenceInJcr()) {
            return;
        }
        String isExtendedString = Utils.readFromFile("extension", Utils.HOME_CONFIG_FILE_LOCATION);
        if (isExtendedString != null && !isExtendedString.isEmpty()) {
            isExtendedString = new String(Base64.decodeBase64((byte[])isExtendedString.getBytes()));
            this.unlocked = Boolean.parseBoolean(isExtendedString);
        }
        String remindDateString = Utils.readFromFile("remindDate", Utils.HOME_CONFIG_FILE_LOCATION);
        try {
            this.remindDate = Utils.parseDateBase64(remindDateString);
        }
        catch (Exception e) {
            this.remindDate = Calendar.getInstance();
            this.remindDate.set(10, 23);
            this.remindDate.set(12, 59);
            this.remindDate.set(13, 59);
            this.remindDate.set(14, 59);
            this.ERROR = "your license file is incorrect, please contact our support to fix the problem";
        }
        this.computeUnlockedInformation();
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.executor.scheduleWithFixedDelay(() -> {
            this.computeUnlockedInformation();
            if (this.outdated && this.unlocked) {
                this.unlocked = false;
                Utils.writeToFile("extension", new String(Base64.encodeBase64((byte[])"false".getBytes())), Utils.HOME_CONFIG_FILE_LOCATION);
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    private void checkCustomizeFolder(String lisensePath) {
        File lisenseFile = new File(lisensePath);
        if (!StringUtils.endsWith((String)lisensePath, (String)"license.xml")) {
            if (lisenseFile.exists() && lisenseFile.mkdirs()) {
                LOG.error((Object)"The customize lisense.xml path cannot be use, default value will be applied.");
                return;
            }
            if (lisenseFile.isFile()) {
                if (lisenseFile.canWrite()) {
                    Utils.HOME_CONFIG_LOCATION = lisenseFile.getParent();
                    Utils.HOME_CONFIG_FILE_LOCATION = lisenseFile.getPath();
                }
            } else {
                Utils.HOME_CONFIG_LOCATION = lisenseFile.getPath();
                Utils.HOME_CONFIG_FILE_LOCATION = Utils.HOME_CONFIG_LOCATION + "/" + "license.xml";
            }
        } else if (lisenseFile.getParentFile().exists() && lisenseFile.canWrite() || lisenseFile.getParentFile().mkdirs()) {
            Utils.HOME_CONFIG_LOCATION = lisenseFile.getParent();
            Utils.HOME_CONFIG_FILE_LOCATION = lisenseFile.getPath();
        }
    }

    private boolean checkLicenceInJcr() {
        try {
            int period;
            String unlockKey = "";
            String pc = this.productInformations.getProductCode();
            if (pc != null && !pc.equals("")) {
                unlockKey = this.productInformations.getProductKey();
            }
            if (unlockKey != null && !unlockKey.equals("") && (period = this.decodeKey(pc, unlockKey)) == -1) {
                this.productCode = pc;
                this.outdated = false;
                this.unlocked = true;
                this.pingBackService.writePingBackFormDisplayed(true);
                this.showTermsandConditions = false;
                Utils.writeToFile("ProductCode", this.productCode, Utils.HOME_CONFIG_FILE_LOCATION);
                Utils.writeToFile("license", unlockKey, Utils.HOME_CONFIG_FILE_LOCATION);
                return true;
            }
        }
        catch (MissingProductInformationException e) {
            LOG.info((Object)"");
        }
        return false;
    }

    public void stop() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    public String computeRemindDateFromTodayBase64() {
        Calendar remindDate = Calendar.getInstance();
        remindDate.set(10, 23);
        remindDate.set(12, 59);
        remindDate.set(13, 59);
        remindDate.set(14, 59);
        remindDate.add(5, this.delayPeriod);
        return Utils.formatDateBase64(remindDate);
    }

    public ProductInformations getProductInformations() {
        return this.productInformations;
    }

    public String getRegistrationFormUrl() {
        return this.registrationFormUrl;
    }

    public String getDefaultPingBackUrl() {
        return this.defaultPingBackUrl;
    }

    public int getNbDaysBeforeExpiration() {
        return this.nbDaysBeforeExpiration;
    }

    public int getNbDaysAfterExpiration() {
        return this.nbDaysAfterExpiration;
    }

    public boolean showTermsAndConditions() {
        return this.showTermsandConditions;
    }

    public boolean isUnlocked() {
        return this.unlocked;
    }

    public void setUnlocked(boolean unlocked) {
        this.unlocked = unlocked;
    }

    public boolean isOutdated() {
        return this.outdated;
    }

    public void setOutdated(boolean outdated) {
        this.outdated = outdated;
    }

    public int getDelayPeriod() {
        return this.delayPeriod;
    }

    public void setDelayPeriod(int delayPeriod) {
        this.delayPeriod = delayPeriod;
    }

    public String getCalledUrl() {
        return this.calledUrl;
    }

    public void setCalledUrl(String calledUrl) {
        this.calledUrl = calledUrl;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public Calendar getRemindDate() {
        return this.remindDate;
    }

    public void setRemindDate(Calendar remindDate) {
        this.remindDate = remindDate;
    }

    public String generateProductCode() {
        String productCode = "Platform" + Math.random() + this.keyContent;
        return Utils.getModifiedMD5Code(productCode.getBytes());
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public void computeUnlockedInformation() {
        Calendar today = Calendar.getInstance();
        today.set(10, 0);
        today.set(12, 0);
        today.set(13, 0);
        today.set(14, 0);
        if (this.remindDate.compareTo(today) < 0) {
            this.nbDaysBeforeExpiration = 0;
            this.nbDaysAfterExpiration = (int)TimeUnit.MILLISECONDS.toDays(today.getTimeInMillis() - this.remindDate.getTimeInMillis());
            this.delayPeriod = 0;
            this.outdated = true;
        } else {
            this.outdated = false;
            this.nbDaysAfterExpiration = 0;
            this.nbDaysBeforeExpiration = (int)TimeUnit.MILLISECONDS.toDays(this.remindDate.getTimeInMillis() - today.getTimeInMillis());
        }
        if (this.outdated && this.unlocked) {
            this.unlocked = false;
            Utils.writeToFile("extension", new String(Base64.encodeBase64((byte[])"false".getBytes())), Utils.HOME_CONFIG_FILE_LOCATION);
        }
    }

    public int decodeKey(String productCode, String Key) {
        try {
            String productInfoString;
            String[] productInfo;
            StringBuffer keyBuffer = new StringBuffer(new String(Base64.decodeBase64((byte[])Key.getBytes())));
            String keyLengthString = keyBuffer.substring(8, 10);
            int length = Integer.parseInt(keyBuffer.substring(4, 6));
            keyBuffer.replace(4, 6, "");
            String productCodeHashed = keyBuffer.substring(0, length);
            if (!productCodeHashed.equals(Utils.getModifiedMD5Code(productCode.getBytes()))) {
                keyBuffer.replace(6, 8, "");
                productCodeHashed = keyBuffer.substring(0, length);
                if (!productCodeHashed.equals(Utils.getModifiedMD5Code(productCode.getBytes()))) {
                    return 0;
                }
            }
            if ((productInfo = (productInfoString = keyBuffer.substring(length)).split(",")).length == 3) {
                boolean validLicence;
                int keyLength = Integer.parseInt(keyLengthString);
                boolean bl = validLicence = keyLength == keyBuffer.toString().length() + 4;
                if (!validLicence) {
                    return 0;
                }
                String nbUser = productInfo[0];
                String duration = productInfo[1];
                String keyDate = productInfo[2];
                SimpleDateFormat d = new SimpleDateFormat("dd/MM/yyyy");
                try {
                    d.parse(keyDate);
                }
                catch (ParseException e) {
                    LOG.info((Object)"UNVALID KEY");
                    return 0;
                }
                String edition = "";
                int period = 0;
                try {
                    period = Integer.parseInt(duration);
                }
                catch (NumberFormatException exp) {
                    LOG.info((Object)"INVALID KAY");
                    return 0;
                }
                if (period == -1) {
                    duration = "UNLIMITED";
                    nbUser = new String(Base64.decodeBase64((byte[])nbUser.getBytes()));
                    int userNumber = 0;
                    try {
                        userNumber = Integer.parseInt(nbUser) / 3;
                    }
                    catch (NumberFormatException exp) {
                        LOG.info((Object)"INVALID KAY");
                        return 0;
                    }
                    if (userNumber == -1) {
                        edition = "ENTERPRISE";
                        nbUser = "UNLIMITED";
                    } else {
                        edition = "EXPRESS";
                        nbUser = String.valueOf(userNumber);
                    }
                }
                this.persistInfo(edition, nbUser, keyDate, duration, productCode, Key);
                return period;
            }
            if (productInfo.length == 1 || productInfo.length == 0) {
                String periodString = new String(Base64.decodeBase64((byte[])productInfoString.getBytes()));
                int period = Integer.parseInt(periodString) / 3;
                return period;
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private void persistInfo(String edition, String nbUser, String keyDate, String duration, String productCode, String key) {
        try {
            if (this.productInformations.getProductKey() == null || this.productInformations.getProductKey().equals("") || !productCode.equals(this.productInformations.getProductCode()) || !key.equals(this.productInformations.getProductKey())) {
                Properties p = new Properties();
                p.setProperty("edition", edition);
                p.setProperty("number of users", nbUser);
                p.setProperty("key generation date", keyDate);
                p.setProperty("delay", duration);
                p.setProperty("productCode", productCode);
                p.setProperty("productKey", key);
                this.productInformations.setUnlockInformation(p);
                this.productInformations.storeProductInformation(this.productInformations.getProductInformation());
            }
        }
        catch (MissingProductInformationException e) {
            LOG.error((Object)"Product Information not found", (Throwable)e);
        }
    }
}

