/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.gadget.services.LoginHistory.storage;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.platform.gadget.services.LoginHistory.LastLoginBean;
import org.exoplatform.platform.gadget.services.LoginHistory.LoginCounterBean;
import org.exoplatform.platform.gadget.services.LoginHistory.LoginHistoryBean;
import org.exoplatform.platform.gadget.services.LoginHistory.jpa.dao.LoginHistoryDAO;
import org.exoplatform.platform.gadget.services.LoginHistory.jpa.entity.LoginHistoryEntity;
import org.exoplatform.platform.gadget.services.LoginHistory.storage.JPALoginHistoryStorageImpl$AjcClosure1;
import org.exoplatform.platform.gadget.services.LoginHistory.storage.LoginHistoryStorage;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;

public class JPALoginHistoryStorageImpl
implements LoginHistoryStorage {
    private static final Log LOG;
    private static final int MILLIS_PER_DAY = 86400000;
    private String ALL_USERS = "AllUsers";
    private LoginHistoryDAO loginHistoryDAO;
    private ZoneId ZONE_ID = ZoneId.systemDefault();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public JPALoginHistoryStorageImpl(LoginHistoryDAO loginHistoryDAO) {
        this.loginHistoryDAO = loginHistoryDAO;
    }

    private String getUserFullName(String userId) {
        try {
            OrganizationService service = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
            return service.getUserHandler().findUserByName(userId).getFullName();
        }
        catch (Exception e) {
            return userId;
        }
    }

    private static long nextMonday(long date) {
        Instant instant = Instant.ofEpochMilli(date);
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, zoneId);
        ZonedDateTime nextMonday = zonedDateTime.with(TemporalAdjusters.next(DayOfWeek.MONDAY));
        return nextMonday.toInstant().toEpochMilli();
    }

    public List<LoginCounterBean> getLoginCountPerDaysInRange(String userId, long fromDate, long toDate) {
        ArrayList<LoginCounterBean> counterBeanList = new ArrayList<LoginCounterBean>();
        try {
            Instant instant1 = Instant.ofEpochMilli(fromDate);
            ZonedDateTime zonedDateTime1 = ZonedDateTime.ofInstant(instant1, this.ZONE_ID);
            ZonedDateTime from = zonedDateTime1.with(LocalTime.MIDNIGHT);
            Instant instant2 = Instant.ofEpochMilli(toDate);
            ZonedDateTime zonedDateTime2 = ZonedDateTime.ofInstant(instant2, this.ZONE_ID);
            ZonedDateTime to = zonedDateTime2.with(LocalTime.MAX);
            long firstDay = from.toInstant().toEpochMilli();
            Long lastDay = to.toInstant().toEpochMilli();
            while (firstDay <= lastDay) {
                LoginCounterBean loginCountPerDay = new LoginCounterBean();
                Instant instant3 = Instant.ofEpochMilli(firstDay);
                ZonedDateTime zonedDateTime3 = ZonedDateTime.ofInstant(instant3, this.ZONE_ID);
                ZonedDateTime next = zonedDateTime3.plusDays(1L);
                Long nextDay = next.toInstant().toEpochMilli();
                Instant instant4 = Instant.ofEpochMilli(firstDay);
                ZonedDateTime zonedDateTime4 = ZonedDateTime.ofInstant(instant4, this.ZONE_ID);
                ZonedDateTime end = zonedDateTime4.with(LocalTime.MAX);
                Long endOfDay = end.toInstant().toEpochMilli();
                Long count = userId.equals(this.ALL_USERS) || userId == null ? this.loginHistoryDAO.getLoginsCountInDateRange(firstDay, endOfDay) : this.loginHistoryDAO.getLoginCountPerDay(userId, firstDay, endOfDay);
                loginCountPerDay.setLoginCount(count);
                loginCountPerDay.setLoginDate(firstDay);
                counterBeanList.add(loginCountPerDay);
                firstDay = nextDay;
            }
        }
        catch (Exception e) {
            LOG.error("Error while returning the Login Count Per Days In Range of {} : ", new Object[]{userId, e.getMessage(), e});
            counterBeanList = null;
        }
        return counterBeanList;
    }

    private int getLoginCountInDateRange(String userId, long fromDate, long toDate) {
        List<LoginCounterBean> loginCounts = this.getLoginCountPerDaysInRange(userId, fromDate, toDate);
        int sum = (int)loginCounts.stream().mapToLong(LoginCounterBean::getLoginCount).sum();
        return sum;
    }

    @Override
    public long getLastLogin(String userId) {
        Long lastLogin = this.loginHistoryDAO.getLastLogin(userId);
        if (lastLogin != null) {
            return lastLogin;
        }
        return 0L;
    }

    @Override
    public List<LastLoginBean> getLastLogins(int numLogins, String userIdFilter) {
        List<LastLoginBean> lastLoginBeanList;
        String userId = userIdFilter;
        List<LoginHistoryEntity> loginHistoryEntityList = new LinkedList<LoginHistoryEntity>();
        try {
            if (numLogins != 0 && (userId == null || userId.equals("%"))) {
                List<String> users = this.loginHistoryDAO.getLastLoggedUsers(numLogins);
                for (String user : users) {
                    LoginHistoryEntity loginHistoryEntity = this.loginHistoryDAO.getLastLoginOfUser(user);
                    loginHistoryEntityList.add(loginHistoryEntity);
                }
            } else if (userId != null && !userId.equals("%")) {
                loginHistoryEntityList = numLogins == 0 ? this.loginHistoryDAO.getLastLoginsOfUser(1, userId) : this.loginHistoryDAO.getLastLoginsOfUser(numLogins, userId);
            } else {
                loginHistoryEntityList.add(this.loginHistoryDAO.getLastLoginHistory());
            }
            lastLoginBeanList = this.convertToLastLoginBeanList(loginHistoryEntityList);
        }
        catch (Exception e) {
            LOG.error("Error while retrieving last {} logins for {} : ", new Object[]{numLogins, userId, e.getMessage(), e});
            lastLoginBeanList = null;
        }
        return lastLoginBeanList;
    }

    @Override
    @ExoTransactional
    public void addLoginHistoryEntry(String userId, long loginTime) {
        String string = userId;
        long l = loginTime;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, string, Conversions.longObject((long)l), joinPoint};
        ExoTransactionalAspect.aspectOf().around(new JPALoginHistoryStorageImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    public List<LoginHistoryBean> getLoginHistory(String userId, long fromTime, long toTime) {
        List<LoginHistoryBean> loginHistoryBeanList;
        try {
            if (userId.equals(this.ALL_USERS) || userId == null) {
                List<LoginHistoryEntity> loginHistoryEntityList1 = this.loginHistoryDAO.getAllLoginHistory(fromTime, toTime);
                loginHistoryBeanList = this.convertToLoginHistoryBeanList(loginHistoryEntityList1);
            } else {
                List<LoginHistoryEntity> loginHistoryEntityList = this.loginHistoryDAO.getLoginHistory(userId, fromTime, toTime);
                loginHistoryBeanList = this.convertToLoginHistoryBeanList(loginHistoryEntityList);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error while returning Login History of " + userId + ":" + e.getMessage()), (Throwable)e);
            loginHistoryBeanList = null;
        }
        return loginHistoryBeanList;
    }

    @Override
    public Set<String> getLastUsersLogin(long fromTime) throws Exception {
        return this.loginHistoryDAO.getLastLoginsAfterDate(fromTime);
    }

    @Override
    public List<LoginCounterBean> getLoginCountPerDaysInWeek(String userId, long week) {
        ArrayList<LoginCounterBean> list = new ArrayList<LoginCounterBean>();
        ArrayList<Long> days = new ArrayList<Long>();
        long now = System.currentTimeMillis();
        long nextWeek = JPALoginHistoryStorageImpl.nextMonday(week);
        long day = week;
        do {
            LoginCounterBean loginCountPerDay = new LoginCounterBean();
            loginCountPerDay.setLoginDate(day);
            loginCountPerDay.setLoginCount(day > now ? -1L : 0L);
            list.add(loginCountPerDay);
            days.add(day);
        } while ((day += 86400000L) < nextWeek);
        long leftDays = 0L;
        for (LoginCounterBean counterBean : list) {
            leftDays += counterBean.getLoginCount();
        }
        List<LoginCounterBean> counters = this.getLoginCountPerDaysInRange(userId, week, JPALoginHistoryStorageImpl.nextMonday(week) - 86400000L + leftDays * 86400000L);
        for (LoginCounterBean loginCountPerDay : counters) {
            list.set(days.indexOf(loginCountPerDay.getLoginDate()), loginCountPerDay);
        }
        return list;
    }

    @Override
    public List<LoginCounterBean> getLoginCountPerWeeksInMonths(String userId, long fromMonth, int numOfMonths) {
        Instant instant = Instant.now();
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, this.ZONE_ID);
        long now = zonedDateTime.toInstant().toEpochMilli();
        Instant instant1 = Instant.ofEpochMilli(fromMonth);
        ZonedDateTime zonedDateTime1 = ZonedDateTime.ofInstant(instant1, this.ZONE_ID);
        ZonedDateTime zonedDateTime2 = zonedDateTime1.withMonth(numOfMonths);
        long toMonth = zonedDateTime2.toInstant().toEpochMilli();
        long toDate = fromMonth;
        ArrayList<LoginCounterBean> list = new ArrayList<LoginCounterBean>();
        do {
            long fromDate = toDate;
            if ((toDate = JPALoginHistoryStorageImpl.nextMonday(toDate)) > toMonth) {
                toDate = toMonth;
            }
            LoginCounterBean loginCountPerWeek = new LoginCounterBean();
            loginCountPerWeek.setLoginDate(fromDate);
            loginCountPerWeek.setLoginCount(fromDate > now ? -1L : (long)this.getLoginCountInDateRange(userId, fromDate, toDate - 86400000L));
            list.add(loginCountPerWeek);
        } while (toDate < toMonth);
        return list;
    }

    @Override
    public List<LoginCounterBean> getLoginCountPerMonthsInYear(String userId, long year) {
        Instant instant = Instant.now();
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, this.ZONE_ID);
        long now = zonedDateTime.toInstant().toEpochMilli();
        Instant instant1 = Instant.ofEpochMilli(year);
        ZonedDateTime zonedDateTime1 = ZonedDateTime.ofInstant(instant1, this.ZONE_ID);
        ZonedDateTime zonedDateTime2 = zonedDateTime1.withYear(1);
        long nextYear = zonedDateTime2.toInstant().toEpochMilli();
        long toDate = year;
        ArrayList<LoginCounterBean> list = new ArrayList<LoginCounterBean>();
        do {
            long fromDate = toDate;
            Instant instant2 = Instant.ofEpochMilli(toDate);
            ZonedDateTime zonedDateTime3 = ZonedDateTime.ofInstant(instant2, this.ZONE_ID);
            ZonedDateTime zonedDateTime4 = zonedDateTime3.withMonth(1);
            if ((toDate = zonedDateTime4.toInstant().toEpochMilli()) > nextYear) {
                toDate = nextYear;
            }
            LoginCounterBean loginCountPerWeek = new LoginCounterBean();
            loginCountPerWeek.setLoginDate(fromDate);
            loginCountPerWeek.setLoginCount(fromDate > now ? -1L : (long)this.getLoginCountInDateRange(userId, fromDate, toDate - 86400000L));
            list.add(loginCountPerWeek);
        } while (toDate < nextYear);
        return list;
    }

    @Override
    public long getBeforeLastLogin(String userId) throws Exception {
        return this.loginHistoryDAO.getBeforeLastLogin(userId);
    }

    private LoginHistoryBean convertToLoginHistoryBean(LoginHistoryEntity loginHistoryEntity) {
        LoginHistoryBean loginHistoryBean = new LoginHistoryBean();
        String userID = loginHistoryEntity.getUserID();
        String userName = this.getUserFullName(loginHistoryEntity.getUserID());
        long LoginTime = loginHistoryEntity.getLoginDate().getTime();
        loginHistoryBean.setUserId(userID);
        loginHistoryBean.setUserName(userName);
        loginHistoryBean.setLoginTime(LoginTime);
        return loginHistoryBean;
    }

    private LastLoginBean convertToLastLoginBean(LoginHistoryEntity loginHistoryEntity) throws Exception {
        LastLoginBean lastLoginBean = new LastLoginBean();
        String userID = loginHistoryEntity.getUserID();
        String userName = this.getUserFullName(loginHistoryEntity.getUserID());
        long lastLogin = loginHistoryEntity.getLoginDate().getTime();
        long beforeLastLogin = this.getBeforeLastLogin(loginHistoryEntity.getUserID());
        lastLoginBean.setUserId(userID);
        lastLoginBean.setUserName(userName);
        lastLoginBean.setLastLogin(lastLogin);
        lastLoginBean.setBeforeLastLogin(beforeLastLogin);
        return lastLoginBean;
    }

    private List<LoginHistoryBean> convertToLoginHistoryBeanList(List<LoginHistoryEntity> loginHistoryEntityList) {
        ArrayList<LoginHistoryBean> loginHistoryBeanList = new ArrayList<LoginHistoryBean>();
        for (LoginHistoryEntity loginHistoryEntity : loginHistoryEntityList) {
            LoginHistoryBean loginHistoryBean = this.convertToLoginHistoryBean(loginHistoryEntity);
            loginHistoryBeanList.add(loginHistoryBean);
        }
        return loginHistoryBeanList;
    }

    private List<LastLoginBean> convertToLastLoginBeanList(List<LoginHistoryEntity> loginHistoryEntityList) throws Exception {
        ArrayList<LastLoginBean> lastLoginBeanList = new ArrayList<LastLoginBean>();
        for (LoginHistoryEntity loginHistoryEntity : loginHistoryEntityList) {
            LastLoginBean lastLoginBean = this.convertToLastLoginBean(loginHistoryEntity);
            lastLoginBeanList.add(lastLoginBean);
        }
        return lastLoginBeanList;
    }

    static {
        JPALoginHistoryStorageImpl.ajc$preClinit();
        LOG = ExoLogger.getLogger(JPALoginHistoryStorageImpl.class);
    }

    static /* synthetic */ void addLoginHistoryEntry_aroundBody0(JPALoginHistoryStorageImpl ajc$this, String userId, long loginTime, JoinPoint joinPoint) {
        try {
            Date loginDate = new Date(loginTime);
            LoginHistoryEntity loginHistoryEntity = new LoginHistoryEntity(userId, loginDate);
            ajc$this.loginHistoryDAO.create(loginHistoryEntity);
        }
        catch (Exception e) {
            LOG.error("Error while adding login history for user {} : ", new Object[]{userId, e.getMessage(), e});
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JPALoginHistoryStorageImpl.java", JPALoginHistoryStorageImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addLoginHistoryEntry", "org.exoplatform.platform.gadget.services.LoginHistory.storage.JPALoginHistoryStorageImpl", "java.lang.String:long", "userId:loginTime", "", "void"), 181);
    }
}

