/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.gadget.services.LoginHistory.jpa.dao;

import java.sql.Timestamp;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.NoResultException;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.platform.gadget.services.LoginHistory.jpa.entity.LoginHistoryEntity;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class LoginHistoryDAO
extends GenericDAOJPAImpl<LoginHistoryEntity, Long> {
    private static final Log LOG = ExoLogger.getLogger(LoginHistoryDAO.class);

    public Long getLoginCountPerDay(String userId, Long fromDay, Long toDay) {
        Long count;
        Timestamp from = new Timestamp(fromDay);
        Timestamp to = new Timestamp(toDay);
        try {
            count = (Long)this.getEntityManager().createNamedQuery("loginHistory.getLoginsCountOfUserInDateRange").setParameter("userId", (Object)userId).setParameter("from", (Object)from).setParameter("to", (Object)to).getSingleResult();
        }
        catch (NoResultException e) {
            LOG.error((Object)("No login found for " + userId + "."));
            count = null;
        }
        return count;
    }

    public Long getLoginsCountInDateRange(Long fromDay, Long toDay) {
        Long count;
        Timestamp from = new Timestamp(fromDay);
        Timestamp to = new Timestamp(toDay);
        try {
            count = (Long)this.getEntityManager().createNamedQuery("loginHistory.getLoginsCountInDateRange").setParameter("from", (Object)from).setParameter("to", (Object)to).getSingleResult();
        }
        catch (NoResultException e) {
            LOG.error((Object)"No Login found.");
            count = null;
        }
        return count;
    }

    public Long getLastLogin(String userId) {
        Long lastLogin;
        try {
            LoginHistoryEntity loginHistoryEntity = (LoginHistoryEntity)this.getEntityManager().createNamedQuery("loginHistory.getLastLoginsOfUser", LoginHistoryEntity.class).setParameter("userId", (Object)userId).setMaxResults(1).getSingleResult();
            lastLogin = loginHistoryEntity.getLoginDate().getTime();
        }
        catch (Exception e) {
            lastLogin = null;
        }
        return lastLogin;
    }

    public List<LoginHistoryEntity> getLastLoginsOfUser(int numLogins, String userId) {
        List loginHistoryEntityList;
        try {
            loginHistoryEntityList = this.getEntityManager().createNamedQuery("loginHistory.getLastLoginsOfUser", LoginHistoryEntity.class).setParameter("userId", (Object)userId).setMaxResults(numLogins).getResultList();
        }
        catch (NoResultException e) {
            LOG.error((Object)("No login found for " + userId + "."));
            loginHistoryEntityList = null;
        }
        return loginHistoryEntityList;
    }

    public List<String> getLastLoggedUsers(int numLogins) {
        List lastLoggedUsers;
        try {
            List resultList = this.getEntityManager().createNamedQuery("loginHistory.getAllLoggedUsers").getResultList();
            if (resultList == null) {
                lastLoggedUsers = null;
            } else {
                List users = resultList.stream().distinct().collect(Collectors.toList());
                lastLoggedUsers = users.stream().limit(numLogins).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            LOG.error((Object)("No logged Users found: " + e.getMessage()), (Throwable)e);
            lastLoggedUsers = null;
        }
        return lastLoggedUsers;
    }

    public LoginHistoryEntity getLastLoginOfUser(String userId) {
        LoginHistoryEntity lastLogin;
        try {
            lastLogin = (LoginHistoryEntity)this.getEntityManager().createNamedQuery("loginHistory.getLastLoginsOfUser", LoginHistoryEntity.class).setParameter("userId", (Object)userId).setMaxResults(1).getSingleResult();
        }
        catch (NoResultException e) {
            lastLogin = null;
        }
        return lastLogin;
    }

    public LoginHistoryEntity getLastLoginHistory() {
        LoginHistoryEntity lastHistoryEntity;
        try {
            lastHistoryEntity = (LoginHistoryEntity)this.getEntityManager().createNamedQuery("loginHistory.getLastLoginHistory", LoginHistoryEntity.class).setMaxResults(1).getSingleResult();
        }
        catch (NoResultException e) {
            lastHistoryEntity = null;
        }
        return lastHistoryEntity;
    }

    public List<LoginHistoryEntity> getLoginHistory(String userId, long fromTime, long toTime) {
        List loginHistoryEntityList;
        Timestamp from = new Timestamp(fromTime);
        Timestamp to = new Timestamp(toTime);
        try {
            loginHistoryEntityList = this.getEntityManager().createNamedQuery("loginHistory.getLastLoginsOfUserInDateRange", LoginHistoryEntity.class).setParameter("userId", (Object)userId).setParameter("from", (Object)from).setParameter("to", (Object)to).getResultList();
        }
        catch (NoResultException e) {
            LOG.error((Object)("No login found for " + userId + "."));
            loginHistoryEntityList = null;
        }
        return loginHistoryEntityList;
    }

    public List<LoginHistoryEntity> getAllLoginHistory(long fromTime, long toTime) {
        List loginHistoryEntityList;
        Timestamp from = new Timestamp(fromTime);
        Timestamp to = new Timestamp(toTime);
        try {
            loginHistoryEntityList = this.getEntityManager().createNamedQuery("loginHistory.getLastLoginsInDateRange", LoginHistoryEntity.class).setParameter("from", (Object)from).setParameter("to", (Object)to).getResultList();
        }
        catch (NoResultException e) {
            LOG.error((Object)"No logins found.");
            loginHistoryEntityList = null;
        }
        return loginHistoryEntityList;
    }

    public Set<String> getLastLoginsAfterDate(long fromTime) {
        LinkedHashSet<String> users;
        Timestamp from = new Timestamp(fromTime);
        try {
            List userIds = this.getEntityManager().createNamedQuery("loginHistory.getLastLoginsAfterDate").setParameter("from", (Object)from).getResultList();
            users = new LinkedHashSet<String>(userIds);
        }
        catch (NoResultException e) {
            LOG.error((Object)("No login found since " + from + "."));
            users = null;
        }
        return users;
    }

    public long getBeforeLastLogin(String userId) {
        long beforeLastLogin;
        try {
            LoginHistoryEntity lastLogin = this.getLastLoginOfUser(userId);
            if (lastLogin == null) {
                beforeLastLogin = 0L;
            } else {
                Date lastLoginDate = lastLogin.getLoginDate();
                Long beforeLastLoginId = (Long)this.getEntityManager().createNamedQuery("loginHistory.getBeforeLastLoginID").setParameter("userId", (Object)userId).setParameter("lastLoginDate", (Object)lastLoginDate).getSingleResult();
                if (beforeLastLoginId == null) {
                    beforeLastLogin = 0L;
                } else {
                    LoginHistoryEntity loginHistoryEntity = (LoginHistoryEntity)this.find(beforeLastLoginId);
                    beforeLastLogin = loginHistoryEntity.getLoginDate().getTime();
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error while retrieving " + userId + "'s before last login: " + e.getMessage()), (Throwable)e);
            beforeLastLogin = 0L;
        }
        return beforeLastLogin;
    }
}

