/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.upgrade.plugins;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageService;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.pom.spi.portlet.Preference;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.SpaceStorage;

public class UpgradeSpaceHomePagePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(UpgradeSpaceHomePagePlugin.class);
    private static final String SPACE_NEW_HOME_PAGE_TEMPLATE = "custom space";
    private final OrganizationService service;
    private final SpaceStorage spaceStorage;
    private DataStorage dataStorageService = null;
    private SpaceService spaceService = null;
    private PageService pageService = null;
    private UserPortalConfigService userPortalConfigService = null;

    public UpgradeSpaceHomePagePlugin(DataStorage dataStorageService, OrganizationService organizationService, SpaceStorage spaceStorage, UserPortalConfigService userPortalConfigService, PageService pageService, InitParams initParams) {
        super(initParams);
        this.service = organizationService;
        this.dataStorageService = dataStorageService;
        this.spaceStorage = spaceStorage;
        this.pageService = pageService;
        this.userPortalConfigService = userPortalConfigService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            GroupHandler groupHandler = this.service.getGroupHandler();
            Group spacesParentGroup = this.service.getGroupHandler().findGroupById("/spaces");
            Collection spacesGroupsList = groupHandler.findGroups(spacesParentGroup);
            SessionProvider sessionProvider = SessionProvider.createSystemProvider();
            if (spacesGroupsList == null || spacesGroupsList.isEmpty()) {
                LOG.info((Object)"No space was found, no upgrade operation will be done.");
                return;
            }
            for (Group group : spacesGroupsList) {
                LOG.info((Object)("Proceed Upgrade '" + group.getId() + "' Space."));
                Space space = this.spaceStorage.getSpaceByGroupId(group.getId());
                if (space == null) {
                    LOG.warn((Object)("Cannot find space for group: " + group.getId()));
                    continue;
                }
                LOG.info((Object)("Proceed space migration: " + group.getId()));
                this.editSpaceHomePage(space.getPrettyName(), group.getId());
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error during spaces migration : " + e.getMessage()), (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editSpaceHomePage(String spacePrettyName, String spaceGroupId) {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            LOG.info((Object)("Updating '" + spaceGroupId + "' Space Home Page"));
            Page oldSpaceHomePage = this.dataStorageService.getPage(PortalConfig.GROUP_TYPE + "::" + spaceGroupId + "::" + this.getSpaceService().getSpaceApplicationConfigPlugin().getHomeApplication().getPortletName());
            PageContext pageContext = this.pageService.loadPage(PageKey.parse((String)oldSpaceHomePage.getPageId()));
            pageContext.update(oldSpaceHomePage);
            Page customSpaceHomePage = this.userPortalConfigService.createPageTemplate(SPACE_NEW_HOME_PAGE_TEMPLATE, PortalConfig.GROUP_TYPE, spaceGroupId);
            customSpaceHomePage.setTitle(oldSpaceHomePage.getTitle());
            customSpaceHomePage.setName(oldSpaceHomePage.getName());
            customSpaceHomePage.setAccessPermissions(oldSpaceHomePage.getAccessPermissions());
            customSpaceHomePage.setEditPermission(oldSpaceHomePage.getEditPermission());
            customSpaceHomePage.setOwnerType(PortalConfig.GROUP_TYPE);
            customSpaceHomePage.setOwnerId(spaceGroupId);
            this.editChildrenAccesPermisions(customSpaceHomePage.getChildren(), customSpaceHomePage.getAccessPermissions());
            this.editSpaceURLPreference(customSpaceHomePage.getChildren(), spacePrettyName);
            NavigationContext navContext = SpaceUtils.createGroupNavigation((String)spaceGroupId);
            SiteKey siteKey = navContext.getKey();
            PageKey pageKey = new PageKey(siteKey, customSpaceHomePage.getName());
            PageState pageState = new PageState(customSpaceHomePage.getTitle(), customSpaceHomePage.getDescription(), customSpaceHomePage.isShowMaxWindow(), customSpaceHomePage.getFactoryId(), customSpaceHomePage.getAccessPermissions() != null ? Arrays.asList(customSpaceHomePage.getAccessPermissions()) : null, customSpaceHomePage.getEditPermission(), customSpaceHomePage.getMoveAppsPermissions() != null ? Arrays.asList(customSpaceHomePage.getMoveAppsPermissions()) : null, customSpaceHomePage.getMoveContainersPermissions() != null ? Arrays.asList(customSpaceHomePage.getMoveContainersPermissions()) : null);
            this.pageService.savePage(new PageContext(pageKey, pageState));
            this.dataStorageService.save(customSpaceHomePage);
        }
        catch (Exception e) {
            LOG.error((Object)("Error while customizing the Space home page for space: " + spaceGroupId), (Throwable)e);
        }
        finally {
            try {
                RequestLifeCycle.end();
            }
            catch (Exception e) {
                LOG.warn((Object)("An exception has occurred while proceed RequestLifeCycle.end() : " + e.getMessage()));
            }
        }
    }

    private void editChildrenAccesPermisions(List<ModelObject> children, String[] accessPermissions) {
        if (children != null && children.size() > 0) {
            for (ModelObject modelObject : children) {
                if (modelObject instanceof Container) {
                    ((Container)modelObject).setAccessPermissions(accessPermissions);
                    this.editChildrenAccesPermisions(((Container)modelObject).getChildren(), accessPermissions);
                    continue;
                }
                if (!(modelObject instanceof Application) || !((Application)modelObject).getType().equals(ApplicationType.PORTLET)) continue;
                Application application = (Application)modelObject;
                application.setAccessPermissions(accessPermissions);
            }
        }
    }

    private void editSpaceURLPreference(List<ModelObject> children, String prefValue) throws Exception {
        if ((children == null || children.size() == 0) && LOG.isDebugEnabled()) {
            LOG.debug((Object)"Can not get a portlet application from children.\nChildren == null or have no items");
        }
        for (ModelObject modelObject : children) {
            if (modelObject instanceof Container) {
                this.editSpaceURLPreference(((Container)modelObject).getChildren(), prefValue);
                continue;
            }
            if (!(modelObject instanceof Application) || !((Application)modelObject).getType().equals(ApplicationType.PORTLET)) continue;
            Application application = (Application)modelObject;
            Portlet portletPreference = (Portlet)this.dataStorageService.load(application.getState(), ApplicationType.PORTLET);
            if (portletPreference == null) {
                portletPreference = new Portlet();
            }
            portletPreference.putPreference(new Preference("SPACE_URL", prefValue, false));
        }
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);
        }
        return this.spaceService;
    }
}

