/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.upgrade.plugins;

import java.util.ArrayList;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PageUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger((String)PageUpgradePlugin.class.getName());
    private static final String INTRANET = "intranet";
    private static final String NAVIGATION_BODY = "NavigationBody";
    private static final String LEFT_NAVIGATION = "LeftNavigation";
    private static final String BOTTOM_LEFT_NAVIGATION = "bottom-leftNavigation-container";
    private static final String ADDON_CONTAINER = "addonContainer";
    private static final String ADDON_TEMPLATE = "system:/groovy/portal/webui/container/UIAddOnContainer.gtmpl";
    private static final String CONTAINER_TEMPLATE = "system:/groovy/portal/webui/container/UIContainer.gtmpl";
    private static final String[] PERMISSION = new String[]{"*:/platform/users"};
    private static final String OFFICE_BODY = "Officebody";
    private static final String OFFICE_RIGHT = "OfficeRight";
    private static final String BOTTOM_WIKI_CONTAINER = "bottom-wiki-container";
    private static final String DOCUMENT_CONTAINER = "DocumentContainer";
    private static final String DOCUMENT_TOP_CONTAINER = "DocumentTopContainer";
    private static final String BOTTOM_DOCUMENT_CONTAINER = "bottom-document-container";
    private static final String TOP_SOCIAL_CONTAINER = "top-social-container";
    private static final String MIDDLE_SOCIAL_CONTAINER = "middle-social-container";
    private static final String TOP_APPLICATION_CONTAINER = "top-application-container";
    private static final String BOTTOM_APPLICATION_CONTAINER = "bottom-application-container";
    private static final String OFFICE_MIDDLE_CLV_CONTAINER = "OfficeMiddleCLVContainer";
    private static final String OFFICE_MIDDLE_AS_CONTAINER = "OfficeMiddleASContainer";
    private static final String OFFICE_RIGHT_MIDDLE_CONTAINER = "OfficeRightMiddle";
    private DataStorage dataStorage;

    public PageUpgradePlugin(DataStorage dataStorage, InitParams initParams) {
        super(initParams);
        this.dataStorage = dataStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
        }
        try {
            RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
            this.addTopApplicationContainer();
            this.addBottomLeftNavigationContainer();
            this.addBottomWikiContainer();
            this.addBottomDocumentContainer();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)(((Object)((Object)this)).getClass().getName() + " finished successfully!"));
            }
        }
        catch (AlreadyUpgradeException aue) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Data was already upgraded!");
                LOG.info((Object)(((Object)((Object)this)).getClass().getName() + " finished successfully!"));
            }
        }
        catch (WrongModelObjectException we) {
            if (LOG.isWarnEnabled()) {
                StringBuilder sb = new StringBuilder().append("An unexpected error occurs when migrating pages. ").append(we.getObjectId()).append(" is not found or not in its original position.").append(" If you have modified the intranet home page layout by yourself, ").append("please add the dynamic containers manually, following these links:\n").append("http://blog.exoplatform.com/en/2014/09/18/super-easy-guide-inject-portlets-wherever-want and\n").append("http://docs.exoplatform.com/public/topic/PLF41/PLFDevGuide.DevelopingApplications.").append("DevelopingPortlet.Deployment.Injection.html");
                LOG.warn((Object)sb.toString());
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"An unexpected error occurs when migrating pages:", (Throwable)e);
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private <T extends ModelObject> T getModelObject(ArrayList<ModelObject> list, Class<T> type, int position, String objectId) throws Exception {
        ModelObject rest;
        if (list != null && list.size() > position && type.isInstance(rest = list.get(position))) {
            return (T)((ModelObject)type.cast(rest));
        }
        throw new WrongModelObjectException(objectId);
    }

    private void addBottomLeftNavigationContainer() throws Exception {
        Container leftNavigation;
        PortalConfig config = this.dataStorage.getPortalConfig(INTRANET);
        Container navigationBody = this.getModelObject(config.getPortalLayout().getChildren(), Container.class, 0, NAVIGATION_BODY);
        if (NAVIGATION_BODY.equals(navigationBody.getId()) && LEFT_NAVIGATION.equals((leftNavigation = this.getModelObject(navigationBody.getChildren(), Container.class, 0, LEFT_NAVIGATION)).getId())) {
            Container bottomLeftNavigation = this.createContainer(BOTTOM_LEFT_NAVIGATION, ADDON_TEMPLATE, PERMISSION, ADDON_CONTAINER);
            ArrayList childs = leftNavigation.getChildren();
            childs.add(bottomLeftNavigation);
            leftNavigation.setChildren(childs);
            this.dataStorage.save(config);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"bottom-leftNavigation-container created!");
        }
    }

    private void addBottomWikiContainer() throws Exception {
        SiteKey siteKey = new SiteKey(SiteType.PORTAL, INTRANET);
        PageKey pageKey = new PageKey(siteKey, "wiki");
        Page page = this.dataStorage.getPage(pageKey.format());
        Container bottomWikiContainer = this.createContainer(BOTTOM_WIKI_CONTAINER, ADDON_TEMPLATE, PERMISSION, ADDON_CONTAINER);
        ArrayList children = page.getChildren();
        children.add(bottomWikiContainer);
        page.setChildren(children);
        this.dataStorage.save(page);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"bottom-wiki-container created!");
        }
    }

    private void addBottomDocumentContainer() throws Exception {
        SiteKey siteKey = new SiteKey(SiteType.PORTAL, INTRANET);
        PageKey pageKey = new PageKey(siteKey, "documents");
        Page page = this.dataStorage.getPage(pageKey.format());
        ArrayList children = page.getChildren();
        Container documentContainer = this.createContainer(DOCUMENT_CONTAINER, CONTAINER_TEMPLATE, PERMISSION, null);
        Container documentTopContainer = this.createContainer(DOCUMENT_TOP_CONTAINER, CONTAINER_TEMPLATE, PERMISSION, null);
        documentTopContainer.setChildren(children);
        Container bottomDocumentContainer = this.createContainer(BOTTOM_DOCUMENT_CONTAINER, ADDON_TEMPLATE, PERMISSION, ADDON_CONTAINER);
        ArrayList<Container> childContainers = new ArrayList<Container>();
        childContainers.add(documentTopContainer);
        childContainers.add(bottomDocumentContainer);
        documentContainer.setChildren(childContainers);
        ArrayList<Container> pageChilds = new ArrayList<Container>();
        pageChilds.add(documentContainer);
        page.setChildren(pageChilds);
        this.dataStorage.save(page);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"bottom-document-container created!");
        }
    }

    private void addTopApplicationContainer() throws Exception {
        String[] stringArray = new String[]{"homepage-demo", "homepage"};
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            ModelObject mo;
            SiteKey siteKey = new SiteKey(SiteType.PORTAL, INTRANET);
            String homepage = stringArray[i];
            PageKey pageKey = new PageKey(siteKey, homepage);
            Page page = this.dataStorage.getPage(pageKey.format());
            if (page == null) continue;
            Container officebody = this.getModelObject(page.getChildren(), Container.class, 0, "OfficeBody");
            Container officeMiddle = this.getModelObject(officebody.getChildren(), Container.class, 0, "OfficeMiddle");
            Container officeRight = this.getModelObject(officebody.getChildren(), Container.class, 1, OFFICE_RIGHT);
            ArrayList mol = officeMiddle.getChildren();
            if (mol.size() > 0 && (mo = (ModelObject)mol.get(0)) instanceof Container && TOP_SOCIAL_CONTAINER.equals(((Container)mo).getId())) {
                throw new AlreadyUpgradeException();
            }
            Application clv = this.getModelObject(officeMiddle.getChildren(), Application.class, 0, "UICLVPortlet");
            Application as = this.getModelObject(officeMiddle.getChildren(), Application.class, 1, "UIUserActivityStreamPortlet");
            ArrayList rightAppList = officeRight.getChildren();
            ArrayList<Container> middleAppContainers = new ArrayList<Container>();
            Container topSocialContainer = this.createContainer(TOP_SOCIAL_CONTAINER, ADDON_TEMPLATE, PERMISSION, ADDON_CONTAINER);
            middleAppContainers.add(topSocialContainer);
            Container officeMiddleCLVContainer = this.createContainer(OFFICE_MIDDLE_CLV_CONTAINER, CONTAINER_TEMPLATE, PERMISSION, null);
            ArrayList<Application> midCLVapp = new ArrayList<Application>();
            midCLVapp.add(clv);
            officeMiddleCLVContainer.setChildren(midCLVapp);
            middleAppContainers.add(officeMiddleCLVContainer);
            Container middleSocialContainer = this.createContainer(MIDDLE_SOCIAL_CONTAINER, ADDON_TEMPLATE, PERMISSION, ADDON_CONTAINER);
            middleAppContainers.add(middleSocialContainer);
            Container officeMiddleASContainer = this.createContainer(OFFICE_MIDDLE_AS_CONTAINER, CONTAINER_TEMPLATE, PERMISSION, null);
            ArrayList<Application> midASapp = new ArrayList<Application>();
            midASapp.add(as);
            officeMiddleASContainer.setChildren(midASapp);
            middleAppContainers.add(officeMiddleASContainer);
            officeMiddle.setChildren(middleAppContainers);
            ArrayList<Container> rightAppContainers = new ArrayList<Container>();
            Container topAppContainer = this.createContainer(TOP_APPLICATION_CONTAINER, ADDON_TEMPLATE, PERMISSION, ADDON_CONTAINER);
            rightAppContainers.add(topAppContainer);
            Container officeRightMiddleContainer = this.createContainer(OFFICE_RIGHT_MIDDLE_CONTAINER, CONTAINER_TEMPLATE, PERMISSION, null);
            officeRightMiddleContainer.setChildren(rightAppList);
            rightAppContainers.add(officeRightMiddleContainer);
            Container bottomAppContainer = this.createContainer(BOTTOM_APPLICATION_CONTAINER, ADDON_TEMPLATE, PERMISSION, ADDON_CONTAINER);
            rightAppContainers.add(bottomAppContainer);
            officeRight.setChildren(rightAppContainers);
            this.dataStorage.save(page);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"top-social-container created!");
            LOG.info((Object)"top-application-container created!");
            LOG.info((Object)"bottom-application-container created!");
        }
    }

    private Container createContainer(String id, String template, String[] permissions, String factoryId) {
        Container container = new Container();
        container.setId(id);
        container.setTemplate(template);
        container.setName(id);
        container.setAccessPermissions(permissions);
        if (factoryId != null) {
            container.setFactoryId(factoryId);
        }
        return container;
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }

    private class AlreadyUpgradeException
    extends Exception {
        private static final long serialVersionUID = 2396696144814043287L;

        private AlreadyUpgradeException() {
        }
    }

    private class WrongModelObjectException
    extends Exception {
        private static final long serialVersionUID = 6546836038718678185L;
        private String objectId;

        public WrongModelObjectException(String id) {
            this.objectId = id;
        }

        public String getObjectId() {
            return this.objectId;
        }
    }
}

