/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.upgrade.plugins;

import java.io.InputStream;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class UpgradeNotifcationNodeTypePlugin
extends UpgradeProductPlugin {
    private static Log LOG = ExoLogger.getLogger(UpgradeNotifcationNodeTypePlugin.class);

    public UpgradeNotifcationNodeTypePlugin(InitParams initParams) {
        super(initParams);
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        try {
            UpgradeNotifcationNodeTypePlugin.registerNodeTypes("jar:/conf/notification-nodetypes.xml", 0);
            LOG.info((Object)String.format("Successfully to migrate notification system from %s to %s", oldVersion, newVersion));
        }
        catch (Exception e) {
            LOG.warn((Object)String.format("Failed to migrate notification system from %s to %s", oldVersion, newVersion), (Throwable)e);
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }

    private static void registerNodeTypes(String nodeTypeFilesName, int alreadyExistsBehaviour) throws Exception {
        ConfigurationManager configurationService = (ConfigurationManager)CommonsUtils.getService(ConfigurationManager.class);
        InputStream isXml = configurationService.getInputStream(nodeTypeFilesName);
        RepositoryService repositoryService = (RepositoryService)CommonsUtils.getService(RepositoryService.class);
        ExtendedNodeTypeManager ntManager = repositoryService.getCurrentRepository().getNodeTypeManager();
        ntManager.registerNodeTypes(isXml, alreadyExistsBehaviour, "text/xml");
    }
}

