/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.navigation.component.help.impl;

import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.platform.navigation.component.help.HelpService;
import org.exoplatform.platform.navigation.component.help.Helper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class HelpServiceImpl
implements HelpService {
    private static final Log LOG = ExoLogger.getExoLogger(HelpServiceImpl.class);
    private PropertiesParam props = null;

    public HelpServiceImpl(InitParams params) {
        if (params == null) {
            throw new IllegalStateException("given params are null in helpService");
        }
        this.props = params.getPropertiesParam("help.pages");
        if (this.props == null) {
            throw new IllegalStateException("params.getPropertiesParam() returns null in helpService");
        }
    }

    @Override
    public String fetchHelpPage(String currentNavigation) {
        String helpPage = " http://docs.exoplatform.com/PLF35/index.jsp?topic=%2Forg.exoplatform.doc.35%2FUserGuide.html";
        if (this.props != null) {
            helpPage = this.props.getProperty(currentNavigation);
        }
        if (!Helper.present(helpPage)) {
            return this.getDefaultPageHelp();
        }
        return helpPage;
    }

    public String getDefaultPageHelp() {
        if (this.props != null && Helper.present(this.props.getProperty("default"))) {
            return this.props.getProperty("default");
        }
        return " http://docs.exoplatform.com/PLF35/index.jsp?topic=%2Forg.exoplatform.doc.35%2FUserGuide.html";
    }
}

