/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.gadget.services.ForumStatistics;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.forum.common.jcr.KSDataLocation;
import org.exoplatform.forum.common.jcr.PropertyReader;
import org.exoplatform.forum.common.jcr.SessionManager;
import org.exoplatform.platform.gadget.services.ForumStatistics.ForumsIntranetService;
import org.exoplatform.platform.gadget.services.ForumStatistics.TopicBean;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ForumsIntranetServiceImp
implements ForumsIntranetService {
    private static final Log LOG = ExoLogger.getLogger(ForumsIntranetServiceImp.class);
    public static final String JCR_ROOT = "/jcr:root";
    private KSDataLocation dataLocator;
    private SessionManager sessionManager;

    public ForumsIntranetServiceImp(InitParams params, KSDataLocation locator) throws Exception {
        this.dataLocator = locator;
        this.sessionManager = this.dataLocator.getSessionManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TopicBean> getTopRateTopicByUser(List<String> allInfoOfUser, int maxcount) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<TopicBean> topicBeans = new ArrayList<TopicBean>();
        try {
            long roleUser = this.getUserRoleOfForum(sProvider, allInfoOfUser.size() > 0 ? allInfoOfUser.get(0) : "");
            NodeIterator iter = this.getTopVoteTopicByUser(sProvider, roleUser <= 1L);
            while (iter.hasNext()) {
                Node node = iter.nextNode();
                if (!this.hasPermissionInForum(sProvider, node, allInfoOfUser, roleUser)) continue;
                PropertyReader reader = new PropertyReader(node);
                TopicBean bean = new TopicBean(node.getName());
                bean.setOwner(reader.string("exo:owner"));
                bean.setCreateDate(reader.date("exo:createdDate"));
                bean.setLink(reader.string("exo:link"));
                bean.setTitle(reader.string("exo:name"));
                bean.setVoteRating(reader.d("exo:voteRating"));
                bean.setNumberOfUserVoteRating(reader.list("exo:userVoteRating").size());
                topicBeans.add(bean);
                if (topicBeans.size() != maxcount) continue;
                break;
            }
        }
        catch (Exception e) {
            LOG.debug((Object)"Failed to get top voted rating topics");
        }
        finally {
            sProvider.close();
        }
        return topicBeans;
    }

    private boolean isListEmpty(List<String> list) {
        if (list == null || list.size() == 0) {
            return true;
        }
        for (String string : list) {
            if (string == null || string.trim().length() <= 0) continue;
            return false;
        }
        return true;
    }

    private long getUserRoleOfForum(SessionProvider sProvider, String userName) {
        if (userName == null || userName.trim().length() == 0) {
            return 3L;
        }
        try {
            String userPatch = this.dataLocator.getUserProfilesLocation() + "/" + userName;
            Node userNode = this.sessionManager.getSession(sProvider).getRootNode().getNode(userPatch);
            return new PropertyReader(userNode).l("exo:userRole", 3L);
        }
        catch (Exception e) {
            LOG.debug((Object)"Failed to get user role of forum.", (Throwable)e);
            return 3L;
        }
    }

    private boolean hasPermissionInForum(SessionProvider sProvider, Node topicNode, List<String> allInfoOfUser, long userRole) throws Exception {
        try {
            if (userRole == 0L) {
                return true;
            }
            Node forumNode = topicNode.getParent();
            Node categoryNode = forumNode.getParent();
            PropertyReader reader = new PropertyReader(topicNode);
            Set viewers = reader.set("exo:canView", new HashSet());
            reader = new PropertyReader(forumNode);
            if (reader.bool("exo:isClosed").booleanValue()) {
                return false;
            }
            if (userRole == 1L) {
                List moderators = reader.list("exo:moderators", new ArrayList());
                if (!this.isListEmpty(allInfoOfUser)) {
                    for (String string : moderators) {
                        if (!allInfoOfUser.contains(string)) continue;
                        return true;
                    }
                }
            }
            viewers.addAll(reader.set("exo:viewer", new HashSet()));
            reader = new PropertyReader(categoryNode);
            viewers.addAll(reader.set("exo:viewer", new HashSet()));
            viewers.addAll(reader.set("exo:userPrivate", new HashSet()));
            if (this.isListEmpty(new ArrayList<String>(viewers))) {
                return true;
            }
            if (!this.isListEmpty(allInfoOfUser)) {
                for (String string : viewers) {
                    if (!allInfoOfUser.contains(string.trim())) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            LOG.debug((Object)"Failed to checking has premission viewing topic add in forum.");
        }
        return false;
    }

    private Node getForumHomeNode(SessionProvider sProvider) throws Exception {
        String path = this.dataLocator.getForumHomeLocation();
        return this.sessionManager.getSession(sProvider).getRootNode().getNode(path);
    }

    public NodeIterator getTopVoteTopicByUser(SessionProvider sProvider, boolean isMod) throws Exception {
        try {
            Node categoryHome = this.getForumHomeNode(sProvider);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(JCR_ROOT).append(categoryHome.getPath()).append("//element(*,exo:topic)");
            if (!isMod) {
                stringBuffer.append("[@exo:isClosed='false' and @exo:isWaiting='false' and @exo:isApproved='true' and @exo:isActive='true' and @exo:isActiveByForum='true']");
            }
            stringBuffer.append(" order by @exo:voteRating descending, @exo:isSticky descending ,exo:createdDate descending");
            String pathQuery = stringBuffer.toString();
            Query query = qm.createQuery(pathQuery, "xpath");
            QueryResult result = query.execute();
            return result.getNodes();
        }
        catch (Exception e) {
            return null;
        }
    }
}

