/**
 * jqPlot
 * Pure JavaScript plotting plugin using jQuery
 *
 * Version: 1.0.0b1_r746
 *
 * Copyright (c) 2009-2011 Chris Leonello
 * jqPlot is currently available for use in all personal or commercial projects 
 * under both the MIT (http://www.opensource.org/licenses/mit-license.php) and GPL 
 * version 2.0 (http://www.gnu.org/licenses/gpl-2.0.html) licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly. 
 *
 * Although not required, the author would appreciate an email letting him 
 * know of any substantial use of jqPlot.  You can reach the author at: 
 * chris at jqplot dot com or see http://www.jqplot.com/info.php .
 *
 * If you are feeling kind and generous, consider supporting the project by
 * making a donation at: http://www.jqplot.com/donate.php .
 *
 * sprintf functions contained in jqplot.sprintf.js by Ash Searle:
 *
 *     version 2007.04.27
 *     author Ash Searle
 *     http://hexmen.com/blog/2007/03/printf-sprintf/
 *     http://hexmen.com/js/sprintf.js
 *     The author (Ash Searle) has placed this code in the public domain:
 *     "This code is unrestricted: you are free to use it however you like."
 * 
 */
(function(e){e.jqplot.PieRenderer=function(){e.jqplot.LineRenderer.call(this)};e.jqplot.PieRenderer.prototype=new e.jqplot.LineRenderer();e.jqplot.PieRenderer.prototype.constructor=e.jqplot.PieRenderer;e.jqplot.PieRenderer.prototype.init=function(o,s){this.diameter=null;this.padding=20;this.sliceMargin=0;this.fill=true;this.shadowOffset=2;this.shadowAlpha=0.07;this.shadowDepth=5;this.highlightMouseOver=true;this.highlightMouseDown=false;this.highlightColors=[];this.dataLabels="percent";this.showDataLabels=false;this.dataLabelFormatString=null;this.dataLabelThreshold=3;this.dataLabelPositionFactor=0.52;this.dataLabelNudge=2;this.dataLabelCenterOn=true;this.startAngle=0;this.tickRenderer=e.jqplot.PieTickRenderer;this._drawData=true;this._type="pie";if(o.highlightMouseDown&&o.highlightMouseOver==null){o.highlightMouseOver=false}e.extend(true,this,o);this._diameter=null;this._radius=null;this._sliceAngles=[];this._highlightedPoint=null;if(this.highlightColors.length==0){for(var q=0;q<this.seriesColors.length;q++){var p=e.jqplot.getColorComponents(this.seriesColors[q]);var m=[p[0],p[1],p[2]];var r=m[0]+m[1]+m[2];for(var n=0;n<3;n++){m[n]=(r>570)?m[n]*0.8:m[n]+0.3*(255-m[n]);m[n]=parseInt(m[n],10)}this.highlightColors.push("rgb("+m[0]+","+m[1]+","+m[2]+")")}}this.highlightColorGenerator=new e.jqplot.ColorGenerator(this.highlightColors);s.postParseOptionsHooks.addOnce(k);s.postInitHooks.addOnce(g);s.eventListenerHooks.addOnce("jqplotMouseMove",a);s.eventListenerHooks.addOnce("jqplotMouseDown",b);s.eventListenerHooks.addOnce("jqplotMouseUp",j);s.eventListenerHooks.addOnce("jqplotClick",f);s.eventListenerHooks.addOnce("jqplotRightClick",l);s.postDrawHooks.addOnce(h)};e.jqplot.PieRenderer.prototype.setGridData=function(r){var n=[];var s=[];var m=this.startAngle/180*Math.PI;var q=0;this._drawData=false;for(var p=0;p<this.data.length;p++){if(this.data[p][1]!=0){this._drawData=true}n.push(this.data[p][1]);s.push([this.data[p][0]]);if(p>0){n[p]+=n[p-1]}q+=this.data[p][1]}var o=Math.PI*2/n[n.length-1];for(var p=0;p<n.length;p++){s[p][1]=n[p]*o;s[p][2]=this.data[p][1]/q}this.gridData=s};e.jqplot.PieRenderer.prototype.makeGridData=function(r,s){var n=[];var t=[];var q=0;var m=this.startAngle/180*Math.PI;this._drawData=false;for(var p=0;p<r.length;p++){if(this.data[p][1]!=0){this._drawData=true}n.push(r[p][1]);t.push([r[p][0]]);if(p>0){n[p]+=n[p-1]}q+=r[p][1]}var o=Math.PI*2/n[n.length-1];for(var p=0;p<n.length;p++){t[p][1]=n[p]*o;t[p][2]=r[p][1]/q}return t};e.jqplot.PieRenderer.prototype.drawSlice=function(y,w,v,q,t){if(this._drawData){var n=this._diameter/2;var x=this.fill;var u=this.lineWidth;var p=this.sliceMargin;if(this.fill==false){p+=this.lineWidth}y.save();y.translate(this._center[0],this._center[1]);var A=0;if(Math.abs(v-w)>0){A=parseFloat(p)/2/Math.sin((v-w)/2)}var m=A*Math.cos((w+v)/2);var z=A*Math.sin((w+v)/2);if((v-w)<=Math.PI){n-=A}else{n+=A}y.translate(m,z);if(t){for(var s=0;s<this.shadowDepth;s++){y.save();y.translate(this.shadowOffset*Math.cos(this.shadowAngle/180*Math.PI),this.shadowOffset*Math.sin(this.shadowAngle/180*Math.PI));o(n)}}else{o(n)}}function o(r){if(v>6.282+this.startAngle){v=6.282+this.startAngle;if(w>v){w=6.281+this.startAngle}}if(w>=v){return}y.beginPath();y.fillStyle=q;y.strokeStyle=q;y.lineWidth=u;y.arc(0,0,r,w,v,false);y.lineTo(0,0);y.closePath();if(x){y.fill()}else{y.stroke()}}if(t){for(var s=0;s<this.shadowDepth;s++){y.restore()}}y.restore()};e.jqplot.PieRenderer.prototype.draw=function(M,U,t,O){var P;var J=(t!=undefined)?t:{};var q=0;var p=0;var u=1;var m=new e.jqplot.ColorGenerator(this.seriesColors);if(t.legendInfo&&t.legendInfo.placement=="insideGrid"){var I=t.legendInfo;switch(I.location){case"nw":q=I.width+I.xoffset;break;case"w":q=I.width+I.xoffset;break;case"sw":q=I.width+I.xoffset;break;case"ne":q=I.width+I.xoffset;u=-1;break;case"e":q=I.width+I.xoffset;u=-1;break;case"se":q=I.width+I.xoffset;u=-1;break;case"n":p=I.height+I.yoffset;break;case"s":p=I.height+I.yoffset;u=-1;break;default:break}}var B=(J.shadow!=undefined)?J.shadow:this.shadow;var V=(J.showLine!=undefined)?J.showLine:this.showLine;var N=(J.fill!=undefined)?J.fill:this.fill;var s=M.canvas.width;var H=M.canvas.height;var G=s-q-2*this.padding;var Q=H-p-2*this.padding;var v=Math.min(G,Q);var S=v;this._diameter=this.diameter||S;var K=this._radius=this._diameter/2;var o=this.startAngle/180*Math.PI;this._center=[(s-u*q)/2+u*q,(H-u*p)/2+u*p];this._sliceAngles=[];if(this.shadow){var L="rgba(0,0,0,"+this.shadowAlpha+")";for(var P=0;P<U.length;P++){var A=(P==0)?o:U[P-1][1]+o;this.renderer.drawSlice.call(this,M,A,U[P][1]+o,L,true)}}for(var P=0;P<U.length;P++){var A=(P==0)?o:U[P-1][1]+o;var z=U[P][1]+o;this._sliceAngles.push([A,z]);this.renderer.drawSlice.call(this,M,A,z,m.next(),false);if(this.showDataLabels&&U[P][2]*100>=this.dataLabelThreshold){var R,T=(A+z)/2,C;if(this.dataLabels=="label"){R=this.dataLabelFormatString||"%s";C=e.jqplot.sprintf(R,U[P][0])}else{if(this.dataLabels=="value"){R=this.dataLabelFormatString||"%d";C=e.jqplot.sprintf(R,this.data[P][1])}else{if(this.dataLabels=="percent"){R=this.dataLabelFormatString||"%d%%";C=e.jqplot.sprintf(R,U[P][2]*100)}else{if(this.dataLabels.constructor==Array){R=this.dataLabelFormatString||"%s";C=e.jqplot.sprintf(R,this.dataLabels[P])}}}}var n=(this._radius)*this.dataLabelPositionFactor+this.sliceMargin+this.dataLabelNudge;var F=this._center[0]+Math.cos(T)*n+this.canvas._offsets.left;var E=this._center[1]+Math.sin(T)*n+this.canvas._offsets.top;var D=e('<div class="jqplot-pie-series jqplot-data-label" style="position:absolute;">'+C+"</div>").insertBefore(O.eventCanvas._elem);if(this.dataLabelCenterOn){F-=D.width()/2;E-=D.height()/2}else{F-=D.width()*Math.sin(T/2);E-=D.height()/2}F=Math.round(F);E=Math.round(E);D.css({left:F,top:E})}}};e.jqplot.PieAxisRenderer=function(){e.jqplot.LinearAxisRenderer.call(this)};e.jqplot.PieAxisRenderer.prototype=new e.jqplot.LinearAxisRenderer();e.jqplot.PieAxisRenderer.prototype.constructor=e.jqplot.PieAxisRenderer;e.jqplot.PieAxisRenderer.prototype.init=function(m){this.tickRenderer=e.jqplot.PieTickRenderer;e.extend(true,this,m);this._dataBounds={min:0,max:100};this.min=0;this.max=100;this.showTicks=false;this.ticks=[];this.showMark=false;this.show=false};e.jqplot.PieLegendRenderer=function(){e.jqplot.TableLegendRenderer.call(this)};e.jqplot.PieLegendRenderer.prototype=new e.jqplot.TableLegendRenderer();e.jqplot.PieLegendRenderer.prototype.constructor=e.jqplot.PieLegendRenderer;e.jqplot.PieLegendRenderer.prototype.init=function(m){this.numberRows=null;this.numberColumns=null;e.extend(true,this,m)};e.jqplot.PieLegendRenderer.prototype.draw=function(){var p=this;if(this.show){var x=this._series;var A="position:absolute;";A+=(this.background)?"background:"+this.background+";":"";A+=(this.border)?"border:"+this.border+";":"";A+=(this.fontSize)?"font-size:"+this.fontSize+";":"";A+=(this.fontFamily)?"font-family:"+this.fontFamily+";":"";A+=(this.textColor)?"color:"+this.textColor+";":"";A+=(this.marginTop!=null)?"margin-top:"+this.marginTop+";":"";A+=(this.marginBottom!=null)?"margin-bottom:"+this.marginBottom+";":"";A+=(this.marginLeft!=null)?"margin-left:"+this.marginLeft+";":"";A+=(this.marginRight!=null)?"margin-right:"+this.marginRight+";":"";this._elem=e('<table class="jqplot-table-legend" style="'+A+'"></table>');var E=false,w=false,m,u;var y=x[0];var n=new e.jqplot.ColorGenerator(y.seriesColors);if(y.show){var F=y.data;if(this.numberRows){m=this.numberRows;if(!this.numberColumns){u=Math.ceil(F.length/m)}else{u=this.numberColumns}}else{if(this.numberColumns){u=this.numberColumns;m=Math.ceil(F.length/this.numberColumns)}else{m=F.length;u=1}}var D,C,o,r,q,t,v,B;var z=0;for(D=0;D<m;D++){if(w){o=e('<tr class="jqplot-table-legend"></tr>').prependTo(this._elem)}else{o=e('<tr class="jqplot-table-legend"></tr>').appendTo(this._elem)}for(C=0;C<u;C++){if(z<F.length){t=this.labels[z]||F[z][0].toString();B=n.next();if(!w){if(D>0){E=true}else{E=false}}else{if(D==m-1){E=false}else{E=true}}v=(E)?this.rowSpacing:"0";r=e('<td class="jqplot-table-legend" style="text-align:center;padding-top:'+v+';"><div><div class="jqplot-table-legend-swatch" style="border-color:'+B+';"></div></div></td>');q=e('<td class="jqplot-table-legend" style="padding-top:'+v+';"></td>');if(this.escapeHtml){q.text(t)}else{q.html(t)}if(w){q.prependTo(o);r.prependTo(o)}else{r.appendTo(o);q.appendTo(o)}E=true}z++}}}}return this._elem};e.jqplot.PieRenderer.prototype.handleMove=function(o,n,r,q,p){if(q){var m=[q.seriesIndex,q.pointIndex,q.data];p.target.trigger("jqplotDataMouseOver",m);if(p.series[m[0]].highlightMouseOver&&!(m[0]==p.plugins.pieRenderer.highlightedSeriesIndex&&m[1]==p.series[m[0]]._highlightedPoint)){p.target.trigger("jqplotDataHighlight",m);d(p,m[0],m[1])}}else{if(q==null){i(p)}}};function c(q,p,n){n=n||{};n.axesDefaults=n.axesDefaults||{};n.legend=n.legend||{};n.seriesDefaults=n.seriesDefaults||{};var m=false;if(n.seriesDefaults.renderer==e.jqplot.PieRenderer){m=true}else{if(n.series){for(var o=0;o<n.series.length;o++){if(n.series[o].renderer==e.jqplot.PieRenderer){m=true}}}}if(m){n.axesDefaults.renderer=e.jqplot.PieAxisRenderer;n.legend.renderer=e.jqplot.PieLegendRenderer;n.legend.preDraw=true;n.seriesDefaults.pointLabels={show:false}}}function g(p,o,m){for(var n=0;n<this.series.length;n++){if(this.series[n].renderer.constructor==e.jqplot.PieRenderer){if(this.series[n].highlightMouseOver){this.series[n].highlightMouseDown=false}}}this.target.bind("mouseout",{plot:this},function(q){i(q.data.plot)})}function k(m){for(var n=0;n<this.series.length;n++){this.series[n].seriesColors=this.seriesColors;this.series[n].colorGenerator=this.colorGenerator}}function d(q,p,o){var n=q.series[p];var m=q.plugins.pieRenderer.highlightCanvas;m._ctx.clearRect(0,0,m._ctx.canvas.width,m._ctx.canvas.height);n._highlightedPoint=o;q.plugins.pieRenderer.highlightedSeriesIndex=p;n.renderer.drawSlice.call(n,m._ctx,n._sliceAngles[o][0],n._sliceAngles[o][1],n.highlightColorGenerator.get(o),false)}function i(o){var m=o.plugins.pieRenderer.highlightCanvas;m._ctx.clearRect(0,0,m._ctx.canvas.width,m._ctx.canvas.height);for(var n=0;n<o.series.length;n++){o.series[n]._highlightedPoint=null}o.plugins.pieRenderer.highlightedSeriesIndex=null;o.target.trigger("jqplotDataUnhighlight")}function a(q,p,t,s,r){if(s){var o=[s.seriesIndex,s.pointIndex,s.data];var n=jQuery.Event("jqplotDataMouseOver");n.pageX=q.pageX;n.pageY=q.pageY;r.target.trigger(n,o);if(r.series[o[0]].highlightMouseOver&&!(o[0]==r.plugins.pieRenderer.highlightedSeriesIndex&&o[1]==r.series[o[0]]._highlightedPoint)){var m=jQuery.Event("jqplotDataHighlight");m.pageX=q.pageX;m.pageY=q.pageY;r.target.trigger(m,o);d(r,o[0],o[1])}}else{if(s==null){i(r)}}}function b(p,o,s,r,q){if(r){var n=[r.seriesIndex,r.pointIndex,r.data];if(q.series[n[0]].highlightMouseDown&&!(n[0]==q.plugins.pieRenderer.highlightedSeriesIndex&&n[1]==q.series[n[0]]._highlightedPoint)){var m=jQuery.Event("jqplotDataHighlight");m.pageX=p.pageX;m.pageY=p.pageY;q.target.trigger(m,n);d(q,n[0],n[1])}}else{if(r==null){i(q)}}}function j(o,n,r,q,p){var m=p.plugins.pieRenderer.highlightedSeriesIndex;if(m!=null&&p.series[m].highlightMouseDown){i(p)}}function f(p,o,s,r,q){if(r){var n=[r.seriesIndex,r.pointIndex,r.data];var m=jQuery.Event("jqplotDataClick");m.pageX=p.pageX;m.pageY=p.pageY;q.target.trigger(m,n)}}function l(q,p,t,s,r){if(s){var o=[s.seriesIndex,s.pointIndex,s.data];var m=r.plugins.pieRenderer.highlightedSeriesIndex;if(m!=null&&r.series[m].highlightMouseDown){i(r)}var n=jQuery.Event("jqplotDataRightClick");n.pageX=q.pageX;n.pageY=q.pageY;r.target.trigger(n,o)}}function h(){this.plugins.pieRenderer={highlightedSeriesIndex:null};this.plugins.pieRenderer.highlightCanvas=new e.jqplot.GenericCanvas();var n=e(this.targetId+" .jqplot-data-label");if(n.length){e(n[0]).before(this.plugins.pieRenderer.highlightCanvas.createElement(this._gridPadding,"jqplot-pieRenderer-highlight-canvas",this._plotDimensions))}else{this.eventCanvas._elem.before(this.plugins.pieRenderer.highlightCanvas.createElement(this._gridPadding,"jqplot-pieRenderer-highlight-canvas",this._plotDimensions))}var m=this.plugins.pieRenderer.highlightCanvas.setContext()}e.jqplot.preInitHooks.push(c);e.jqplot.PieTickRenderer=function(){e.jqplot.AxisTickRenderer.call(this)};e.jqplot.PieTickRenderer.prototype=new e.jqplot.AxisTickRenderer();e.jqplot.PieTickRenderer.prototype.constructor=e.jqplot.PieTickRenderer})(jQuery);