/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.welcomescreens.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class Utils {
    public static final String UNLIMITED = "UNLIMITED";
    private static final Log LOG = ExoLogger.getLogger(Utils.class);
    public static final int DEFAULT_DELAY_PERIOD = 30;
    public static final String REMIND_DATE = "remindDate";
    public static final String IS_EXTENDED = "extension";
    public static final String PRODUCT_KEY = "license";
    public static final String USER_HOME = System.getProperty("user.home");
    public static final String EXO_HOME_FOLDER = USER_HOME + "/.eXo";
    public static final String PRODUCT_NAME = "Platform";
    public static final DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    public static final String PRODUCT_CODE = "ProductCode";
    public static String HOME_CONFIG_FILE_LOCATION;

    public static String getModifiedMD5Code(byte[] dataToHash) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Provider provBC = Security.getProvider("BC");
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("MD5", provBC);
        }
        catch (NoSuchAlgorithmException exception) {
            throw new RuntimeException(exception);
        }
        digest.update(dataToHash);
        byte[] hashMD5 = digest.digest(dataToHash);
        StringBuffer hashMD5String = new StringBuffer();
        for (int i = 0; i < hashMD5.length; ++i) {
            int n = i;
            hashMD5[n] = (byte)(hashMD5[n] % 26);
            hashMD5[i] = (byte)Math.abs(hashMD5[i]);
            int n2 = i;
            hashMD5[n2] = (byte)(hashMD5[n2] + 64);
            hashMD5String.append((char)hashMD5[i]);
        }
        return hashMD5String.toString();
    }

    public static String readFromFile(String key, String fileLocation) {
        if (fileLocation == null || fileLocation.isEmpty() || !new File(fileLocation).exists()) {
            throw new IllegalArgumentException("Illegal file Location parameter: " + fileLocation);
        }
        try {
            Properties properties = new Properties();
            FileInputStream inputStream = new FileInputStream(fileLocation);
            properties.loadFromXML(inputStream);
            ((InputStream)inputStream).close();
            return (String)properties.get(key);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static String formatDate(Calendar date) {
        return dateFormat.format(date.getTime());
    }

    public static void writeRemindDate(String remindDateStringBase64, String fileLocation) {
        Utils.writeToFile(REMIND_DATE, remindDateStringBase64, fileLocation);
    }

    public static Calendar parseDateBase64(String dateString) {
        try {
            dateString = new String(Base64.decodeBase64((byte[])dateString.getBytes()));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(dateFormat.parse(dateString));
            return calendar;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static String formatDateBase64(Calendar date) {
        return new String(Base64.encodeBase64((byte[])Utils.formatDate(date).getBytes()));
    }

    public static void writeToFile(String key, String value, String fileLocation) {
        block10: {
            if (fileLocation == null || fileLocation.isEmpty()) {
                throw new IllegalArgumentException("Illegal empty file Location parameter.");
            }
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                Properties properties = new Properties();
                File file = new File(fileLocation);
                if (file.exists()) {
                    inputStream = new FileInputStream(fileLocation);
                    properties.loadFromXML(inputStream);
                    inputStream.close();
                } else {
                    Utils.verifyAndCreateParentFolder(fileLocation);
                }
                properties.put(key, value);
                outputStream = new FileOutputStream(fileLocation);
                properties.storeToXML(outputStream, "");
                outputStream.close();
            }
            catch (Exception exception) {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException ioException) {
                        LOG.error((Object)"Error during close outputStream ", (Throwable)ioException);
                    }
                }
                if (inputStream == null) break block10;
                try {
                    inputStream.close();
                }
                catch (IOException ioException) {
                    LOG.error((Object)"Error during close inputStream ", (Throwable)ioException);
                }
            }
        }
    }

    private static void verifyAndCreateParentFolder(String fileLocation) {
        String parentFolderPath = fileLocation.replace("\\", "/");
        int parentFolderPathEndIndex = fileLocation.lastIndexOf("/");
        if (parentFolderPathEndIndex >= 0) {
            parentFolderPath = fileLocation.substring(0, parentFolderPathEndIndex);
        }
        if (!new File(parentFolderPath).exists()) {
            new File(parentFolderPath).mkdirs();
        }
    }
}

