/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.welcomescreens.service.impl;

import javax.jcr.Node;
import org.chromattic.api.ChromatticSession;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.platform.welcomescreens.service.TermsAndConditionsService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class TermsAndConditionsServiceImpl
implements TermsAndConditionsService {
    private static Log logger = ExoLogger.getLogger(TermsAndConditionsServiceImpl.class);
    private static final String CHROMATTIC_LIFECYCLE_NAME = "termsandconditions";
    private static final String TC_NODE_NAME = "TermsAndConditions";
    private ChromatticLifeCycle lifeCycle;
    private NodeHierarchyCreator nodeHierarchyCreator;
    private static boolean hasTermsAndConditionsNode = false;

    public ChromatticSession getSession() {
        return this.lifeCycle.getChromattic().openSession();
    }

    public TermsAndConditionsServiceImpl(ChromatticManager chromatticManager, NodeHierarchyCreator nodeHierarchyCreator) {
        this.lifeCycle = chromatticManager.getLifeCycle(CHROMATTIC_LIFECYCLE_NAME);
        this.nodeHierarchyCreator = nodeHierarchyCreator;
    }

    @Override
    public boolean isTermsAndConditionsChecked() {
        boolean isChecked = false;
        if (this.hasTermsAndConditions()) {
            isChecked = true;
        }
        return isChecked;
    }

    @Override
    public void checkTermsAndConditions() {
        if (this.lifeCycle.getContext() == null) {
            this.lifeCycle.openContext();
        }
        if (!this.hasTermsAndConditions()) {
            this.createTermsAndConditions();
        } else {
            logger.debug((Object)"Terms and conditions: yet checked");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTermsAndConditions() {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            Node publicApplicationNode = this.nodeHierarchyCreator.getPublicApplicationNode(sessionProvider);
            if (!publicApplicationNode.hasNode(TC_NODE_NAME)) {
                publicApplicationNode = publicApplicationNode.addNode(TC_NODE_NAME, "nt:folder");
                publicApplicationNode.addMixin("mix:referenceable");
                publicApplicationNode.getSession().save();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Terms and conditions: cannot create node", (Throwable)e);
        }
        finally {
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasTermsAndConditions() {
        SessionProvider sessionProvider = null;
        try {
            if (hasTermsAndConditionsNode) {
                return hasTermsAndConditionsNode;
            }
            try {
                sessionProvider = SessionProvider.createSystemProvider();
                Node publicApplicationNode = this.nodeHierarchyCreator.getPublicApplicationNode(sessionProvider);
                hasTermsAndConditionsNode = publicApplicationNode.hasNode(TC_NODE_NAME);
            }
            catch (Exception E) {
                logger.error((Object)"Terms and conditions: connot get node", (Throwable)E);
                hasTermsAndConditionsNode = false;
            }
            finally {
                sessionProvider.close();
            }
            return hasTermsAndConditionsNode;
        }
        catch (Exception e) {
            logger.error((Object)"Terms and conditions: cannot check node", (Throwable)e);
            return hasTermsAndConditionsNode;
        }
    }
}

