/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.welcomescreens.service;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.exoplatform.commons.info.MissingProductInformationException;
import org.exoplatform.commons.info.ProductInformations;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.platform.common.account.setup.web.PingBackServlet;
import org.exoplatform.platform.welcomescreens.service.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.filter.Filter;
import org.picocontainer.Startable;

public class UnlockService
implements Startable {
    private static final Log LOG = ExoLogger.getExoLogger(UnlockService.class);
    private static String registrationFormUrl = null;
    private static String defaultPingBackUrl = null;
    private static String extendFormUrl = null;
    private static String subscriptionUrl = null;
    private static String calledUrl = null;
    private static String productCode = null;
    private static String KEY_CONTENT = null;
    private static boolean isUnlocked = false;
    private static boolean showTermsandConditions = true;
    private static boolean outdated = false;
    private static int delayPeriod = 30;
    private static int nbDaysBeforeExpiration = 0;
    private static int nbDaysAfterExpiration = 0;
    private static Calendar remindDate;
    public static String restContext;
    private static ScheduledExecutorService executor;
    private static ProductInformations productInformations;
    public static String ERROR;

    public UnlockService(ProductInformations productInformations, InitParams params) throws MissingProductInformationException {
        restContext = ExoContainerContext.getCurrentContainer().getContext().getRestContextName();
        UnlockService.productInformations = productInformations;
        registrationFormUrl = ((ValueParam)params.get((Object)"registrationFormUrl")).getValue();
        defaultPingBackUrl = ((ValueParam)params.get((Object)"defaultPingBackUrl")).getValue();
        extendFormUrl = ((ValueParam)params.get((Object)"extendFormUrl")).getValue();
        subscriptionUrl = ((ValueParam)params.get((Object)"subscriptionUrl")).getValue();
        KEY_CONTENT = ((ValueParam)params.get((Object)"KeyContent")).getValue().trim();
        String tmpValue = ((ValueParam)params.get((Object)"delayPeriod")).getValue();
        delayPeriod = tmpValue == null || tmpValue.isEmpty() ? 30 : Integer.parseInt(tmpValue);
        Utils.HOME_CONFIG_FILE_LOCATION = Utils.EXO_HOME_FOLDER + "/" + "Platform" + "/license.xml";
    }

    public void start() {
        int period;
        if (!new File(Utils.HOME_CONFIG_FILE_LOCATION).exists()) {
            if (this.checkLicenceInJcr()) {
                return;
            }
            String rdate = UnlockService.computeRemindDateFromTodayBase64();
            productCode = UnlockService.generateProductCode();
            Utils.writeToFile("license", "", Utils.HOME_CONFIG_FILE_LOCATION);
            Utils.writeToFile("ProductCode", productCode, Utils.HOME_CONFIG_FILE_LOCATION);
            Utils.writeToFile("remindDate", rdate, Utils.HOME_CONFIG_FILE_LOCATION);
        }
        productCode = Utils.readFromFile("ProductCode", Utils.HOME_CONFIG_FILE_LOCATION);
        String unlockKey = Utils.readFromFile("license", Utils.HOME_CONFIG_FILE_LOCATION);
        if (unlockKey != null && !unlockKey.equals("") && (period = UnlockService.decodeKey(productCode, unlockKey)) == -1) {
            try {
                PingBackServlet.writePingBackFormDisplayed((boolean)true);
            }
            catch (MissingProductInformationException e) {
                LOG.error("Product Information not found ", new Object[]{e.getLocalizedMessage()});
            }
            outdated = false;
            isUnlocked = true;
            showTermsandConditions = false;
            return;
        }
        if (this.checkLicenceInJcr()) {
            return;
        }
        String isExtendedString = Utils.readFromFile("extension", Utils.HOME_CONFIG_FILE_LOCATION);
        if (isExtendedString != null && !isExtendedString.isEmpty()) {
            isExtendedString = new String(Base64.decodeBase64((byte[])isExtendedString.getBytes()));
            isUnlocked = Boolean.parseBoolean(isExtendedString);
        }
        String remindDateString = Utils.readFromFile("remindDate", Utils.HOME_CONFIG_FILE_LOCATION);
        try {
            remindDate = Utils.parseDateBase64(remindDateString);
        }
        catch (Exception e) {
            remindDate = Calendar.getInstance();
            remindDate.set(10, 23);
            remindDate.set(12, 59);
            remindDate.set(13, 59);
            remindDate.set(14, 59);
            ERROR = "your license file is incorrect, please contact our support to fix the problem";
        }
        UnlockService.computeUnlockedInformation();
        executor = Executors.newSingleThreadScheduledExecutor();
        executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                UnlockService.computeUnlockedInformation();
                if (outdated && isUnlocked) {
                    isUnlocked = false;
                    Utils.writeToFile("extension", new String(Base64.encodeBase64((byte[])"false".getBytes())), Utils.HOME_CONFIG_FILE_LOCATION);
                }
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    private boolean checkLicenceInJcr() {
        try {
            int period;
            String unlockKey = "";
            String pc = productInformations.getProductCode();
            if (pc != null && !pc.equals("")) {
                unlockKey = productInformations.getProductKey();
            }
            if (unlockKey != null && !unlockKey.equals("") && (period = UnlockService.decodeKey(pc, unlockKey)) == -1) {
                productCode = pc;
                outdated = false;
                isUnlocked = true;
                PingBackServlet.writePingBackFormDisplayed((boolean)true);
                showTermsandConditions = false;
                Utils.writeToFile("ProductCode", productCode, Utils.HOME_CONFIG_FILE_LOCATION);
                Utils.writeToFile("license", unlockKey, Utils.HOME_CONFIG_FILE_LOCATION);
                return true;
            }
        }
        catch (MissingProductInformationException e) {
            LOG.info((Object)"");
        }
        return false;
    }

    public void stop() {
        if (executor != null) {
            executor.shutdown();
        }
    }

    public static String computeRemindDateFromTodayBase64() {
        Calendar remindDate = Calendar.getInstance();
        remindDate.set(10, 23);
        remindDate.set(12, 59);
        remindDate.set(13, 59);
        remindDate.set(14, 59);
        remindDate.add(5, delayPeriod);
        return Utils.formatDateBase64(remindDate);
    }

    public static String getRegistrationFormUrl() {
        return registrationFormUrl;
    }

    public static int getNbDaysBeforeExpiration() {
        return nbDaysBeforeExpiration;
    }

    public static int getNbDaysAfterExpiration() {
        return nbDaysAfterExpiration;
    }

    public static boolean showTermsAndConditions() {
        return showTermsandConditions;
    }

    public static String getSubscriptionUrl() {
        return subscriptionUrl;
    }

    public static boolean isUnlocked() {
        return isUnlocked;
    }

    public static boolean isOutdated() {
        return outdated;
    }

    public static ScheduledExecutorService getExecutor() {
        return executor;
    }

    public static String getCalledUrl() {
        return calledUrl;
    }

    public static String getExtendFormUrl() {
        return extendFormUrl;
    }

    public static String getProductCode() {
        return productCode;
    }

    private static String generateProductCode() {
        String productCode = "Platform" + Math.random() + KEY_CONTENT;
        return Utils.getModifiedMD5Code(productCode.getBytes());
    }

    private static void computeUnlockedInformation() {
        Calendar today = Calendar.getInstance();
        today.set(10, 0);
        today.set(12, 0);
        today.set(13, 0);
        today.set(14, 0);
        if (remindDate.compareTo(today) < 0) {
            nbDaysBeforeExpiration = 0;
            nbDaysAfterExpiration = (int)TimeUnit.MILLISECONDS.toDays(today.getTimeInMillis() - remindDate.getTimeInMillis());
            delayPeriod = 0;
            outdated = true;
        } else {
            outdated = false;
            nbDaysAfterExpiration = 0;
            nbDaysBeforeExpiration = (int)TimeUnit.MILLISECONDS.toDays(remindDate.getTimeInMillis() - today.getTimeInMillis());
        }
        if (outdated && isUnlocked) {
            isUnlocked = false;
            Utils.writeToFile("extension", new String(Base64.encodeBase64((byte[])"false".getBytes())), Utils.HOME_CONFIG_FILE_LOCATION);
        }
    }

    private static int decodeKey(String productCode, String Key) {
        try {
            String productInfoString;
            String[] productInfo;
            StringBuffer keyBuffer = new StringBuffer(new String(Base64.decodeBase64((byte[])Key.getBytes())));
            String keyLengthString = keyBuffer.substring(8, 10);
            int length = Integer.parseInt(keyBuffer.substring(4, 6));
            keyBuffer.replace(4, 6, "");
            String productCodeHashed = keyBuffer.substring(0, length);
            if (!productCodeHashed.equals(Utils.getModifiedMD5Code(productCode.getBytes()))) {
                keyBuffer.replace(6, 8, "");
                productCodeHashed = keyBuffer.substring(0, length);
                if (!productCodeHashed.equals(Utils.getModifiedMD5Code(productCode.getBytes()))) {
                    return 0;
                }
            }
            if ((productInfo = (productInfoString = keyBuffer.substring(length)).split(",")).length == 3) {
                boolean validLicence;
                int keyLength = Integer.parseInt(keyLengthString);
                boolean bl = validLicence = keyLength == keyBuffer.toString().length() + 4;
                if (!validLicence) {
                    return 0;
                }
                String nbUser = productInfo[0];
                String duration = productInfo[1];
                String keyDate = productInfo[2];
                SimpleDateFormat d = new SimpleDateFormat("dd/MM/yyyy");
                try {
                    d.parse(keyDate);
                }
                catch (ParseException e) {
                    LOG.info((Object)"UNVALID KEY");
                    return 0;
                }
                String edition = "";
                int period = 0;
                try {
                    period = Integer.parseInt(duration);
                }
                catch (NumberFormatException exp) {
                    LOG.info((Object)"INVALID KAY");
                    return 0;
                }
                if (period == -1) {
                    duration = "UNLIMITED";
                    nbUser = new String(Base64.decodeBase64((byte[])nbUser.getBytes()));
                    int userNumber = 0;
                    try {
                        userNumber = Integer.parseInt(nbUser) / 3;
                    }
                    catch (NumberFormatException exp) {
                        LOG.info((Object)"INVALID KAY");
                        return 0;
                    }
                    if (userNumber == -1) {
                        edition = "ENTERPRISE";
                        nbUser = "UNLIMITED";
                    } else {
                        edition = "EXPRESS";
                        nbUser = String.valueOf(userNumber);
                    }
                }
                UnlockService.persistInfo(edition, nbUser, keyDate, duration, productCode, Key);
                return period;
            }
            if (productInfo.length == 1 || productInfo.length == 0) {
                String periodString = new String(Base64.decodeBase64((byte[])productInfoString.getBytes()));
                int period = Integer.parseInt(periodString) / 3;
                return period;
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static void persistInfo(String edition, String nbUser, String keyDate, String duration, String productCode, String key) {
        try {
            if (productInformations.getProductKey() == null || productInformations.getProductKey().equals("") || !productCode.equals(productInformations.getProductCode()) || !key.equals(productInformations.getProductKey())) {
                Properties p = new Properties();
                p.setProperty("edition", edition);
                p.setProperty("number of users", nbUser);
                p.setProperty("key generation date", keyDate);
                p.setProperty("delay", duration);
                p.setProperty("productCode", productCode);
                p.setProperty("productKey", key);
                productInformations.setUnlockInformation(p);
                productInformations.storeUnlockInformation();
            }
        }
        catch (MissingProductInformationException e) {
            LOG.error("Product Information not found ", new Object[]{e.getLocalizedMessage()});
        }
    }

    static {
        ERROR = "";
    }

    public static class UnlockServlet
    extends HttpServlet {
        private static final long serialVersionUID = -4806814673109318163L;

        protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String rdate = null;
            String hashMD5Added = request.getParameter("hashMD5");
            String pc = request.getParameter("pc");
            boolean callPingBack = false;
            String productEdition = "";
            if (hashMD5Added != null) {
                int delay;
                try {
                    delay = pc != null && !pc.equals(productCode) ? UnlockService.decodeKey(pc, hashMD5Added) : UnlockService.decodeKey(productCode, hashMD5Added);
                }
                catch (Exception exception) {
                    delay = 0;
                }
                if (delay > -1 && delay <= 0) {
                    request.setAttribute("errorMessage", (Object)"Sorry this evaluation key is not valid.");
                    request.getRequestDispatcher("WEB-INF/jsp/welcome-screens/unlockTrial.jsp").include((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                try {
                    productEdition = productInformations.getEdition();
                }
                catch (MissingProductInformationException MPIE) {
                    LOG.error((Object)"[Unlock Service] : cannot load le platform edition from JCR ", (Throwable)MPIE);
                    productEdition = "EXPRESS";
                }
                if (delay == -1) {
                    if (pc != null && !pc.equals(productCode)) {
                        productCode = pc;
                    }
                    Utils.writeToFile("license", hashMD5Added, Utils.HOME_CONFIG_FILE_LOCATION);
                    Utils.writeToFile("ProductCode", productCode, Utils.HOME_CONFIG_FILE_LOCATION);
                    outdated = false;
                    isUnlocked = true;
                    if (!callPingBack && productEdition.equalsIgnoreCase("ENTERPRISE") && this.callPingBack()) {
                        LOG.info((Object)("[Ping Back] : call to " + defaultPingBackUrl.concat("-ent") + " is done succesfully "));
                        callPingBack = true;
                    }
                    if (UnlockService.getExecutor() != null) {
                        executor.shutdown();
                    }
                    response.sendRedirect(calledUrl);
                    return;
                }
                delayPeriod = delay;
                productCode = UnlockService.generateProductCode();
                Utils.writeToFile("ProductCode", productCode, Utils.HOME_CONFIG_FILE_LOCATION);
                outdated = false;
                rdate = UnlockService.computeRemindDateFromTodayBase64();
                try {
                    remindDate = Utils.parseDateBase64(rdate);
                    UnlockService.computeUnlockedInformation();
                    if (!outdated) {
                        Utils.writeRemindDate(rdate, Utils.HOME_CONFIG_FILE_LOCATION);
                        Utils.writeToFile("extension", new String(Base64.encodeBase64((byte[])"true".getBytes())), Utils.HOME_CONFIG_FILE_LOCATION);
                        isUnlocked = true;
                    }
                    if (!callPingBack && productEdition.equalsIgnoreCase("ENTERPRISE") && this.callPingBack()) {
                        LOG.info((Object)("[Ping Back] : call to " + defaultPingBackUrl.concat("-ent") + " is done succesfully "));
                        callPingBack = true;
                    }
                    response.sendRedirect(calledUrl);
                    return;
                }
                catch (Exception exception) {
                    response.sendRedirect(calledUrl);
                    return;
                }
            }
            if (!UnlockService.isUnlocked()) {
                request.getRequestDispatcher("WEB-INF/jsp/welcome-screens/unlockTrial.jsp").include((ServletRequest)request, (ServletResponse)response);
            } else {
                response.sendRedirect("/portal/intranet");
            }
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            this.doPost(request, response);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean callPingBack() {
            String pingServerURL = defaultPingBackUrl.concat("-ent");
            URL url = null;
            HttpURLConnection urlConn = null;
            try {
                url = new URL(pingServerURL);
                urlConn = (HttpURLConnection)url.openConnection();
                urlConn.connect();
                boolean bl = 404 != urlConn.getResponseCode();
                return bl;
            }
            catch (MalformedURLException e) {
                LOG.error((Object)("[Ping Back Call] : Error creating HTTP connection to  : " + pingServerURL));
            }
            catch (IOException e) {
                LOG.error((Object)("[Ping Back Call] : Error creating HTTP connection to : " + pingServerURL));
            }
            finally {
                urlConn.disconnect();
                LOG.info((Object)("[Ping Back Call] : connection to [" + pingServerURL + "] is released"));
            }
            return false;
        }
    }

    public static class UnlockFilter
    implements Filter {
        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            boolean isIgnoringRequest = this.isIgnoredRequest(httpServletRequest.getSession(true).getServletContext(), httpServletRequest.getRequestURI());
            if (!isIgnoringRequest) {
                calledUrl = httpServletRequest.getRequestURI();
            }
            chain.doFilter(request, response);
        }

        private boolean isIgnoredRequest(ServletContext context, String url) {
            String fileName = url.substring(url.indexOf("/"));
            String mimeType = context.getMimeType(fileName);
            return mimeType != null || url.contains(restContext);
        }
    }
}

