/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.welcomescreens.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.platform.common.software.register.UnlockService;
import org.exoplatform.platform.welcomescreens.service.TermsAndConditionsService;
import org.exoplatform.web.filter.Filter;

public class TermsAndConditionsFilter
implements Filter {
    private static final String PLF_WELCOME_SCREENS_SERVLET_CTX = "/trial";
    private static final String TC_SERVLET_URL = "/terms-and-conditions";
    private static final String INITIAL_URI_PARAM_NAME = "initialURI";
    private static final String LOGIN_URI = "/login";
    private static final String DOLOGIN_URI = "/dologin";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        TermsAndConditionsService termsAndConditionsService = (TermsAndConditionsService)PortalContainer.getInstance().getComponentInstanceOfType(TermsAndConditionsService.class);
        UnlockService unlockService = (UnlockService)PortalContainer.getInstance().getComponentInstanceOfType(UnlockService.class);
        boolean tcChecked = termsAndConditionsService.isTermsAndConditionsChecked();
        String requestUri = httpServletRequest.getRequestURI();
        String loginRequestUri = httpServletRequest.getContextPath() + LOGIN_URI;
        String dologinRequestUri = httpServletRequest.getContextPath() + DOLOGIN_URI;
        boolean isLoginUri = requestUri.contains(loginRequestUri) || requestUri.contains(dologinRequestUri);
        boolean isRestUri = requestUri.contains(ExoContainerContext.getCurrentContainer().getContext().getRestContextName());
        boolean isDevMod = PropertyManager.isDevelopping();
        if (!(isLoginUri || isRestUri || tcChecked || isDevMod || !unlockService.showTermsAndConditions())) {
            String reqUri = httpServletRequest.getRequestURI().toString();
            String queryString = httpServletRequest.getQueryString();
            if (queryString != null) {
                reqUri = new StringBuffer(reqUri).append("?").append(queryString).toString();
            }
            ServletContext welcomrScreensContext = httpServletRequest.getSession().getServletContext().getContext(PLF_WELCOME_SCREENS_SERVLET_CTX);
            String uriTarget = "/terms-and-conditions?initialURI=" + reqUri;
            welcomrScreensContext.getRequestDispatcher(uriTarget).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        chain.doFilter(request, response);
    }
}

