/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.application.registry.jcr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.logging.Log;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategoriesPlugins;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.application.registry.jcr.DataMapper;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.registry.RegistryEntry;
import org.exoplatform.services.jcr.ext.registry.RegistryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.portletcontainer.PortletContainerService;
import org.exoplatform.web.WebAppController;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationRegistryServiceImpl
implements ApplicationRegistryService,
Startable {
    private static final String APPLICATION_REGISTRY = "ApplicationRegistry";
    private static final String CATEGORY_DATA = "CategoryData";
    private static final String APPLICATIONS = "applications";
    private Log log = ExoLogger.getLogger((String)"ApplicationRegistryService");
    RegistryService regService_;
    DataMapper mapper_ = new DataMapper();
    private List<ApplicationCategoriesPlugins> plugins;

    public ApplicationRegistryServiceImpl(RegistryService service) throws Exception {
        this.regService_ = service;
    }

    @Override
    public List<ApplicationCategory> getApplicationCategories(String accessUser, String ... appTypes) throws Exception {
        List<ApplicationCategory> categories = this.getApplicationCategories();
        Iterator<ApplicationCategory> cateItr = categories.iterator();
        PortalContainer container = PortalContainer.getInstance();
        OrganizationService orgService = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
        UserACL acl = (UserACL)container.getComponentInstanceOfType(UserACL.class);
        while (cateItr.hasNext()) {
            ApplicationCategory cate = cateItr.next();
            List<Application> applications = this.getApplications(cate, appTypes);
            Iterator<Application> appIterator = applications.iterator();
            while (appIterator.hasNext()) {
                Application app = appIterator.next();
                if (this.hasAccessPermission(orgService, acl, accessUser, app)) continue;
                appIterator.remove();
            }
            if (applications.size() > 0) {
                cate.setApplications(applications);
                continue;
            }
            cateItr.remove();
        }
        return categories;
    }

    @Override
    public List<ApplicationCategory> getApplicationCategories() throws Exception {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        Node regNode = this.regService_.getRegistry(sessionProvider).getNode();
        Session session = regNode.getSession();
        StringBuilder builder = new StringBuilder("select * from exo:registryEntry");
        this.generateScript(builder, "jcr:path", regNode.getPath() + "/" + "exo:applications" + "/" + APPLICATION_REGISTRY + "/%");
        this.generateScript(builder, "exo:type", ApplicationCategory.class.getSimpleName());
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(builder.toString(), "sql");
        QueryResult result = query.execute();
        NodeIterator itr = result.getNodes();
        ArrayList<ApplicationCategory> categories = new ArrayList<ApplicationCategory>();
        while (itr.hasNext()) {
            Node cateNode = itr.nextNode();
            String entryPath = cateNode.getPath().substring(regNode.getPath().length() + 1);
            RegistryEntry entry = this.regService_.getEntry(sessionProvider, entryPath);
            ApplicationCategory cate = this.mapper_.toApplicationCategory(entry.getDocument());
            categories.add(cate);
        }
        sessionProvider.close();
        return categories;
    }

    private void generateScript(StringBuilder sql, String name, String value) {
        if (value == null || value.length() < 1) {
            return;
        }
        if (sql.indexOf(" where") < 0) {
            sql.append(" where ");
        } else {
            sql.append(" and ");
        }
        value = value.replace('*', '%');
        sql.append(name).append(" like '").append(value).append("'");
    }

    @Override
    public ApplicationCategory getApplicationCategory(String name) throws Exception {
        RegistryEntry entry;
        String categoryDataPath = this.getCategoryPath(name) + "/" + CATEGORY_DATA;
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            entry = this.regService_.getEntry(sessionProvider, categoryDataPath);
        }
        catch (PathNotFoundException ie) {
            sessionProvider.close();
            return null;
        }
        ApplicationCategory category = this.mapper_.toApplicationCategory(entry.getDocument());
        sessionProvider.close();
        return category;
    }

    @Override
    public void save(ApplicationCategory category) throws Exception {
        RegistryEntry entry;
        String categoryPath = this.getCategoryPath(category.getName());
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            entry = this.regService_.getEntry(sessionProvider, categoryPath + "/" + CATEGORY_DATA);
        }
        catch (PathNotFoundException ie) {
            entry = new RegistryEntry(CATEGORY_DATA);
            this.regService_.createEntry(sessionProvider, categoryPath, entry);
        }
        this.mapper_.map(entry.getDocument(), category);
        this.regService_.recreateEntry(sessionProvider, categoryPath, entry);
        sessionProvider.close();
    }

    @Override
    public void remove(ApplicationCategory category) throws Exception {
        String categoryDataPath = this.getCategoryPath(category.getName()) + "/" + CATEGORY_DATA;
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        for (Application app : this.getApplications(category, new String[0])) {
            this.remove(app);
        }
        this.regService_.removeEntry(sessionProvider, categoryDataPath);
        sessionProvider.close();
    }

    @Override
    public List<Application> getAllApplications() throws Exception {
        ArrayList<Application> applications = new ArrayList<Application>();
        List<ApplicationCategory> categories = this.getApplicationCategories();
        for (ApplicationCategory cate : categories) {
            applications.addAll(this.getApplications(cate, new String[0]));
        }
        return applications;
    }

    @Override
    public Application getApplication(String id) throws Exception {
        RegistryEntry entry;
        String[] fragments = id.split("/");
        if (fragments.length < 2) {
            throw new Exception("Invalid Application Id: [" + id + "]");
        }
        String applicationPath = this.getCategoryPath(fragments[0]) + "/" + APPLICATIONS + "/" + fragments[1];
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            entry = this.regService_.getEntry(sessionProvider, applicationPath);
        }
        catch (PathNotFoundException ie) {
            sessionProvider.close();
            return null;
        }
        Application application = this.mapper_.toApplication(entry.getDocument());
        sessionProvider.close();
        return application;
    }

    @Override
    public Application getApplication(String category, String name) throws Exception {
        RegistryEntry entry;
        String applicationPath = this.getCategoryPath(category) + "/" + APPLICATIONS + "/" + name;
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            entry = this.regService_.getEntry(sessionProvider, applicationPath);
        }
        catch (PathNotFoundException ie) {
            sessionProvider.close();
            return null;
        }
        Application application = this.mapper_.toApplication(entry.getDocument());
        sessionProvider.close();
        return application;
    }

    @Override
    public List<Application> getApplications(ApplicationCategory category, String ... appTypes) throws Exception {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        Node regNode = this.regService_.getRegistry(sessionProvider).getNode();
        Session session = regNode.getSession();
        StringBuilder builder = new StringBuilder("select * from exo:registryEntry");
        this.generateScript(builder, "jcr:path", regNode.getPath() + "/" + "exo:applications" + "/" + APPLICATION_REGISTRY + "/%");
        this.generateScript(builder, "exo:type", Application.class.getSimpleName());
        this.generateScript(builder, "exo:categoryName", category.getName());
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(builder.toString(), "sql");
        QueryResult result = query.execute();
        NodeIterator itr = result.getNodes();
        ArrayList<Application> applications = new ArrayList<Application>();
        while (itr.hasNext()) {
            Node appNode = itr.nextNode();
            String entryPath = appNode.getPath().substring(regNode.getPath().length() + 1);
            RegistryEntry entry = this.regService_.getEntry(sessionProvider, entryPath);
            Application app = this.mapper_.toApplication(entry.getDocument());
            if (!this.isApplicationType(app, appTypes)) continue;
            applications.add(app);
        }
        sessionProvider.close();
        return applications;
    }

    @Override
    public void importExoWidgets() throws Exception {
        PortalContainer container = PortalContainer.getInstance();
        WebAppController appController = (WebAppController)container.getComponentInstanceOfType(WebAppController.class);
        List eXoWidgets = appController.getApplicationByType("eXoWidget");
        if (eXoWidgets == null || eXoWidgets.size() < 1) {
            return;
        }
        org.exoplatform.web.application.Application sampleApp = (org.exoplatform.web.application.Application)eXoWidgets.get(0);
        ApplicationCategory category = this.getApplicationCategory(sampleApp.getApplicationGroup());
        if (category == null) {
            category = new ApplicationCategory();
            category.setName(sampleApp.getApplicationGroup());
            category.setDisplayName(sampleApp.getApplicationGroup());
            category.setDescription(sampleApp.getApplicationGroup());
            this.save(category);
        }
        for (org.exoplatform.web.application.Application ele : eXoWidgets) {
            Application app = this.getApplication(category.getName() + "/" + ele.getApplicationName());
            if (app != null) continue;
            this.save(category, this.convertApplication(ele));
        }
    }

    private Application convertApplication(org.exoplatform.web.application.Application app) {
        Application returnApplication = new Application();
        returnApplication.setApplicationGroup(app.getApplicationGroup());
        returnApplication.setApplicationType(app.getApplicationType());
        returnApplication.setApplicationName(app.getApplicationName());
        returnApplication.setCategoryName(app.getApplicationGroup());
        returnApplication.setDisplayName(app.getApplicationName());
        returnApplication.setDescription(app.getDescription());
        return returnApplication;
    }

    @Override
    public void importAllPortlets() throws Exception {
        PortalContainer manager = PortalContainer.getInstance();
        PortletContainerService pcService = (PortletContainerService)manager.getComponentInstanceOfType(PortletContainerService.class);
        Map allPortletMetaData = pcService.getAllPortletMetaData();
        for (String portletHandle : allPortletMetaData.keySet()) {
            Application app;
            String categoryName = portletHandle.split("/")[0];
            String portletName = portletHandle.split("/")[1];
            ApplicationCategory category = null;
            category = this.getApplicationCategory(categoryName);
            if (category == null) {
                category = new ApplicationCategory();
                category.setName(categoryName);
                category.setDisplayName(categoryName);
                this.save(category);
            }
            if ((app = this.getApplication(categoryName + "/" + portletName)) != null) continue;
            app = new Application();
            app.setDisplayName(portletName);
            app.setApplicationName(portletName);
            app.setApplicationGroup(categoryName);
            app.setCategoryName(categoryName);
            app.setApplicationType("portlet");
            app.setDescription("A portlet application");
            app.setDisplayName(portletName);
            this.save(category, app);
        }
    }

    @Override
    public void remove(Application app) throws Exception {
        String applicationPath = this.getCategoryPath(app.getCategoryName()) + "/" + APPLICATIONS + "/" + app.getApplicationName();
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        this.regService_.removeEntry(sessionProvider, applicationPath);
        sessionProvider.close();
    }

    @Override
    public void save(ApplicationCategory category, Application application) throws Exception {
        RegistryEntry entry;
        String cateName = category.getName();
        String categoryPath = this.getCategoryPath(cateName);
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            entry = this.regService_.getEntry(sessionProvider, categoryPath + "/" + CATEGORY_DATA);
        }
        catch (PathNotFoundException ie) {
            entry = new RegistryEntry(CATEGORY_DATA);
            this.mapper_.map(entry.getDocument(), category);
            this.regService_.createEntry(sessionProvider, categoryPath, entry);
        }
        application.setCategoryName(cateName);
        String applicationSetPath = this.getCategoryPath(cateName) + "/" + APPLICATIONS;
        String appName = application.getApplicationName();
        try {
            entry = this.regService_.getEntry(sessionProvider, applicationSetPath + "/" + appName);
        }
        catch (PathNotFoundException ie) {
            entry = new RegistryEntry(appName);
            this.regService_.createEntry(sessionProvider, applicationSetPath, entry);
        }
        this.mapper_.map(entry.getDocument(), application);
        this.regService_.recreateEntry(sessionProvider, applicationSetPath, entry);
        sessionProvider.close();
    }

    @Override
    public void update(Application application) throws Exception {
        String applicationSetPath = this.getCategoryPath(application.getCategoryName()) + "/" + APPLICATIONS;
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        RegistryEntry entry = this.regService_.getEntry(sessionProvider, applicationSetPath + "/" + application.getApplicationName());
        this.mapper_.map(entry.getDocument(), application);
        this.regService_.recreateEntry(sessionProvider, applicationSetPath, entry);
        sessionProvider.close();
    }

    @Override
    public void clearAllRegistries() throws Exception {
        for (ApplicationCategory cate : this.getApplicationCategories()) {
            this.remove(cate);
        }
    }

    @Override
    public void initListener(ComponentPlugin com) throws Exception {
        if (com instanceof ApplicationCategoriesPlugins) {
            if (this.plugins == null) {
                this.plugins = new ArrayList<ApplicationCategoriesPlugins>();
            }
            this.plugins.add((ApplicationCategoriesPlugins)com);
        }
    }

    public void start() {
        try {
            if (this.plugins == null) {
                return;
            }
            for (ApplicationCategoriesPlugins plugin : this.plugins) {
                plugin.run();
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
    }

    public void stop() {
    }

    private boolean hasAccessPermission(OrganizationService orgService, UserACL acl, String remoteUser, Application app) throws Exception {
        if (acl.getSuperUser().equals(remoteUser)) {
            return true;
        }
        ArrayList<String> permissions = app.getAccessPermissions();
        if (permissions == null) {
            return false;
        }
        for (String ele : permissions) {
            if (!this.hasViewPermission(orgService, acl, remoteUser, ele)) continue;
            return true;
        }
        return false;
    }

    private boolean hasViewPermission(OrganizationService orgService, UserACL acl, String remoteUser, String expPerm) throws Exception {
        if ("Everyone".equals(expPerm)) {
            return true;
        }
        String[] temp = expPerm.split(":");
        if (temp.length < 2) {
            return false;
        }
        String membership = temp[0].trim();
        String groupId = temp[1].trim();
        MembershipHandler handler = orgService.getMembershipHandler();
        if (membership == null || "*".equals(membership)) {
            Collection c = handler.findMembershipsByUserAndGroup(remoteUser, groupId);
            if (c == null) {
                return false;
            }
            return c.size() > 0;
        }
        return handler.findMembershipByUserGroupAndType(remoteUser, groupId, membership) != null;
    }

    private String getCategoryPath(String categoryName) {
        return "exo:applications/ApplicationRegistry/" + categoryName;
    }

    private boolean isApplicationType(Application app, String ... appTypes) {
        if (appTypes == null || appTypes.length < 1) {
            return true;
        }
        for (String appType : appTypes) {
            if (!appType.equals(app.getApplicationType())) continue;
            return true;
        }
        return false;
    }
}

