/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.application.gadget.jcr;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.exoplatform.application.gadget.Source;
import org.exoplatform.application.gadget.SourceStorage;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;

public class SourceStorageImpl
implements SourceStorage {
    private static final String NT_UNSTRUCTURED = "nt:unstructured";
    private static final String NT_FOLDER = "nt:folder";
    private static final String JCR_DATA = "jcr:data";
    private static final String JCR_MIME = "jcr:mimeType";
    private static final String JCR_ENCODING = "jcr:encoding";
    private static final String JCR_MODIFIED = "jcr:lastModified";
    private RepositoryService repoService;
    private String repo;
    private String wsName;
    private String homePath;

    public SourceStorageImpl(InitParams params, RepositoryService service) throws Exception {
        PropertiesParam properties = params.getPropertiesParam("location");
        if (properties == null) {
            throw new Exception("The 'location' properties parameter is expected.");
        }
        this.repo = properties.getProperty("repository");
        this.wsName = properties.getProperty("workspace");
        this.homePath = this.reproduceDirPath(properties.getProperty("store.path"));
        this.repoService = service;
    }

    public Source getSource(String sourcePath) throws Exception {
        Node sourceNode;
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        Session session = sessionProvider.getSession(this.wsName, this.repoService.getRepository(this.repo));
        String fullPath = this.homePath + sourcePath;
        try {
            sourceNode = (Node)session.getItem(fullPath + "/jcr:content");
        }
        catch (PathNotFoundException pnfe) {
            sessionProvider.close();
            return null;
        }
        String[] strs = sourcePath.split("/");
        String name = strs[strs.length - 1];
        Source source = this.toSource(name, sourceNode);
        sessionProvider.close();
        return source;
    }

    public void saveSource(String dirPath, Source source) throws Exception {
        Node contentNode;
        String storePath;
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        if (dirPath == null || dirPath.trim().length() < 1) {
            storePath = this.homePath;
        } else {
            storePath = this.homePath + dirPath;
            this.createStructure(sessionProvider, dirPath);
        }
        Session session = sessionProvider.getSession(this.wsName, this.repoService.getRepository(this.repo));
        Node storeNode = (Node)session.getItem(storePath);
        String fileName = source.getName();
        if (!storeNode.hasNode(fileName)) {
            Node fileNode = storeNode.addNode(fileName, "nt:file");
            contentNode = fileNode.addNode("jcr:content", "nt:resource");
        } else {
            contentNode = storeNode.getNode(fileName + "/jcr:content");
        }
        this.map(contentNode, source);
        session.save();
        sessionProvider.close();
    }

    public void removeSource(String sourcePath) throws Exception {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        Session session = sessionProvider.getSession(this.wsName, this.repoService.getRepository(this.repo));
        String fullPath = this.homePath + sourcePath;
        Node sourceNode = (Node)session.getItem(fullPath);
        sourceNode.remove();
        session.save();
        sessionProvider.close();
    }

    public String getSourceURI(String sourcePath) {
        StringBuilder path = new StringBuilder(30);
        path.append("jcr/").append(this.repo).append("/").append(this.wsName).append(this.homePath).append(sourcePath);
        return path.toString();
    }

    private void createStructure(SessionProvider sessionProvider, String dirPath) throws Exception {
        Session session = sessionProvider.getSession(this.wsName, this.repoService.getRepository(this.repo));
        String[] dirs = dirPath.split("/");
        String parentPath = this.homePath;
        for (String name : dirs) {
            String path = parentPath + name + "/";
            try {
                Node node = (Node)session.getItem(path);
                if (!node.isNodeType(NT_UNSTRUCTURED) && !node.isNodeType(NT_FOLDER)) {
                    throw new Exception("Node at " + path + " should be " + NT_UNSTRUCTURED + " or " + NT_FOLDER + " type.");
                }
            }
            catch (PathNotFoundException pnfe) {
                Node parentNode = (Node)session.getItem(parentPath);
                parentNode.addNode(name, NT_FOLDER);
                parentNode.save();
            }
            parentPath = path;
        }
    }

    private Source toSource(String name, Node node) throws Exception {
        Source source = new Source(name);
        source.setMimeType(node.getProperty(JCR_MIME).getString());
        source.setEncoding(node.getProperty(JCR_ENCODING).getString());
        source.setStreamContent(node.getProperty(JCR_DATA).getStream());
        source.setLastModified(node.getProperty(JCR_MODIFIED).getDate());
        return source;
    }

    private void map(Node node, Source source) throws Exception {
        node.setProperty(JCR_MIME, source.getMimeType());
        node.setProperty(JCR_ENCODING, source.getEncoding());
        node.setProperty(JCR_DATA, source.getStreamContent());
        node.setProperty(JCR_MODIFIED, source.getLastModified());
    }

    private String reproduceDirPath(String path) {
        if (path.endsWith("/")) {
            return path;
        }
        return path + "/";
    }
}

