/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.application.registry.jcr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.logging.Log;
import org.exoplatform.application.gadget.Gadget;
import org.exoplatform.application.gadget.GadgetRegistryService;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategoriesPlugins;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.application.registry.jcr.DataMapper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.registry.RegistryEntry;
import org.exoplatform.services.jcr.ext.registry.RegistryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.portletcontainer.PortletContainerService;
import org.exoplatform.services.portletcontainer.pci.PortletData;
import org.exoplatform.services.portletcontainer.pci.model.Description;
import org.exoplatform.services.portletcontainer.pci.model.DisplayName;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationRegistryServiceImpl
implements ApplicationRegistryService,
Startable {
    private static final String APPLICATION_REGISTRY = "ApplicationRegistry";
    private static final String CATEGORY_DATA = "CategoryData";
    private static final String APPLICATIONS = "applications";
    private Log log = ExoLogger.getLogger((String)"ApplicationRegistryService");
    RegistryService regService_;
    DataMapper mapper_ = new DataMapper();
    private List<ApplicationCategoriesPlugins> plugins;

    public ApplicationRegistryServiceImpl(RegistryService service) throws Exception {
        this.regService_ = service;
    }

    @Override
    public List<ApplicationCategory> getApplicationCategories(String accessUser, String ... appTypes) throws Exception {
        List<ApplicationCategory> categories = this.getApplicationCategories();
        Iterator<ApplicationCategory> cateItr = categories.iterator();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        OrganizationService orgService = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
        UserACL acl = (UserACL)container.getComponentInstanceOfType(UserACL.class);
        while (cateItr.hasNext()) {
            ApplicationCategory cate = cateItr.next();
            if (!this.hasAccessPermission(orgService, acl, accessUser, cate)) {
                cateItr.remove();
                continue;
            }
            List<Application> applications = this.getApplications(cate, appTypes);
            Iterator<Application> appIterator = applications.iterator();
            while (appIterator.hasNext()) {
                Application app = appIterator.next();
                if (this.hasAccessPermission(orgService, acl, accessUser, app)) continue;
                appIterator.remove();
            }
            cate.setApplications(applications);
        }
        return categories;
    }

    @Override
    public List<ApplicationCategory> getApplicationCategories() throws Exception {
        return this.getApplicationCategories(null);
    }

    @Override
    public List<ApplicationCategory> getApplicationCategories(Comparator<ApplicationCategory> sortComparator) throws Exception {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        Node regNode = this.regService_.getRegistry(sessionProvider).getNode();
        Session session = regNode.getSession();
        StringBuilder builder = new StringBuilder("select * from exo:registryEntry");
        this.generateScript(builder, "jcr:path", regNode.getPath() + "/" + "exo:applications" + "/" + APPLICATION_REGISTRY + "/%");
        this.generateScript(builder, "exo:type", ApplicationCategory.class.getSimpleName());
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(builder.toString(), "sql");
        QueryResult result = query.execute();
        NodeIterator itr = result.getNodes();
        ArrayList<ApplicationCategory> categories = new ArrayList<ApplicationCategory>();
        while (itr.hasNext()) {
            Node cateNode = itr.nextNode();
            String entryPath = cateNode.getPath().substring(regNode.getPath().length() + 1);
            RegistryEntry entry = this.regService_.getEntry(sessionProvider, entryPath);
            ApplicationCategory cate = this.mapper_.toApplicationCategory(entry.getDocument());
            categories.add(cate);
        }
        sessionProvider.close();
        if (sortComparator != null) {
            Collections.sort(categories, sortComparator);
        }
        return categories;
    }

    private void generateScript(StringBuilder sql, String name, String value) {
        if (value == null || value.length() < 1) {
            return;
        }
        if (sql.indexOf(" where") < 0) {
            sql.append(" where ");
        } else {
            sql.append(" and ");
        }
        value = value.replace('*', '%');
        sql.append(name).append(" like '").append(value).append("'");
    }

    @Override
    public ApplicationCategory getApplicationCategory(String name) throws Exception {
        RegistryEntry entry;
        String categoryDataPath = this.getCategoryPath(name) + "/" + CATEGORY_DATA;
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            entry = this.regService_.getEntry(sessionProvider, categoryDataPath);
        }
        catch (PathNotFoundException ie) {
            sessionProvider.close();
            return null;
        }
        ApplicationCategory category = this.mapper_.toApplicationCategory(entry.getDocument());
        sessionProvider.close();
        return category;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(ApplicationCategory category) throws Exception {
        String categoryPath = this.getCategoryPath(category.getName());
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            RegistryEntry entry;
            try {
                entry = this.regService_.getEntry(sessionProvider, categoryPath + "/" + CATEGORY_DATA);
            }
            catch (PathNotFoundException ie) {
                entry = new RegistryEntry(CATEGORY_DATA);
                this.regService_.createEntry(sessionProvider, categoryPath, entry);
            }
            this.mapper_.map(entry.getDocument(), category);
            this.regService_.recreateEntry(sessionProvider, categoryPath, entry);
        }
        finally {
            sessionProvider.close();
        }
    }

    @Override
    public void remove(ApplicationCategory category) throws Exception {
        String categoryDataPath = this.getCategoryPath(category.getName()) + "/" + CATEGORY_DATA;
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        for (Application app : this.getApplications(category, new String[0])) {
            this.remove(app);
        }
        this.regService_.removeEntry(sessionProvider, categoryDataPath);
        sessionProvider.close();
    }

    @Override
    public List<Application> getAllApplications() throws Exception {
        ArrayList<Application> applications = new ArrayList<Application>();
        List<ApplicationCategory> categories = this.getApplicationCategories();
        for (ApplicationCategory cate : categories) {
            applications.addAll(this.getApplications(cate, new String[0]));
        }
        return applications;
    }

    @Override
    public Application getApplication(String id) throws Exception {
        RegistryEntry entry;
        String[] fragments = id.split("/");
        if (fragments.length < 2) {
            throw new Exception("Invalid Application Id: [" + id + "]");
        }
        String applicationPath = this.getCategoryPath(fragments[0]) + "/" + APPLICATIONS + "/" + fragments[1];
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            entry = this.regService_.getEntry(sessionProvider, applicationPath);
        }
        catch (PathNotFoundException ie) {
            sessionProvider.close();
            return null;
        }
        Application application = this.mapper_.toApplication(entry.getDocument());
        sessionProvider.close();
        return application;
    }

    @Override
    public Application getApplication(String category, String name) throws Exception {
        RegistryEntry entry;
        String applicationPath = this.getCategoryPath(category) + "/" + APPLICATIONS + "/" + name;
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            entry = this.regService_.getEntry(sessionProvider, applicationPath);
        }
        catch (PathNotFoundException ie) {
            sessionProvider.close();
            return null;
        }
        Application application = this.mapper_.toApplication(entry.getDocument());
        sessionProvider.close();
        return application;
    }

    @Override
    public List<Application> getApplications(ApplicationCategory category, String ... appTypes) throws Exception {
        return this.getApplications(category, (Comparator<Application>)null, appTypes);
    }

    @Override
    public List<Application> getApplications(ApplicationCategory category, Comparator<Application> sortComparator, String ... appTypes) throws Exception {
        Node appsNode;
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        Node regNode = this.regService_.getRegistry(sessionProvider).getNode();
        Session session = regNode.getSession();
        String appsPath = regNode.getPath() + "/" + this.getCategoryPath(category.getName()) + "/" + APPLICATIONS;
        try {
            appsNode = (Node)session.getItem(appsPath);
        }
        catch (PathNotFoundException pnfe) {
            sessionProvider.close();
            return new ArrayList<Application>();
        }
        NodeIterator itr = appsNode.getNodes();
        ArrayList<Application> applications = new ArrayList<Application>();
        while (itr.hasNext()) {
            Node appNode = itr.nextNode();
            String entryPath = appNode.getPath().substring(regNode.getPath().length() + 1);
            RegistryEntry entry = this.regService_.getEntry(sessionProvider, entryPath);
            Application app = this.mapper_.toApplication(entry.getDocument());
            if (!this.isApplicationType(app, appTypes)) continue;
            applications.add(app);
        }
        sessionProvider.close();
        if (sortComparator != null) {
            Collections.sort(applications, sortComparator);
        }
        return applications;
    }

    @Override
    public void importExoGadgets() throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        GadgetRegistryService gadgetService = (GadgetRegistryService)container.getComponentInstanceOfType(GadgetRegistryService.class);
        List<Gadget> eXoGadgets = gadgetService.getAllGadgets();
        if (eXoGadgets == null || eXoGadgets.size() < 1) {
            return;
        }
        ArrayList<String> permissions = new ArrayList<String>();
        permissions.add("Everyone");
        String categoryName = "eXoGadgets";
        ApplicationCategory category = this.getApplicationCategory(categoryName);
        if (category == null) {
            category = new ApplicationCategory();
            category.setName(categoryName);
            category.setDisplayName(categoryName);
            category.setDescription(categoryName);
            category.setAccessPermissions(permissions);
            this.save(category);
        }
        for (Gadget ele : eXoGadgets) {
            Application app = this.getApplication(category.getName() + "/" + ele.getName());
            if (app != null) continue;
            app = this.convertApplication(ele);
            app.setAccessPermissions(permissions);
            this.save(category, app);
        }
    }

    @Override
    public void importAllPortlets() throws Exception {
        ExoContainer manager = ExoContainerContext.getCurrentContainer();
        PortletContainerService pcService = (PortletContainerService)manager.getComponentInstanceOfType(PortletContainerService.class);
        Map allPortletMetaData = pcService.getAllPortletMetaData();
        for (Map.Entry entry : allPortletMetaData.entrySet()) {
            Application app;
            String portletHandle = (String)entry.getKey();
            String categoryName = portletHandle.split("/")[0];
            String portletName = portletHandle.split("/")[1];
            ApplicationCategory category = null;
            category = this.getApplicationCategory(categoryName);
            if (category == null) {
                category = new ApplicationCategory();
                category.setName(categoryName);
                category.setDisplayName(categoryName);
                this.save(category);
            }
            if ((app = this.getApplication(categoryName + "/" + portletName)) != null) continue;
            PortletData portlet = (PortletData)entry.getValue();
            app = new Application();
            app.setApplicationName(portletName);
            app.setApplicationGroup(categoryName);
            app.setCategoryName(categoryName);
            app.setApplicationType("portlet");
            app.setDisplayName(this.getDisplayNameValue(portlet.getDisplayName(), portletName));
            app.setDescription(this.getDescriptionValue(portlet.getDescription(), portletName));
            this.save(category, app);
        }
    }

    @Override
    public void remove(Application app) throws Exception {
        String applicationPath = this.getCategoryPath(app.getCategoryName()) + "/" + APPLICATIONS + "/" + app.getApplicationName();
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        this.regService_.removeEntry(sessionProvider, applicationPath);
        sessionProvider.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(ApplicationCategory category, Application application) throws Exception {
        String cateName = category.getName();
        String categoryPath = this.getCategoryPath(cateName);
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            RegistryEntry entry;
            try {
                entry = this.regService_.getEntry(sessionProvider, categoryPath + "/" + CATEGORY_DATA);
            }
            catch (PathNotFoundException ie) {
                entry = new RegistryEntry(CATEGORY_DATA);
                this.mapper_.map(entry.getDocument(), category);
                this.regService_.createEntry(sessionProvider, categoryPath, entry);
            }
            application.setCategoryName(cateName);
            String applicationSetPath = this.getCategoryPath(cateName) + "/" + APPLICATIONS;
            String appName = application.getApplicationName();
            try {
                entry = this.regService_.getEntry(sessionProvider, applicationSetPath + "/" + appName);
            }
            catch (PathNotFoundException ie) {
                entry = new RegistryEntry(appName);
                this.regService_.createEntry(sessionProvider, applicationSetPath, entry);
            }
            this.mapper_.map(entry.getDocument(), application);
            this.regService_.recreateEntry(sessionProvider, applicationSetPath, entry);
        }
        finally {
            sessionProvider.close();
        }
    }

    @Override
    public void update(Application application) throws Exception {
        String applicationSetPath = this.getCategoryPath(application.getCategoryName()) + "/" + APPLICATIONS;
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        RegistryEntry entry = this.regService_.getEntry(sessionProvider, applicationSetPath + "/" + application.getApplicationName());
        this.mapper_.map(entry.getDocument(), application);
        this.regService_.recreateEntry(sessionProvider, applicationSetPath, entry);
        sessionProvider.close();
    }

    @Override
    public void clearAllRegistries() throws Exception {
        for (ApplicationCategory cate : this.getApplicationCategories()) {
            this.remove(cate);
        }
    }

    @Override
    public void initListener(ComponentPlugin com) throws Exception {
        if (com instanceof ApplicationCategoriesPlugins) {
            if (this.plugins == null) {
                this.plugins = new ArrayList<ApplicationCategoriesPlugins>();
            }
            this.plugins.add((ApplicationCategoriesPlugins)com);
        }
    }

    public void start() {
        try {
            if (this.plugins == null) {
                return;
            }
            for (ApplicationCategoriesPlugins plugin : this.plugins) {
                plugin.run();
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
    }

    public void stop() {
    }

    private boolean hasAccessPermission(OrganizationService orgService, UserACL acl, String remoteUser, Application app) throws Exception {
        if (acl.getSuperUser().equals(remoteUser)) {
            return true;
        }
        ArrayList<String> permissions = app.getAccessPermissions();
        if (permissions == null) {
            return false;
        }
        for (String ele : permissions) {
            if (!this.hasViewPermission(orgService, acl, remoteUser, ele)) continue;
            return true;
        }
        return false;
    }

    private boolean hasAccessPermission(OrganizationService orgService, UserACL acl, String remoteUser, ApplicationCategory app) throws Exception {
        if (acl.getSuperUser().equals(remoteUser)) {
            return true;
        }
        ArrayList<String> permissions = app.getAccessPermissions();
        if (permissions == null) {
            return false;
        }
        for (String ele : permissions) {
            if (!this.hasViewPermission(orgService, acl, remoteUser, ele)) continue;
            return true;
        }
        return false;
    }

    private boolean hasViewPermission(OrganizationService orgService, UserACL acl, String remoteUser, String expPerm) throws Exception {
        if ("Everyone".equals(expPerm)) {
            return true;
        }
        String[] temp = expPerm.split(":");
        if (temp.length < 2) {
            return false;
        }
        String membership = temp[0].trim();
        String groupId = temp[1].trim();
        MembershipHandler handler = orgService.getMembershipHandler();
        if (membership == null || "*".equals(membership)) {
            Collection c = handler.findMembershipsByUserAndGroup(remoteUser, groupId);
            if (c == null) {
                return false;
            }
            return c.size() > 0;
        }
        return handler.findMembershipByUserGroupAndType(remoteUser, groupId, membership) != null;
    }

    private String getCategoryPath(String categoryName) {
        return "exo:applications/ApplicationRegistry/" + categoryName;
    }

    private boolean isApplicationType(Application app, String ... appTypes) {
        if (appTypes == null || appTypes.length < 1) {
            return true;
        }
        for (String appType : appTypes) {
            if (!appType.equals(app.getApplicationType())) continue;
            return true;
        }
        return false;
    }

    private Application convertApplication(Gadget gadget) {
        Application returnApplication = new Application();
        returnApplication.setApplicationGroup("eXoGadgets");
        returnApplication.setApplicationType("eXoGadget");
        returnApplication.setApplicationName(gadget.getName());
        returnApplication.setCategoryName("eXoGadgets");
        returnApplication.setDisplayName(gadget.getTitle());
        returnApplication.setDescription(gadget.getDescription());
        return returnApplication;
    }

    private String getDisplayNameValue(List<DisplayName> list, String defaultValue) {
        if (list == null || list.isEmpty()) {
            return defaultValue;
        }
        return list.get(0).getDisplayName();
    }

    private String getDescriptionValue(List<Description> list, String defaultValue) {
        if (list == null || list.isEmpty()) {
            return defaultValue;
        }
        return list.get(0).getDescription();
    }
}

