/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.application.gadget;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.spec.ModulePrefs;
import org.exoplatform.application.gadget.Gadget;
import org.exoplatform.application.gadget.GadgetRegistryService;
import org.exoplatform.application.gadget.Source;
import org.exoplatform.application.gadget.SourceStorage;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.gadget.GadgetApplication;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GadgetRegister
implements ServletContextListener {
    protected static Log log = ExoLogger.getLogger((String)"gadget:GadgetRegister");

    public void contextInitialized(ServletContextEvent event) {
        try {
            ServletContext servletContext = event.getServletContext();
            String containerName = servletContext.getInitParameter("portalContainerName");
            ExoContainer pcontainer = containerName != null ? ExoContainerContext.getContainerByName((String)containerName) : ExoContainerContext.getCurrentContainer();
            if (pcontainer == null) {
                pcontainer = ExoContainerContext.getTopContainer();
            }
            SourceStorage sourceStorage = (SourceStorage)pcontainer.getComponentInstanceOfType(SourceStorage.class);
            GadgetRegistryService gadgetService = (GadgetRegistryService)pcontainer.getComponentInstanceOfType(GadgetRegistryService.class);
            String confLocation = "/WEB-INF/gadget.xml";
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputStream in = event.getServletContext().getResourceAsStream(confLocation);
            Document docXML = db.parse(in);
            NodeList nodeList = docXML.getElementsByTagName("gadget");
            String gadgetName = null;
            String address = null;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element gadgetElement = (Element)nodeList.item(i);
                gadgetName = gadgetElement.getAttribute("name");
                if (gadgetService.getGadget(gadgetName) != null) continue;
                try {
                    NodeList nodeChild = gadgetElement.getChildNodes();
                    for (int j = 0; j < nodeChild.getLength(); ++j) {
                        Node node = nodeChild.item(j);
                        address = node.getTextContent();
                        if (node.getNodeName().equals("path")) {
                            InputStream sourceIs = event.getServletContext().getResourceAsStream(address);
                            String realPath = event.getServletContext().getRealPath(address);
                            File sourceFile = new File(realPath);
                            File homeDir = sourceFile.getParentFile();
                            String fileName = sourceFile.getName();
                            Source source = new Source(fileName, this.getMimeType(event.getServletContext(), fileName), "UTF-8");
                            source.setStreamContent(sourceIs);
                            source.setLastModified(Calendar.getInstance());
                            String homeName = homeDir.getName();
                            sourceStorage.saveSource(homeName, source);
                            ModulePrefs prefs = GadgetApplication.getModulePreferences((Uri)Uri.parse((String)"http://www.exoplatform.org"), (String)source.getTextContent());
                            Gadget gadget = new Gadget();
                            gadget.setName(gadgetName);
                            gadget.setUrl(sourceStorage.getSourceURI(homeName + "/" + fileName));
                            gadget.setTitle(this.getGadgetTitle(prefs, gadget.getName()));
                            gadget.setDescription(prefs.getDescription());
                            gadget.setThumbnail(prefs.getThumbnail().toString());
                            gadget.setReferenceUrl(prefs.getTitleUrl().toString());
                            gadget.setLocal(true);
                            gadgetService.saveGadget(gadget);
                            if (!homeDir.exists() || !homeDir.isDirectory()) continue;
                            File[] files = homeDir.listFiles();
                            for (int k = 0; k < files.length; ++k) {
                                this.saveTree(files[k], homeName, event.getServletContext(), sourceStorage);
                            }
                            continue;
                        }
                        if (!node.getNodeName().equals("url")) continue;
                        URL urlObj = new URL(address);
                        URLConnection conn = urlObj.openConnection();
                        InputStream is = conn.getInputStream();
                        String source = IOUtils.toString((InputStream)is, (String)"UTF-8");
                        ModulePrefs prefs = GadgetApplication.getModulePreferences((Uri)Uri.parse((String)address), (String)source);
                        Gadget gadget = new Gadget();
                        gadget.setName(gadgetName);
                        gadget.setUrl(address);
                        gadget.setTitle(this.getGadgetTitle(prefs, gadget.getName()));
                        gadget.setDescription(prefs.getDescription());
                        gadget.setThumbnail(prefs.getThumbnail().toString());
                        gadget.setReferenceUrl(prefs.getTitleUrl().toString());
                        gadget.setLocal(false);
                        gadgetService.saveGadget(gadget);
                    }
                    continue;
                }
                catch (Exception ex) {
                    log.warn((Object)("Can not register the gadget: '" + gadgetName + "' "));
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)"Error while deploying a gadget", (Throwable)ex);
        }
    }

    private void saveTree(File file, String savePath, ServletContext context, SourceStorage storage) throws Exception {
        if (file.isFile()) {
            Source includedSource = new Source(file.getName(), this.getMimeType(context, file.getName()), "UTF-8");
            includedSource.setStreamContent(new FileInputStream(file));
            includedSource.setLastModified(Calendar.getInstance());
            storage.saveSource(savePath, includedSource);
        } else if (file.isDirectory()) {
            File[] files = file.listFiles();
            String childPath = savePath + "/" + file.getName();
            for (int i = 0; i < files.length; ++i) {
                this.saveTree(files[i], childPath, context, storage);
            }
        }
    }

    private String getGadgetTitle(ModulePrefs prefs, String defaultValue) {
        String title = prefs.getDirectoryTitle();
        if (title == null || title.trim().length() < 1) {
            title = prefs.getTitle();
        }
        if (title == null || title.trim().length() < 1) {
            return defaultValue;
        }
        return title;
    }

    private String getMimeType(ServletContext context, String fileName) {
        return context.getMimeType(fileName) != null ? context.getMimeType(fileName) : "text/plain";
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }
}

