/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.application.gadget;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.ModulePrefs;
import org.exoplatform.application.gadget.EncodingDetector;
import org.exoplatform.application.gadget.impl.GadgetDefinition;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public abstract class GadgetImporter {
    private static final Logger log = LoggerFactory.getLogger(GadgetImporter.class);
    private String gadgetName;
    private String gadgetURI;

    protected GadgetImporter(String gadgetName, String gadgetURI) {
        this.gadgetName = gadgetName;
        this.gadgetURI = gadgetURI;
    }

    public String getGadgetName() {
        return this.gadgetName;
    }

    public String getGadgetURI() {
        return this.gadgetURI;
    }

    protected abstract byte[] getGadgetBytes(String var1) throws IOException;

    protected abstract String getGadgetURL() throws Exception;

    protected abstract void process(String var1, GadgetDefinition var2) throws Exception;

    private String getGadgetTitle(ModulePrefs prefs, String defaultValue) {
        String title = prefs.getDirectoryTitle();
        if (title == null || title.trim().length() < 1) {
            title = prefs.getTitle();
        }
        if (title == null || title.trim().length() < 1) {
            return defaultValue;
        }
        return title;
    }

    public void doImport(GadgetDefinition def) throws Exception {
        byte[] bytes = this.getGadgetBytes(this.gadgetURI);
        if (bytes == null) {
            log.error((Object)("Cannot import gadget " + this.gadgetURI + " because its data could not be found"));
            throw new IOException();
        }
        this.process(this.gadgetURI, def);
        String encoding = EncodingDetector.detect(new ByteArrayInputStream(bytes));
        String gadget = new String(bytes, encoding);
        String gadgetURL = this.getGadgetURL();
        GadgetSpec spec = new GadgetSpec(Uri.parse((String)gadgetURL), gadget);
        ModulePrefs prefs = spec.getModulePrefs();
        String description = prefs.getDescription();
        String thumbnail = prefs.getThumbnail().toString();
        String title = this.getGadgetTitle(prefs, this.gadgetName);
        String referenceURL = prefs.getTitleUrl().toString();
        log.info((Object)("Importing gadget name=" + this.gadgetName + " description=" + description + " thumbnail=" + thumbnail + " title=" + thumbnail + " title=" + title));
        def.setDescription(description);
        def.setThumbnail(thumbnail);
        def.setTitle(title);
        def.setReferenceURL(referenceURL);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.getGadgetName() + ",path=" + this.getGadgetURI() + "]";
    }
}

