/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.application.gadget.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import org.chromattic.api.Chromattic;
import org.chromattic.api.ChromatticSession;
import org.chromattic.ext.ntdef.Resource;
import org.exoplatform.application.gadget.Gadget;
import org.exoplatform.application.gadget.GadgetImporter;
import org.exoplatform.application.gadget.GadgetRegistryService;
import org.exoplatform.application.gadget.impl.GadgetData;
import org.exoplatform.application.gadget.impl.GadgetDefinition;
import org.exoplatform.application.gadget.impl.GadgetRegistry;
import org.exoplatform.application.gadget.impl.LocalGadgetData;
import org.exoplatform.application.gadget.impl.RemoteGadgetData;
import org.exoplatform.application.registry.impl.ApplicationRegistryChromatticLifeCycle;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.ValueParam;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class GadgetRegistryServiceImpl
implements GadgetRegistryService {
    private final Logger log = LoggerFactory.getLogger(GadgetRegistryServiceImpl.class);
    private static final String DEFAULT_DEVELOPER_GROUP = "/platform/administrators";
    private ChromatticManager chromatticManager;
    private ChromatticLifeCycle chromatticLifeCycle;
    private String gadgetDeveloperGroup;
    private String country;
    private String language;
    private String moduleId;
    private String hostName;

    public GadgetRegistryServiceImpl(ChromatticManager chromatticManager, InitParams params) {
        ApplicationRegistryChromatticLifeCycle lifeCycle = (ApplicationRegistryChromatticLifeCycle)chromatticManager.getLifeCycle("app");
        String gadgetDeveloperGroup = null;
        String country = null;
        String language = null;
        String moduleId = null;
        String hostName = null;
        if (params != null) {
            PropertiesParam properties = params.getPropertiesParam("developerInfo");
            gadgetDeveloperGroup = properties != null ? properties.getProperty("developer.group") : null;
            ValueParam gadgetCountry = params.getValueParam("gadgets.country");
            country = gadgetCountry != null ? gadgetCountry.getValue() : null;
            ValueParam gadgetLanguage = params.getValueParam("gadgets.language");
            language = gadgetLanguage != null ? gadgetLanguage.getValue() : null;
            ValueParam gadgetModuleId = params.getValueParam("gadgets.moduleId");
            moduleId = gadgetModuleId != null ? gadgetModuleId.getValue() : null;
            ValueParam gadgetHostName = params.getValueParam("gadgets.hostName");
            String string = hostName = gadgetHostName != null ? gadgetHostName.getValue() : null;
        }
        if (gadgetDeveloperGroup == null) {
            gadgetDeveloperGroup = DEFAULT_DEVELOPER_GROUP;
        }
        this.country = country;
        this.language = language;
        this.moduleId = moduleId;
        this.hostName = hostName;
        this.gadgetDeveloperGroup = gadgetDeveloperGroup;
        this.chromatticManager = chromatticManager;
        this.chromatticLifeCycle = lifeCycle;
    }

    public GadgetRegistry getRegistry() {
        Chromattic chromattic = this.chromatticLifeCycle.getChromattic();
        ChromatticSession session = chromattic.openSession();
        GadgetRegistry registry = (GadgetRegistry)session.findByPath(GadgetRegistry.class, "app:gadgets");
        if (registry == null) {
            registry = (GadgetRegistry)session.insert(GadgetRegistry.class, "app:gadgets");
        }
        return registry;
    }

    @Override
    public void deploy(Iterable<GadgetImporter> gadgets) {
        for (GadgetImporter importer : gadgets) {
            try {
                new DeployTask(importer).call();
            }
            catch (Exception e) {
                this.log.error((Object)("Could not process gadget file " + importer), (Throwable)e);
            }
        }
    }

    @Override
    public Gadget getGadget(String name) throws Exception {
        GadgetRegistry registry = this.getRegistry();
        GadgetDefinition def = registry.getGadget(name);
        return def == null ? null : this.loadGadget(def);
    }

    @Override
    public List<Gadget> getAllGadgets() throws Exception {
        return this.getAllGadgets(null);
    }

    @Override
    public List<Gadget> getAllGadgets(Comparator<Gadget> sortComparator) throws Exception {
        GadgetRegistry registry = this.getRegistry();
        ArrayList<Gadget> gadgets = new ArrayList<Gadget>();
        for (GadgetDefinition def : registry.getGadgets()) {
            Gadget gadget = this.loadGadget(def);
            gadgets.add(gadget);
        }
        if (sortComparator != null) {
            Collections.sort(gadgets, sortComparator);
        }
        return gadgets;
    }

    @Override
    public void saveGadget(Gadget gadget) throws Exception {
        if (gadget == null) {
            throw new NullPointerException();
        }
        GadgetRegistry registry = this.getRegistry();
        GadgetDefinition def = registry.getGadget(gadget.getName());
        if (def == null) {
            def = registry.addGadget(gadget.getName());
            if (gadget.isLocal()) {
                def.setLocal(true);
                LocalGadgetData data = (LocalGadgetData)def.getData();
                String fileName = gadget.getName() + ".xml";
                data.setFileName(fileName);
                data.getResources().createFile(fileName, new Resource("application.xml", "UTF-8", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Module><ModulePrefs title=\"\" /><Content type=\"html\"> <![CDATA[]]></Content></Module>".getBytes("UTF-8")));
            } else {
                def.setLocal(false);
                RemoteGadgetData data = (RemoteGadgetData)def.getData();
                data.setURL(gadget.getUrl());
            }
        }
        this.saveGadget(def, gadget);
    }

    @Override
    public void removeGadget(String name) throws Exception {
        if (name == null) {
            throw new NullPointerException();
        }
        GadgetRegistry registry = this.getRegistry();
        GadgetDefinition def = registry.getGadget(name);
        if (def == null) {
            throw new IllegalArgumentException("No such gadget " + name);
        }
        registry.removeGadget(name);
    }

    @Override
    public String getGadgetURL(String gadgetName) {
        String url;
        GadgetData data = this.getRegistry().getGadget(gadgetName).getData();
        if (data instanceof LocalGadgetData) {
            LocalGadgetData localData = (LocalGadgetData)data;
            url = "/" + PortalContainer.getCurrentRestContextName() + "/" + this.getJCRGadgetURL(localData);
        } else if (data instanceof RemoteGadgetData) {
            RemoteGadgetData remoteData = (RemoteGadgetData)data;
            url = remoteData.getURL();
        } else {
            throw new IllegalStateException("Gadget has to be instance of LocalGadgetData or RemoteGadgetData");
        }
        return url;
    }

    private String getJCRGadgetURL(LocalGadgetData data) {
        return "jcr/" + this.chromatticLifeCycle.getRepositoryName() + "/" + this.chromatticLifeCycle.getWorkspaceName() + data.getPath() + "/app:resources/" + data.getFileName();
    }

    private void saveGadget(GadgetDefinition def, Gadget gadget) {
        def.setDescription(gadget.getDescription());
        def.setReferenceURL(gadget.getReferenceUrl());
        def.setTitle(gadget.getTitle());
        def.setThumbnail(gadget.getThumbnail());
    }

    private Gadget loadGadget(GadgetDefinition def) {
        String url;
        GadgetData data = def.getData();
        if (data instanceof LocalGadgetData) {
            LocalGadgetData localData = (LocalGadgetData)data;
            url = this.getJCRGadgetURL(localData);
        } else {
            RemoteGadgetData remoteData = (RemoteGadgetData)data;
            url = remoteData.getURL();
        }
        Gadget gadget = new Gadget();
        gadget.setName(def.getName());
        gadget.setDescription(def.getDescription());
        gadget.setLocal(def.isLocal());
        gadget.setTitle(def.getTitle());
        gadget.setReferenceUrl(def.getReferenceURL());
        gadget.setThumbnail(def.getThumbnail());
        gadget.setUrl(url);
        return gadget;
    }

    @Override
    public boolean isGadgetDeveloper(String username) {
        return PropertyManager.isDevelopping();
    }

    @Override
    public String getCountry() {
        return this.country;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public String getModuleId() {
        return this.moduleId;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    private class DeployTask
    implements Callable<Boolean> {
        private final GadgetImporter importer;

        private DeployTask(GadgetImporter importer) {
            this.importer = importer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            GadgetRegistryServiceImpl.this.chromatticLifeCycle.openContext();
            boolean done = true;
            try {
                if (GadgetRegistryServiceImpl.this.getRegistry().getGadget(this.importer.getGadgetName()) == null) {
                    GadgetDefinition def = GadgetRegistryServiceImpl.this.getRegistry().addGadget(this.importer.getGadgetName());
                    this.importer.doImport(def);
                } else {
                    GadgetRegistryServiceImpl.this.log.debug((Object)("Will not import existing gagdet " + this.importer.getGadgetName()));
                }
            }
            catch (Exception e) {
                done = false;
            }
            finally {
                GadgetRegistryServiceImpl.this.chromatticLifeCycle.closeContext(done);
            }
            return done;
        }
    }
}

