/*
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.exoplatform.application.gadget;

import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.DefaultHandler;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import java.io.IOException;
import java.io.InputStream;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class EncodingDetector extends DefaultHandler
{

   public static String detect(InputStream in) throws IOException, ParserConfigurationException, SAXException
   {
      EncodingDetector detector = new EncodingDetector();
      SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
      parser.parse(in, detector);
      return detector.encoding;
   }

   /** . */
   private Locator2 locator;

   /** Use UTF-8 if nothing provided. */
   private String encoding = "UTF-8";

   private EncodingDetector()
   {
   }

   @Override
   public void setDocumentLocator(Locator locator)
   {
      if (locator instanceof Locator2)
      {
         this.locator = (Locator2)locator;
      }
   }

   @Override
   public void startDocument() throws SAXException
   {
      if (locator != null)
      {
         encoding = locator.getEncoding();
      }
   }
}
