/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.application.gadget.impl;

import java.util.Calendar;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.ModulePrefs;
import org.exoplatform.application.gadget.Gadget;
import org.exoplatform.application.gadget.GadgetRegistryService;
import org.exoplatform.application.gadget.Source;
import org.exoplatform.application.gadget.SourceStorage;
import org.exoplatform.application.gadget.impl.GadgetData;
import org.exoplatform.application.gadget.impl.GadgetDefinition;
import org.exoplatform.application.gadget.impl.GadgetRegistry;
import org.exoplatform.application.gadget.impl.GadgetRegistryServiceImpl;
import org.exoplatform.application.gadget.impl.LocalGadgetData;

public class SourceStorageImpl
implements SourceStorage {
    private GadgetRegistryServiceImpl gadgetRegistryService;

    public SourceStorageImpl(GadgetRegistryService gadgetRegistryService) {
        this.gadgetRegistryService = (GadgetRegistryServiceImpl)gadgetRegistryService;
    }

    @Override
    public Source getSource(Gadget gadget) throws Exception {
        GadgetDefinition def = this.gadgetRegistryService.getRegistry().getGadget(gadget.getName());
        if (def == null) {
            return null;
        }
        GadgetData data = def.getData();
        if (data instanceof LocalGadgetData) {
            LocalGadgetData localData = (LocalGadgetData)data;
            String content = localData.getSource();
            Calendar lastModified = Calendar.getInstance();
            lastModified.setTime(localData.getLastModified());
            Source source = new Source(gadget.getName());
            source.setMimeType("application/x-google-gadget");
            source.setLastModified(lastModified);
            source.setTextContent(content);
            return source;
        }
        throw new IllegalArgumentException("The provided gadget is remote");
    }

    @Override
    public void saveSource(Gadget gadget, Source source) throws Exception {
        if (gadget == null) {
            throw new NullPointerException();
        }
        if (source == null) {
            throw new NullPointerException();
        }
        GadgetRegistry registry = this.gadgetRegistryService.getRegistry();
        GadgetDefinition def = registry.getGadget(gadget.getName());
        GadgetData data = def.getData();
        if (!(data instanceof LocalGadgetData)) {
            throw new IllegalArgumentException("The provided gadget is remote");
        }
        GadgetSpec spec = new GadgetSpec(Uri.parse((String)"http://www.gatein.org"), source.getTextContent());
        ModulePrefs prefs = spec.getModulePrefs();
        String description = prefs.getDescription();
        String thumbnail = prefs.getThumbnail().toString();
        String title = this.getGadgetTitle(prefs, gadget.getName());
        String referenceURL = prefs.getTitleUrl().toString();
        def.setDescription(description);
        def.setThumbnail(thumbnail);
        def.setTitle(title);
        def.setReferenceURL(referenceURL);
        LocalGadgetData localData = (LocalGadgetData)data;
        localData.setSource(source.getTextContent());
    }

    private String getGadgetTitle(ModulePrefs prefs, String defaultValue) {
        String title = prefs.getDirectoryTitle();
        if (title == null || title.trim().length() < 1) {
            title = prefs.getTitle();
        }
        if (title == null || title.trim().length() < 1) {
            return defaultValue;
        }
        return title;
    }

    @Override
    public void removeSource(String sourcePath) throws Exception {
    }

    public String getSourceURI(String sourcePath) {
        throw new UnsupportedOperationException("Cannot obtain URI from source " + sourcePath);
    }
}

