/*
 * Copyright (C) 2003-2007 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 */
package org.exoplatform.services.resources;

import java.net.URLConnection;
import java.net.URL;
import java.io.InputStream;
import java.io.IOException;

/**
 * An URLConnection extension that use a local {@link java.io.InputStream} object.
 *
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class InputStreamURLConnection extends URLConnection {

  private final InputStream in;

  /**
   * Creates a new connection.
   *
   * @param url the original URL
   * @param in the input stream
   * @throws IllegalArgumentException if the stream is null
   */
  public InputStreamURLConnection(URL url, InputStream in) throws IllegalArgumentException {
    super(url);

    //
    if (in == null) {
      throw new IllegalArgumentException("No null input stream accepted");
    }

    //
    this.in = in;
  }

  public void connect() throws IOException {
    // no op
  }

  public InputStream getInputStream() throws IOException {
    return in;
  }
}
