/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.IOException;
import java.io.Reader;

public class PropertyResolverReader
extends Reader {
    private static final int STATUS_READING = 0;
    private static final int STATUS_READ_DOLLAR = 1;
    private static final int STATUS_READING_PROPERTY = 2;
    private static final int STATUS_WRITING = 3;
    private static final int STATUS_TERMINATED = 4;
    private Reader delegate;
    private int status = 0;
    private char[] buffer;
    private int bufferLen;
    private int bufferOff;
    private int mark;

    public PropertyResolverReader(Reader delegate) {
        this(delegate, 64);
    }

    public PropertyResolverReader(Reader delegate, int bufferSize) {
        if (delegate == null) {
            throw new NullPointerException();
        }
        if (bufferSize < 0) {
            throw new IllegalArgumentException();
        }
        this.delegate = delegate;
        this.buffer = new char[bufferSize];
        this.bufferLen = 0;
        this.bufferOff = 0;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int olen = len;
        block7: while (true) {
            switch (this.status) {
                case 0: {
                    char c;
                    if (len > 0) {
                        if (this.bufferOff == this.bufferLen) {
                            this.resetBuffer();
                            this.fillBuffer(Math.min(len, this.buffer.length));
                            continue block7;
                        }
                        if ((c = this.buffer[this.bufferOff++]) == '$') {
                            this.mark = this.bufferOff - 1;
                            this.status = 1;
                            continue block7;
                        }
                        cbuf[off++] = c;
                        --len;
                        continue block7;
                    }
                    return olen - len;
                }
                case 4: {
                    if (this.mark != -1 && this.mark < this.bufferOff) {
                        if (len > 0) {
                            cbuf[off++] = this.buffer[this.mark++];
                            --len;
                            continue block7;
                        }
                        return olen - len;
                    }
                    if (olen > len) {
                        return olen - len;
                    }
                    return -1;
                }
                case 1: {
                    char c;
                    if (this.bufferOff == this.bufferLen) {
                        this.fillBuffer(1);
                        continue block7;
                    }
                    if ((c = this.buffer[this.bufferOff++]) == '{') {
                        this.status = 2;
                        continue block7;
                    }
                    this.status = 3;
                    continue block7;
                }
                case 3: {
                    if (this.mark < this.bufferOff) {
                        if (len > 0) {
                            cbuf[off++] = this.buffer[this.mark++];
                            --len;
                            continue block7;
                        }
                        return olen - len;
                    }
                    this.mark = -1;
                    this.status = 0;
                    continue block7;
                }
                case 2: {
                    char c;
                    if (this.bufferOff == this.bufferLen) {
                        this.fillBuffer(1);
                        continue block7;
                    }
                    if ((c = this.buffer[this.bufferOff++]) != '}') continue block7;
                    String name = new String(this.buffer, this.mark + 2, this.bufferOff - this.mark - 2 - 1);
                    String value = this.resolve(name);
                    if (value == null) {
                        this.status = 3;
                        continue block7;
                    }
                    this.mark = this.bufferOff - value.length();
                    if (this.mark < 0) {
                        int nextBufferLen = this.bufferLen - this.mark;
                        if (nextBufferLen > this.buffer.length) {
                            char[] tmp = new char[nextBufferLen];
                            System.arraycopy(this.buffer, this.bufferOff, tmp, this.bufferOff - this.mark, this.bufferLen - this.bufferOff);
                            this.buffer = tmp;
                        } else {
                            System.arraycopy(this.buffer, this.bufferOff, this.buffer, this.bufferOff - this.mark, this.bufferLen - this.bufferOff);
                        }
                        this.bufferOff -= this.mark;
                        this.bufferLen = nextBufferLen;
                        this.mark = 0;
                    }
                    value.getChars(0, value.length(), this.buffer, this.mark);
                    this.status = 3;
                    continue block7;
                }
            }
            break;
        }
        throw new UnsupportedOperationException();
    }

    protected String resolve(String name) throws IOException {
        return name;
    }

    private void resetBuffer() {
        if (this.bufferLen != this.bufferOff) {
            throw new AssertionError();
        }
        this.bufferOff = 0;
        this.bufferLen = 0;
    }

    private void fillBuffer(int amount) throws IOException {
        int ret;
        if (this.bufferLen > this.bufferOff) {
            throw new AssertionError();
        }
        if (amount < 0) {
            throw new IllegalArgumentException();
        }
        int space = this.bufferLen + amount - this.buffer.length;
        if (space > 0) {
            char[] tmp = new char[this.buffer.length + space];
            System.arraycopy(this.buffer, 0, tmp, 0, this.buffer.length);
            this.buffer = tmp;
        }
        if ((ret = this.delegate.read(this.buffer, this.bufferLen, amount)) != -1) {
            this.bufferLen += ret;
        } else {
            this.status = 4;
        }
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

