/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.transaction;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import org.exoplatform.services.transaction.TransactionService;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.common.transaction.JTAUserTransactionLifecycleService;

public class JTAUserTransactionLifecycleServiceImpl
implements JTAUserTransactionLifecycleService {
    private static final Logger log = LoggerFactory.getLogger(JTAUserTransactionLifecycleServiceImpl.class);
    private UserTransaction userTransaction;
    private TransactionService transactionService;

    public JTAUserTransactionLifecycleServiceImpl(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    @Override
    public void beginJTATransaction() {
        UserTransaction tx = this.getUserTransaction();
        try {
            if (tx.getStatus() == 6) {
                tx.begin();
            } else {
                log.warn((Object)("UserTransaction not started as it's in state " + tx.getStatus()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void finishJTATransaction() {
        UserTransaction tx = this.getUserTransaction();
        try {
            int txStatus = tx.getStatus();
            if (txStatus == 6) {
                log.warn((Object)"UserTransaction can't be finished as it wasn't started");
            } else if (txStatus == 1 || txStatus == 4 || txStatus == 9) {
                log.warn((Object)("Going to rollback UserTransaction as it's status is " + txStatus));
                tx.rollback();
            } else {
                tx.commit();
            }
        }
        catch (Exception se) {
            throw new RuntimeException(se);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserTransaction getUserTransaction() {
        if (this.userTransaction == null) {
            JTAUserTransactionLifecycleServiceImpl jTAUserTransactionLifecycleServiceImpl = this;
            synchronized (jTAUserTransactionLifecycleServiceImpl) {
                if (this.userTransaction == null) {
                    try {
                        this.userTransaction = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
                    }
                    catch (NamingException ne) {
                        log.debug((Object)"UserTransaction not found via JNDI. Trying TransactionService");
                        this.userTransaction = this.transactionService.getUserTransaction();
                    }
                }
            }
        }
        return this.userTransaction;
    }
}

