/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.jbidm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.impl.GroupImpl;
import org.exoplatform.services.organization.jbidm.JBossIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.jbidm.JBossIDMService;
import org.jboss.identity.idm.api.Attribute;
import org.jboss.identity.idm.api.IdentitySession;
import org.jboss.identity.idm.api.IdentityType;
import org.jboss.identity.idm.api.Role;
import org.jboss.identity.idm.impl.api.SimpleAttribute;

public class GroupDAOImpl
implements GroupHandler {
    public static final String GROUP_LABEL = "label";
    public static final String GROUP_DESCRIPTION = "description";
    private JBossIDMService service_;
    private List<GroupEventListener> listeners_;
    private JBossIDMOrganizationServiceImpl orgService;

    public GroupDAOImpl(JBossIDMOrganizationServiceImpl orgService, JBossIDMService service) {
        this.service_ = service;
        this.orgService = orgService;
        this.listeners_ = new ArrayList<GroupEventListener>();
    }

    public void addGroupEventListener(GroupEventListener listener) {
        this.listeners_.add(listener);
    }

    public final Group createGroupInstance() {
        return new GroupImpl();
    }

    public void createGroup(Group group, boolean broadcast) throws Exception {
        this.addChild(null, group, broadcast);
    }

    public void addChild(Group parent, Group child, boolean broadcast) throws Exception {
        org.jboss.identity.idm.api.Group parentGroup = null;
        if (parent != null) {
            parentGroup = this.getIdentitySession().getPersistenceManager().findGroup(parent.getGroupName(), this.orgService.getExoGroupType());
            ((GroupImpl)child).setId(parent.getId() + "/" + child.getGroupName());
        } else {
            ((GroupImpl)child).setId("/" + child.getGroupName());
        }
        if (broadcast) {
            this.preSave(child, true);
        }
        org.jboss.identity.idm.api.Group childGroup = this.persistGroup(child);
        if (parentGroup != null) {
            this.getIdentitySession().getRelationshipManager().associateGroups(parentGroup, childGroup);
            ((GroupImpl)child).setParentId(parent.getId());
        } else {
            this.getIdentitySession().getRelationshipManager().associateGroups(this.getRootGroup(), childGroup);
        }
        if (broadcast) {
            this.postSave(child, true);
        }
    }

    public void saveGroup(Group group, boolean broadcast) throws Exception {
        if (broadcast) {
            this.preSave(group, false);
        }
        this.persistGroup(group);
        if (broadcast) {
            this.postSave(group, false);
        }
    }

    public Group removeGroup(Group group, boolean broadcast) throws Exception {
        org.jboss.identity.idm.api.Group jbidGroup;
        if (broadcast) {
            this.preDelete(group);
        }
        if ((jbidGroup = this.getIdentitySession().getPersistenceManager().findGroup(group.getGroupName(), this.orgService.getExoGroupType())) == null) {
            return group;
        }
        Collection oneLevelChilds = this.getIdentitySession().getRelationshipManager().findAssociatedGroups(jbidGroup, this.orgService.getExoGroupType(), true, false);
        Collection allChilds = this.getIdentitySession().getRelationshipManager().findAssociatedGroups(jbidGroup, this.orgService.getExoGroupType(), true, true);
        this.getIdentitySession().getRelationshipManager().disassociateGroups(jbidGroup, oneLevelChilds);
        for (org.jboss.identity.idm.api.Group child : allChilds) {
            this.getIdentitySession().getPersistenceManager().removeGroup(child, true);
        }
        this.getIdentitySession().getPersistenceManager().removeGroup(jbidGroup, true);
        if (broadcast) {
            this.postDelete(group);
        }
        return group;
    }

    public Collection findGroupByMembership(String userName, String membershipType) throws Exception {
        Collection allRoles = this.getIdentitySession().getRoleManager().findRoles(userName, membershipType);
        HashSet<Group> exoGroups = new HashSet<Group>();
        for (Role role : allRoles) {
            exoGroups.add(this.convertGroup(role.getGroup()));
        }
        return exoGroups;
    }

    public Group findGroupById(String groupId) throws Exception {
        String[] ids = groupId.split("/");
        String name = ids[ids.length - 1];
        org.jboss.identity.idm.api.Group jbidGroup = this.getIdentitySession().getPersistenceManager().findGroup(name, this.orgService.getExoGroupType());
        if (jbidGroup == null) {
            return null;
        }
        return this.convertGroup(jbidGroup);
    }

    public Collection findGroups(Group parent) throws Exception {
        org.jboss.identity.idm.api.Group jbidGroup = null;
        jbidGroup = parent == null ? this.getRootGroup() : this.getIdentitySession().getPersistenceManager().findGroup(parent.getGroupName(), this.orgService.getExoGroupType());
        if (jbidGroup == null) {
            return Collections.emptyList();
        }
        Collection allGroups = this.getIdentitySession().getRelationshipManager().findAssociatedGroups(jbidGroup, this.orgService.getExoGroupType(), true, false);
        LinkedList<Group> exoGroups = new LinkedList<Group>();
        for (org.jboss.identity.idm.api.Group group : allGroups) {
            exoGroups.add(this.convertGroup(group));
        }
        return exoGroups;
    }

    public Collection findGroupsOfUser(String user) throws Exception {
        if (user == null) {
            return Collections.emptyList();
        }
        Collection allGroups = this.getIdentitySession().getRelationshipManager().findRelatedGroups(user, this.orgService.getExoGroupType(), null);
        LinkedList<Group> exoGroups = new LinkedList<Group>();
        for (org.jboss.identity.idm.api.Group group : allGroups) {
            exoGroups.add(this.convertGroup(group));
        }
        return exoGroups;
    }

    public Collection getAllGroups() throws Exception {
        Collection allGroups = this.getIdentitySession().getPersistenceManager().findGroup(this.orgService.getExoGroupType());
        LinkedList<Group> exoGroups = new LinkedList<Group>();
        for (org.jboss.identity.idm.api.Group group : allGroups) {
            if (this.orgService.getExoGroupType().equals(this.orgService.getExoRootGroupType()) && group.getName().equals(this.orgService.getExoRootGroupName())) continue;
            exoGroups.add(this.convertGroup(group));
        }
        return exoGroups;
    }

    private void preSave(Group group, boolean isNew) throws Exception {
        for (GroupEventListener listener : this.listeners_) {
            listener.preSave(group, isNew);
        }
    }

    private void postSave(Group group, boolean isNew) throws Exception {
        for (GroupEventListener listener : this.listeners_) {
            listener.postSave(group, isNew);
        }
    }

    private void preDelete(Group group) throws Exception {
        for (GroupEventListener listener : this.listeners_) {
            listener.preDelete(group);
        }
    }

    private void postDelete(Group group) throws Exception {
        for (GroupEventListener listener : this.listeners_) {
            listener.postDelete(group);
        }
    }

    public Group getGroup(String groupName) throws Exception {
        org.jboss.identity.idm.api.Group jbidGroup = this.getIdentitySession().getPersistenceManager().findGroup(groupName, this.orgService.getExoGroupType());
        if (jbidGroup == null) {
            return null;
        }
        return this.convertGroup(jbidGroup);
    }

    private Group convertGroup(org.jboss.identity.idm.api.Group jbidGroup) throws Exception {
        Map attrs = this.getIdentitySession().getAttributesManager().getAttributes((IdentityType)jbidGroup);
        GroupImpl exoGroup = new GroupImpl(jbidGroup.getName());
        if (attrs.containsKey(GROUP_DESCRIPTION)) {
            exoGroup.setDescription(((Attribute)attrs.get(GROUP_DESCRIPTION)).getValue().toString());
        }
        if (attrs.containsKey(GROUP_LABEL)) {
            exoGroup.setLabel(((Attribute)attrs.get(GROUP_LABEL)).getValue().toString());
        }
        String id = this.getGroupId(jbidGroup.getName());
        exoGroup.setId(id);
        if (id.length() == jbidGroup.getName().length() + 1) {
            exoGroup.setParentId(null);
        } else {
            exoGroup.setParentId(id.substring(0, id.length() - jbidGroup.getName().length() - 1));
        }
        return exoGroup;
    }

    private String getGroupId(String groupName) throws Exception {
        if (groupName.equals(this.orgService.getExoRootGroupName())) {
            return "";
        }
        org.jboss.identity.idm.api.Group jbidGroup = this.getIdentitySession().getPersistenceManager().findGroup(groupName, this.orgService.getExoGroupType());
        Collection parents = this.getIdentitySession().getRelationshipManager().findAssociatedGroups(jbidGroup, this.orgService.getExoGroupType(), false, false);
        if (parents.size() > 1) {
            throw new IllegalStateException("Group has more than one parent: " + groupName);
        }
        if (parents.size() == 0) {
            throw new IllegalStateException("Group present that is not connected to the root: " + groupName);
        }
        String parentGroupId = this.getGroupId(((org.jboss.identity.idm.api.Group)parents.iterator().next()).getName());
        return parentGroupId + "/" + groupName;
    }

    private org.jboss.identity.idm.api.Group persistGroup(Group exoGroup) throws Exception {
        org.jboss.identity.idm.api.Group jbidGroup = this.getIdentitySession().getPersistenceManager().findGroup(exoGroup.getGroupName(), this.orgService.getExoGroupType());
        if (jbidGroup == null) {
            jbidGroup = this.getIdentitySession().getPersistenceManager().createGroup(exoGroup.getGroupName(), this.orgService.getExoGroupType());
        }
        String description = exoGroup.getDescription();
        String label = exoGroup.getLabel();
        ArrayList<SimpleAttribute> attrsList = new ArrayList<SimpleAttribute>();
        if (description != null) {
            attrsList.add(new SimpleAttribute(GROUP_DESCRIPTION, (Object)description));
        }
        if (label != null) {
            attrsList.add(new SimpleAttribute(GROUP_LABEL, (Object)label));
        }
        if (attrsList.size() > 0) {
            Attribute[] attrs = new Attribute[attrsList.size()];
            attrs = attrsList.toArray(attrs);
            this.getIdentitySession().getAttributesManager().addAttributes((IdentityType)jbidGroup, attrs);
        }
        return jbidGroup;
    }

    private IdentitySession getIdentitySession() throws Exception {
        return this.service_.getIdentitySession();
    }

    private org.jboss.identity.idm.api.Group getRootGroup() throws Exception {
        org.jboss.identity.idm.api.Group rootGroup = this.getIdentitySession().getPersistenceManager().findGroup(this.orgService.getExoRootGroupName(), this.orgService.getExoRootGroupType());
        if (rootGroup == null) {
            rootGroup = this.getIdentitySession().getPersistenceManager().createGroup(this.orgService.getExoRootGroupName(), this.orgService.getExoRootGroupType());
        }
        return rootGroup;
    }
}

