/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.jbidm;

import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.jbidm.JBossIDMService;
import org.exoplatform.services.organization.jbidm.UserDAOImpl;
import org.jboss.identity.idm.api.query.UserQuery;
import org.jboss.identity.idm.api.query.UserQueryBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDMUserListAccess
implements ListAccess<User> {
    private final UserDAOImpl userDAO;
    private final JBossIDMService idmService;
    private final UserQueryBuilder userQueryBuilder;
    private final int pageSize;
    private final boolean countAll;

    public IDMUserListAccess(UserDAOImpl userDAO, JBossIDMService idmService, UserQueryBuilder userQueryBuilder, int pageSize, boolean countAll) {
        this.userDAO = userDAO;
        this.idmService = idmService;
        this.userQueryBuilder = userQueryBuilder;
        this.pageSize = pageSize;
        this.countAll = countAll;
    }

    public User[] load(int index, int length) throws Exception, IllegalArgumentException {
        this.userQueryBuilder.page(index, length);
        UserQuery query = this.userQueryBuilder.createQuery();
        List users = this.idmService.getIdentitySession().list(query);
        User[] exoUsers = new User[users.size()];
        for (int i = 0; i < users.size(); ++i) {
            org.jboss.identity.idm.api.User user = (org.jboss.identity.idm.api.User)users.get(i);
            exoUsers[i] = UserDAOImpl.getPopulatedUser(user.getId(), this.idmService.getIdentitySession());
        }
        return exoUsers;
    }

    public int getSize() throws Exception {
        if (this.countAll) {
            return this.idmService.getIdentitySession().getPersistenceManager().getUserCount();
        }
        this.userQueryBuilder.page(0, 0);
        UserQuery query = this.userQueryBuilder.createQuery();
        return this.idmService.getIdentitySession().execute(query).size();
    }
}

