/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.jbidm;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.services.organization.BaseOrganizationService;
import org.exoplatform.services.organization.jbidm.GroupDAOImpl;
import org.exoplatform.services.organization.jbidm.JBossIDMService;
import org.exoplatform.services.organization.jbidm.MembershipDAOImpl;
import org.exoplatform.services.organization.jbidm.MembershipTypeDAOImpl;
import org.exoplatform.services.organization.jbidm.UserDAOImpl;
import org.exoplatform.services.organization.jbidm.UserProfileDAOImpl;
import org.picocontainer.Startable;

public class JBossIDMOrganizationServiceImpl
extends BaseOrganizationService
implements Startable,
ComponentRequestLifecycle {
    private static JBossIDMService jbidmService_;
    private static HibernateService hibernateService_;
    public static final String EXO_GROUP_TYPE_OPTION = "exoGroupTypeName";
    public static final String EXO_ROOT_GROUP_NAME_OPTION = "exoRootGroupName";
    public static final String EXO_ROOT_GROUP_TYPE_NAME_OPTION = "exoRootGroupTypeName";
    public static final String PASSWORD_AS_ATTRIBUTE_OPTION = "passwordAsAttribute";
    private String exoGroupType = "EXO_GROUP_TYPE";
    private String exoRootGroupName = "EXO_ROOT_GROUP";
    private String exoRootGroupType = this.exoGroupType;
    private boolean passwordAsAttribute = false;

    public JBossIDMOrganizationServiceImpl(InitParams params, CacheService cservice, JBossIDMService jbidmService) throws Exception {
        this.userDAO_ = new UserDAOImpl(this, jbidmService, cservice);
        this.userProfileDAO_ = new UserProfileDAOImpl(this, jbidmService, cservice);
        this.groupDAO_ = new GroupDAOImpl(this, jbidmService);
        this.membershipDAO_ = new MembershipDAOImpl(this, jbidmService);
        this.membershipTypeDAO_ = new MembershipTypeDAOImpl(this, jbidmService);
        jbidmService_ = jbidmService;
        if (params != null) {
            ValueParam exoGroupTypeNameParam = params.getValueParam(EXO_GROUP_TYPE_OPTION);
            ValueParam exoRootGroupTypeNameParam = params.getValueParam(EXO_ROOT_GROUP_TYPE_NAME_OPTION);
            ValueParam exoRootGroupNameParam = params.getValueParam(EXO_ROOT_GROUP_NAME_OPTION);
            ValueParam passwordAsAttributeParam = params.getValueParam(PASSWORD_AS_ATTRIBUTE_OPTION);
            if (exoGroupTypeNameParam != null) {
                this.exoGroupType = exoGroupTypeNameParam.getValue();
            }
            if (exoRootGroupNameParam != null) {
                this.exoRootGroupName = exoRootGroupNameParam.getValue();
            }
            if (exoRootGroupTypeNameParam != null) {
                this.exoRootGroupType = exoRootGroupTypeNameParam.getValue();
            } else if (exoRootGroupTypeNameParam != null) {
                this.exoRootGroupType = this.exoGroupType;
            }
            if (passwordAsAttributeParam != null && passwordAsAttributeParam.getValue().equalsIgnoreCase("true")) {
                this.passwordAsAttribute = true;
            }
        }
    }

    public void start() {
        try {
            jbidmService_.getIdentitySession().beginTransaction();
            super.start();
            jbidmService_.getIdentitySession().getTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
    }

    public void startRequest(ExoContainer container) {
        try {
            jbidmService_.getIdentitySession().beginTransaction();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void endRequest(ExoContainer container) {
        try {
            jbidmService_.getIdentitySession().getTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getExoGroupType() {
        return this.exoGroupType;
    }

    public String getExoRootGroupName() {
        return this.exoRootGroupName;
    }

    public String getExoRootGroupType() {
        return this.exoRootGroupType;
    }

    public boolean isPasswordAsAttribute() {
        return this.passwordAsAttribute;
    }
}

