/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.jbidm;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.naming.InitialContext;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.Property;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.jbidm.JBossIDMService;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.dialect.Dialect;
import org.jboss.identity.idm.api.IdentitySession;
import org.jboss.identity.idm.api.IdentitySessionFactory;
import org.jboss.identity.idm.api.cfg.IdentityConfiguration;
import org.jboss.identity.idm.common.exception.IdentityConfigurationException;
import org.jboss.identity.idm.impl.configuration.IdentityConfigurationImpl;
import org.jboss.identity.idm.impl.configuration.jaxb2.JAXB2IdentityConfiguration;
import org.jboss.identity.idm.spi.configuration.metadata.IdentityConfigurationMetaData;
import org.picocontainer.Startable;

public class JBossIDMServiceImpl
implements JBossIDMService,
Startable {
    private static Log log_ = ExoLogger.getLogger(JBossIDMServiceImpl.class);
    public static final String PARAM_CONFIG_OPTION = "config";
    public static final String PARAM_HIBERNATE_PROPS = "hibernate.properties";
    public static final String PARAM_HIBERNATE_MAPPINGS = "hibernate.mappings";
    public static final String PARAM_HIBERNATE_ANNOTATIONS = "hibernate.annotations";
    public static final String PARAM_JNDI_NAME_OPTION = "jndiName";
    public static final String DEFAULT_REALM_NAME_OPTION = "PortalRealm";
    private static IdentitySessionFactory identitySessionFactory;
    private String config;
    private String defaultRealmName = "PortalRealm";
    private IdentityConfiguration identityConfiguration;

    private JBossIDMServiceImpl() {
    }

    public JBossIDMServiceImpl(InitParams initParams, ConfigurationManager confManager) throws Exception {
        ValueParam config = initParams.getValueParam(PARAM_CONFIG_OPTION);
        ValueParam hibernateConfig = initParams.getValueParam(PARAM_CONFIG_OPTION);
        ValueParam jndiName = initParams.getValueParam(PARAM_JNDI_NAME_OPTION);
        ValueParam realmName = initParams.getValueParam(DEFAULT_REALM_NAME_OPTION);
        if (config == null && jndiName == null) {
            throw new IllegalStateException("Either 'config' or 'jndiName' parameter must be specified");
        }
        if (realmName != null) {
            this.defaultRealmName = realmName.getValue();
        }
        SessionFactory sf = null;
        if (initParams.containsKey((Object)PARAM_HIBERNATE_PROPS)) {
            PropertiesParam param = initParams.getPropertiesParam(PARAM_HIBERNATE_PROPS);
            AnnotationConfiguration conf_ = new AnnotationConfiguration();
            Iterator properties = param.getPropertyIterator();
            while (properties.hasNext()) {
                Property p = (Property)properties.next();
                String name = p.getName();
                String value = p.getValue();
                if (name.equals("hibernate.dialect")) {
                    Package pkg = Dialect.class.getPackage();
                    String dialect = value.substring(22);
                    value = pkg.getName() + "." + dialect;
                    log_.info((Object)("Using dialect " + dialect));
                }
                conf_.setProperty(name, value);
            }
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (initParams.containsKey((Object)PARAM_HIBERNATE_MAPPINGS)) {
                ValuesParam mappings = initParams.getValuesParam(PARAM_HIBERNATE_MAPPINGS);
                ArrayList paths = mappings.getValues();
                for (String path : paths) {
                    URL url = cl.getResource(path);
                    log_.info((Object)("Adding  Hibernate Mapping: " + path));
                    conf_.addURL(url);
                }
            }
            if (initParams.containsKey((Object)PARAM_HIBERNATE_ANNOTATIONS)) {
                ValuesParam annotations = initParams.getValuesParam(PARAM_HIBERNATE_ANNOTATIONS);
                ArrayList classes = annotations.getValues();
                for (String name : classes) {
                    Class<?> clazz = cl.loadClass(name);
                    conf_.addAnnotatedClass(clazz);
                }
            }
            sf = conf_.buildSessionFactory();
        }
        if (config != null) {
            this.config = config.getValue();
            URL configURL = confManager.getURL(this.config);
            if (configURL == null) {
                throw new IllegalStateException("Cannot fine resource: " + this.config);
            }
            IdentityConfigurationMetaData configMD = JAXB2IdentityConfiguration.createConfigurationMetaData((InputStream)confManager.getInputStream(this.config));
            this.identityConfiguration = new IdentityConfigurationImpl().configure(configMD);
            if (sf != null) {
                this.identityConfiguration.getIdentityConfigurationRegistry().register((Object)sf, "hibernateSessionFactory");
            }
        } else {
            identitySessionFactory = (IdentitySessionFactory)new InitialContext().lookup(jndiName.getValue());
        }
    }

    public void start() {
        if (identitySessionFactory == null) {
            try {
                identitySessionFactory = this.identityConfiguration.buildIdentitySessionFactory();
            }
            catch (IdentityConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void stop() {
    }

    public IdentitySessionFactory getIdentitySessionFactory() {
        return identitySessionFactory;
    }

    public IdentitySession getIdentitySession() throws Exception {
        return this.getIdentitySessionFactory().getCurrentIdentitySession(this.defaultRealmName);
    }

    public IdentitySession getIdentitySession(String realm) throws Exception {
        if (realm == null) {
            throw new IllegalArgumentException("Realm name cannot be null");
        }
        return this.getIdentitySessionFactory().getCurrentIdentitySession(realm);
    }
}

