/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.jbidm;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.naming.InvalidNameException;
import org.exoplatform.commons.utils.ListenerStack;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.jbidm.GroupDAOImpl;
import org.exoplatform.services.organization.jbidm.JBossIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.jbidm.JBossIDMService;
import org.exoplatform.services.organization.jbidm.MembershipImpl;
import org.jboss.identity.idm.api.IdentitySession;
import org.jboss.identity.idm.api.Role;
import org.jboss.identity.idm.api.RoleType;

public class MembershipDAOImpl
implements MembershipHandler {
    private JBossIDMService service_;
    private List listeners_;
    private JBossIDMOrganizationServiceImpl orgService;

    public MembershipDAOImpl(JBossIDMOrganizationServiceImpl orgService, JBossIDMService service) {
        this.service_ = service;
        this.listeners_ = new ListenerStack(5);
        this.orgService = orgService;
    }

    public void addMembershipEventListener(MembershipEventListener listener) {
        this.listeners_.add(listener);
    }

    public final Membership createMembershipInstance() {
        return new MembershipImpl();
    }

    public void createMembership(Membership m, boolean broadcast) throws Exception {
        if (broadcast) {
            this.preSave(m, true);
        }
        this.saveMembership(m, false);
        if (broadcast) {
            this.postSave(m, true);
        }
    }

    public void linkMembership(User user, Group g, MembershipType mt, boolean broadcast) throws Exception {
        if (g == null) {
            throw new InvalidNameException("Can not create membership record for " + user.getUserName() + " because group is null");
        }
        if (mt == null) {
            throw new InvalidNameException("Can not create membership record for " + user.getUserName() + " because membership type is null");
        }
        if (this.getIdentitySession().getRoleManager().getRoleType(mt.getName()) == null) {
            this.getIdentitySession().getRoleManager().createRoleType(mt.getName());
        }
        String groupId = this.getIdentitySession().getPersistenceManager().createGroupId(g.getGroupName(), this.orgService.getExoGroupType());
        if (this.getIdentitySession().getRoleManager().hasRole(user.getUserName(), groupId, mt.getName())) {
            return;
        }
        MembershipImpl membership = new MembershipImpl();
        membership.setMembershipType(mt.getName());
        membership.setUserName(user.getUserName());
        membership.setGroupId(g.getId());
        if (broadcast) {
            this.preSave(membership, true);
        }
        this.getIdentitySession().getRoleManager().createRole(mt.getName(), user.getUserName(), groupId);
        if (broadcast) {
            this.postSave(membership, true);
        }
    }

    public void saveMembership(Membership m, boolean broadcast) throws Exception {
        String groupId = this.getIdentitySession().getPersistenceManager().createGroupId(this.getGroupNameFromId(m.getGroupId()), this.orgService.getExoGroupType());
        if (this.getIdentitySession().getRoleManager().hasRole(m.getUserName(), groupId, m.getMembershipType())) {
            return;
        }
        if (broadcast) {
            this.preSave(m, false);
        }
        this.getIdentitySession().getRoleManager().createRole(m.getMembershipType(), m.getUserName(), groupId);
        if (broadcast) {
            this.postSave(m, false);
        }
    }

    public Membership removeMembership(String id, boolean broadcast) throws Exception {
        MembershipImpl m = new MembershipImpl(id);
        String groupId = this.getIdentitySession().getPersistenceManager().createGroupId(this.getGroupNameFromId(m.getGroupId()), this.orgService.getExoGroupType());
        if (!this.getIdentitySession().getRoleManager().hasRole(m.getUserName(), groupId, m.getMembershipType())) {
            return m;
        }
        if (broadcast) {
            this.preDelete(m);
        }
        this.getIdentitySession().getRoleManager().removeRole(m.getMembershipType(), m.getUserName(), groupId);
        if (broadcast) {
            this.postDelete(m);
        }
        return m;
    }

    public Collection removeMembershipByUser(String userName, boolean broadcast) throws Exception {
        Collection roles = this.getIdentitySession().getRoleManager().findRoles(userName, null);
        LinkedList<MembershipImpl> memberships = new LinkedList<MembershipImpl>();
        for (Role role : roles) {
            MembershipImpl m = new MembershipImpl();
            Group g = ((GroupDAOImpl)this.orgService.getGroupHandler()).getGroup(role.getGroup().getName());
            m.setGroupId(g.getId());
            m.setUserName(role.getUser().getId());
            m.setMembershipType(role.getRoleType().getName());
            memberships.add(m);
            if (broadcast) {
                this.preDelete(m);
            }
            this.getIdentitySession().getRoleManager().removeRole(role);
            if (!broadcast) continue;
            this.postDelete(m);
        }
        return memberships;
    }

    public Membership findMembershipByUserGroupAndType(String userName, String groupId, String type) throws Exception {
        String gid = this.getIdentitySession().getPersistenceManager().createGroupId(this.getGroupNameFromId(groupId), this.orgService.getExoGroupType());
        Role role = this.getIdentitySession().getRoleManager().getRole(type, userName, gid);
        if (role == null) {
            return null;
        }
        MembershipImpl m = new MembershipImpl();
        m.setGroupId(groupId);
        m.setUserName(userName);
        m.setMembershipType(type);
        return m;
    }

    public Collection findMembershipsByUserAndGroup(String userName, String groupId) throws Exception {
        if (userName == null) {
            return Collections.emptyList();
        }
        String gid = this.getIdentitySession().getPersistenceManager().createGroupId(this.getGroupNameFromId(groupId), this.orgService.getExoGroupType());
        Collection roleTypes = this.getIdentitySession().getRoleManager().findRoleTypes(userName, gid, null);
        LinkedList<MembershipImpl> memberships = new LinkedList<MembershipImpl>();
        for (RoleType roleType : roleTypes) {
            MembershipImpl m = new MembershipImpl();
            m.setGroupId(groupId);
            m.setUserName(userName);
            m.setMembershipType(roleType.getName());
            memberships.add(m);
        }
        return memberships;
    }

    public Collection findMembershipsByUser(String userName) throws Exception {
        Collection roles = this.getIdentitySession().getRoleManager().findRoles(userName, null);
        LinkedList<MembershipImpl> memberships = new LinkedList<MembershipImpl>();
        for (Role role : roles) {
            MembershipImpl m = new MembershipImpl();
            Group g = ((GroupDAOImpl)this.orgService.getGroupHandler()).getGroup(role.getGroup().getName());
            m.setGroupId(g.getId());
            m.setUserName(role.getUser().getId());
            m.setMembershipType(role.getRoleType().getName());
            memberships.add(m);
        }
        return memberships;
    }

    static void removeMembershipEntriesOfGroup(JBossIDMOrganizationServiceImpl orgService, Group group, IdentitySession session) throws Exception {
        String gid = session.getPersistenceManager().createGroupId(group.getGroupName(), orgService.getExoGroupType());
        Collection roles = session.getRoleManager().findRoles(gid, null);
        for (Role role : roles) {
            session.getRoleManager().removeRole(role);
        }
    }

    public Collection findMembershipsByGroup(Group group) throws Exception {
        return this.findMembershipsByGroupId(group.getId());
    }

    public Collection findMembershipsByGroupId(String groupId) throws Exception {
        String gid = this.getIdentitySession().getPersistenceManager().createGroupId(this.getGroupNameFromId(groupId), this.orgService.getExoGroupType());
        Collection roles = this.getIdentitySession().getRoleManager().findRoles(gid, null);
        LinkedList<MembershipImpl> memberships = new LinkedList<MembershipImpl>();
        for (Role role : roles) {
            MembershipImpl m = new MembershipImpl();
            Group g = ((GroupDAOImpl)this.orgService.getGroupHandler()).getGroup(role.getGroup().getName());
            m.setGroupId(g.getId());
            m.setUserName(role.getUser().getId());
            m.setMembershipType(role.getRoleType().getName());
            memberships.add(m);
        }
        return memberships;
    }

    public Membership findMembership(String id) throws Exception {
        MembershipImpl m = new MembershipImpl(id);
        String groupId = this.getIdentitySession().getPersistenceManager().createGroupId(this.getGroupNameFromId(m.getGroupId()), this.orgService.getExoGroupType());
        if (this.getIdentitySession().getRoleManager().hasRole(m.getUserName(), groupId, m.getMembershipType())) {
            return m;
        }
        return null;
    }

    private void preSave(Membership membership, boolean isNew) throws Exception {
        for (int i = 0; i < this.listeners_.size(); ++i) {
            MembershipEventListener listener = (MembershipEventListener)this.listeners_.get(i);
            listener.preSave(membership, isNew);
        }
    }

    private void postSave(Membership membership, boolean isNew) throws Exception {
        for (int i = 0; i < this.listeners_.size(); ++i) {
            MembershipEventListener listener = (MembershipEventListener)this.listeners_.get(i);
            listener.postSave(membership, isNew);
        }
    }

    private void preDelete(Membership membership) throws Exception {
        for (int i = 0; i < this.listeners_.size(); ++i) {
            MembershipEventListener listener = (MembershipEventListener)this.listeners_.get(i);
            listener.preDelete(membership);
        }
    }

    private void postDelete(Membership membership) throws Exception {
        for (int i = 0; i < this.listeners_.size(); ++i) {
            MembershipEventListener listener = (MembershipEventListener)this.listeners_.get(i);
            listener.postDelete(membership);
        }
    }

    private IdentitySession getIdentitySession() throws Exception {
        return this.service_.getIdentitySession();
    }

    private String getGroupNameFromId(String groupId) {
        String[] ids = groupId.split("/");
        return ids[ids.length - 1];
    }
}

