/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.jbidm;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.impl.UserImpl;
import org.exoplatform.services.organization.jbidm.IDMUserListAccess;
import org.exoplatform.services.organization.jbidm.JBossIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.jbidm.JBossIDMService;
import org.jboss.identity.idm.api.Attribute;
import org.jboss.identity.idm.api.AttributesManager;
import org.jboss.identity.idm.api.IdentitySession;
import org.jboss.identity.idm.api.query.UserQueryBuilder;
import org.jboss.identity.idm.impl.api.SimpleAttribute;

public class UserDAOImpl
implements UserHandler {
    private final JBossIDMService service_;
    private ExoCache cache_;
    private List<UserEventListener> listeners_ = new ArrayList<UserEventListener>(3);
    public static final String USER_PASSWORD = "password";
    public static final String USER_FIRST_NAME = "firstName";
    public static final String USER_LAST_NAME = "lastName";
    public static final String USER_EMAIL = "email";
    public static final String USER_CREATED_DATE = "createdDate";
    public static final String USER_LAST_LOGIN_TIME = "lastLoginTime";
    public static final String USER_ORGANIZATION_ID = "organizationId";
    public static final Set<String> USER_NON_PROFILE_KEYS;
    public static final DateFormat dateFormat;
    private JBossIDMOrganizationServiceImpl orgService;

    public UserDAOImpl(JBossIDMOrganizationServiceImpl orgService, JBossIDMService idmService, CacheService cservice) throws Exception {
        this.service_ = idmService;
        this.cache_ = cservice.getCacheInstance(UserImpl.class.getName());
        this.orgService = orgService;
    }

    public final List getUserEventListeners() {
        return this.listeners_;
    }

    public void addUserEventListener(UserEventListener listener) {
        this.listeners_.add(listener);
    }

    public User createUserInstance() {
        return new UserImpl();
    }

    public User createUserInstance(String username) {
        return new UserImpl(username);
    }

    public void createUser(User user, boolean broadcast) throws Exception {
        IdentitySession session = this.service_.getIdentitySession();
        if (broadcast) {
            this.preSave(user, true);
        }
        session.getPersistenceManager().createUser(user.getUserName());
        this.persistUserInfo(user, session);
        if (broadcast) {
            this.postSave(user, true);
        }
    }

    public void saveUser(User user, boolean broadcast) throws Exception {
        IdentitySession session = this.service_.getIdentitySession();
        if (broadcast) {
            this.preSave(user, false);
        }
        this.persistUserInfo(user, session);
        if (broadcast) {
            this.postSave(user, false);
        }
        this.cache_.put((Serializable)((Object)user.getUserName()), (Object)user);
    }

    public User removeUser(String userName, boolean broadcast) throws Exception {
        IdentitySession session = this.service_.getIdentitySession();
        org.jboss.identity.idm.api.User foundUser = session.getPersistenceManager().findUser(userName);
        if (foundUser == null) {
            this.cache_.remove((Serializable)((Object)userName));
            return null;
        }
        User exoUser = UserDAOImpl.getPopulatedUser(userName, session);
        if (broadcast) {
            this.preDelete(exoUser);
        }
        session.getPersistenceManager().removeUser(foundUser, true);
        if (broadcast) {
            this.postDelete(exoUser);
        }
        this.cache_.remove((Serializable)((Object)userName));
        return exoUser;
    }

    public User findUserByName(String userName) throws Exception {
        IdentitySession session = this.service_.getIdentitySession();
        User user = (User)this.cache_.get((Serializable)((Object)userName));
        if (user != null) {
            return user;
        }
        user = UserDAOImpl.getPopulatedUser(userName, session);
        if (user != null) {
            this.cache_.put((Serializable)((Object)userName), (Object)user);
        }
        return user;
    }

    public LazyPageList getUserPageList(int pageSize) throws Exception {
        UserQueryBuilder qb = this.service_.getIdentitySession().createUserQueryBuilder();
        return new LazyPageList((ListAccess)new IDMUserListAccess(this, this.service_, qb, pageSize, true), pageSize);
    }

    public boolean authenticate(String username, String password) throws Exception {
        User user = this.findUserByName(username);
        if (user == null) {
            return false;
        }
        boolean authenticated = false;
        if (this.orgService.isPasswordAsAttribute()) {
            authenticated = user.getPassword().equals(password);
        } else {
            IdentitySession session = this.service_.getIdentitySession();
            org.jboss.identity.idm.api.User idmUser = session.getPersistenceManager().findUser(user.getUserName());
            authenticated = session.getAttributesManager().validatePassword(idmUser, password);
        }
        if (authenticated) {
            UserImpl userImpl = (UserImpl)user;
            userImpl.setLastLoginTime(Calendar.getInstance().getTime());
            this.saveUser((User)userImpl, false);
        }
        return authenticated;
    }

    public LazyPageList findUsers(Query q) throws Exception {
        UserQueryBuilder qb = this.service_.getIdentitySession().createUserQueryBuilder();
        if (q.getUserName() != null) {
            qb.idFilter(q.getUserName());
        }
        if (q.getEmail() != null) {
            qb.attributeValuesFilter(USER_EMAIL, new String[]{q.getEmail()});
        }
        if (q.getFirstName() != null) {
            qb.attributeValuesFilter(USER_FIRST_NAME, new String[]{q.getFirstName()});
        }
        if (q.getLastName() != null) {
            qb.attributeValuesFilter(USER_LAST_NAME, new String[]{q.getLastName()});
        }
        return new LazyPageList((ListAccess)new IDMUserListAccess(this, this.service_, qb, 20, false), 20);
    }

    public LazyPageList findUsersByGroup(String groupId) throws Exception {
        UserQueryBuilder qb = this.service_.getIdentitySession().createUserQueryBuilder();
        qb.addRelatedGroup(groupId);
        return new LazyPageList((ListAccess)new IDMUserListAccess(this, this.service_, qb, 20, true), 20);
    }

    private void preSave(User user, boolean isNew) throws Exception {
        for (UserEventListener listener : this.listeners_) {
            listener.preSave(user, isNew);
        }
    }

    private void postSave(User user, boolean isNew) throws Exception {
        for (UserEventListener listener : this.listeners_) {
            listener.postSave(user, isNew);
        }
    }

    private void preDelete(User user) throws Exception {
        for (UserEventListener listener : this.listeners_) {
            listener.preDelete(user);
        }
    }

    private void postDelete(User user) throws Exception {
        for (UserEventListener listener : this.listeners_) {
            listener.postDelete(user);
        }
    }

    public void persistUserInfo(User user, IdentitySession session) throws Exception {
        AttributesManager am = session.getAttributesManager();
        ArrayList<SimpleAttribute> attributes = new ArrayList<SimpleAttribute>();
        if (user.getCreatedDate() != null) {
            attributes.add(new SimpleAttribute(USER_CREATED_DATE, (Object)dateFormat.format(user.getCreatedDate())));
        }
        if (user.getLastLoginTime() != null) {
            attributes.add(new SimpleAttribute(USER_LAST_LOGIN_TIME, (Object)dateFormat.format(user.getLastLoginTime())));
        }
        if (user.getEmail() != null) {
            attributes.add(new SimpleAttribute(USER_EMAIL, (Object)user.getEmail()));
        }
        if (user.getFirstName() != null) {
            attributes.add(new SimpleAttribute(USER_FIRST_NAME, (Object)user.getFirstName()));
        }
        if (user.getLastName() != null) {
            attributes.add(new SimpleAttribute(USER_LAST_NAME, (Object)user.getLastName()));
        }
        if (user.getOrganizationId() != null) {
            attributes.add(new SimpleAttribute(USER_ORGANIZATION_ID, (Object)user.getOrganizationId()));
        }
        if (user.getPassword() != null) {
            if (this.orgService.isPasswordAsAttribute()) {
                attributes.add(new SimpleAttribute(USER_PASSWORD, (Object)user.getPassword()));
            } else {
                am.updatePassword(session.getPersistenceManager().findUser(user.getUserName()), user.getPassword());
            }
        }
        Attribute[] attrs = new Attribute[attributes.size()];
        attrs = attributes.toArray(attrs);
        am.addAttributes(user.getUserName(), attrs);
    }

    public static User getPopulatedUser(String userName, IdentitySession session) throws Exception {
        if (session.getPersistenceManager().findUser(userName) == null) {
            return null;
        }
        AttributesManager am = session.getAttributesManager();
        Map attrs = am.getAttributes(userName);
        UserImpl user = new UserImpl(userName);
        if (attrs == null) {
            return user;
        }
        if (attrs.containsKey(USER_CREATED_DATE)) {
            user.setCreatedDate(dateFormat.parse(((Attribute)attrs.get(USER_CREATED_DATE)).getValue().toString()));
        }
        if (attrs.containsKey(USER_EMAIL)) {
            user.setEmail(((Attribute)attrs.get(USER_EMAIL)).getValue().toString());
        }
        if (attrs.containsKey(USER_FIRST_NAME)) {
            user.setFirstName(((Attribute)attrs.get(USER_FIRST_NAME)).getValue().toString());
        }
        if (attrs.containsKey(USER_LAST_LOGIN_TIME)) {
            user.setLastLoginTime(dateFormat.parse(((Attribute)attrs.get(USER_LAST_LOGIN_TIME)).getValue().toString()));
        }
        if (attrs.containsKey(USER_LAST_NAME)) {
            user.setLastName(((Attribute)attrs.get(USER_LAST_NAME)).getValue().toString());
        }
        if (attrs.containsKey(USER_ORGANIZATION_ID)) {
            user.setOrganizationId(((Attribute)attrs.get(USER_ORGANIZATION_ID)).getValue().toString());
        }
        if (attrs.containsKey(USER_PASSWORD)) {
            user.setPassword(((Attribute)attrs.get(USER_PASSWORD)).getValue().toString());
        }
        return user;
    }

    static {
        dateFormat = DateFormat.getInstance();
        HashSet<String> keys = new HashSet<String>();
        keys.add(USER_PASSWORD);
        keys.add(USER_FIRST_NAME);
        keys.add(USER_LAST_NAME);
        keys.add(USER_EMAIL);
        keys.add(USER_CREATED_DATE);
        keys.add(USER_LAST_LOGIN_TIME);
        keys.add(USER_ORGANIZATION_ID);
        USER_NON_PROFILE_KEYS = Collections.unmodifiableSet(keys);
    }
}

