/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileEventListener;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.organization.idm.Config;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.UserDAOImpl;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.test.jcr-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="org/exoplatform/services/organization/TestOrganizationService-configuration.xml")})
public class TestOrganizationService
extends AbstractKernelTest {
    static String Group1 = "Group1";
    static String Group2 = "Group2";
    static String Group3 = "Group3";
    static String Benj = "Benj";
    static String Tuan = "Tuan";
    OrganizationService service_;
    UserHandler userHandler_;
    UserProfileHandler profileHandler_;
    GroupHandler groupHandler_;
    MembershipTypeHandler mtHandler_;
    MembershipHandler membershipHandler_;
    boolean runtest = true;
    private static final String USER = "test";
    private static final List<String> USERS = new ArrayList<String>(15);
    private static final int USERS_LIST_SIZE = 15;
    private PortalContainer manager;

    public TestOrganizationService(String s) {
        super(s);
    }

    public void setUp() throws Exception {
        if (!this.runtest) {
            return;
        }
        this.manager = PortalContainer.getInstance();
        this.service_ = (OrganizationService)this.manager.getComponentInstanceOfType(OrganizationService.class);
        this.userHandler_ = this.service_.getUserHandler();
        this.profileHandler_ = this.service_.getUserProfileHandler();
        this.groupHandler_ = this.service_.getGroupHandler();
        this.mtHandler_ = this.service_.getMembershipTypeHandler();
        this.membershipHandler_ = this.service_.getMembershipHandler();
        RequestLifeCycle.begin((ComponentRequestLifecycle)((ComponentRequestLifecycle)this.service_));
    }

    public void tearDown() throws Exception {
        Query query = new Query();
        query.setUserName("test*");
        PageList users = this.userHandler_.findUsers(query);
        List allUsers = users.getAll();
        for (int i = allUsers.size() - 1; i >= 0; --i) {
            String userName = ((User)allUsers.get(i)).getUserName();
            this.userHandler_.removeUser(userName, true);
        }
        RequestLifeCycle.end();
    }

    public void testSimple() throws Exception {
        TestOrganizationService.assertTrue((boolean)true);
        Config config = ((PicketLinkIDMOrganizationServiceImpl)this.service_).getConfiguration();
        TestOrganizationService.assertNotNull((Object)config);
        TestOrganizationService.assertNotNull((Object)config.getGroupTypeMappings());
        TestOrganizationService.assertNotNull(config.getGroupTypeMappings().keySet());
        TestOrganizationService.assertEquals((int)config.getGroupTypeMappings().keySet().size(), (int)5);
        TestOrganizationService.assertEquals((String)((String)config.getGroupTypeMappings().get("/")), (String)"root_type");
        TestOrganizationService.assertEquals((String)config.getGroupType("/"), (String)"root_type");
        TestOrganizationService.assertEquals((String)config.getGroupType(null), (String)"root_type");
        TestOrganizationService.assertEquals((String)config.getGroupType("/platform"), (String)"platform_type");
        TestOrganizationService.assertEquals((String)config.getGroupType("/platform/administrators"), (String)"platform_type");
        TestOrganizationService.assertEquals((String)config.getGroupType("/platform/guests"), (String)"platform_type");
        TestOrganizationService.assertEquals((String)config.getGroupType("/platform/users"), (String)"users_type");
        TestOrganizationService.assertEquals((String)config.getGroupType("/platform/users/john"), (String)"platform_type");
        TestOrganizationService.assertEquals((String)config.getGroupType("/organization/acme/france/offices"), (String)".organization.acme.france.offices");
        TestOrganizationService.assertEquals((String)config.getGroupType("/organization/acme/france/offices/paris"), (String)".organization.acme.france.offices.paris");
        TestOrganizationService.assertEquals((String)config.getGroupType("/organization/acme/france"), (String)"france_type");
        TestOrganizationService.assertEquals((String)config.getGroupType("/organization/acme"), (String)".organization.acme");
        TestOrganizationService.assertEquals((String)config.getGroupType("/foo/bar"), (String)".foo.bar");
        TestOrganizationService.assertEquals((String)config.getGroupType("/foo"), (String)".foo");
        TestOrganizationService.assertEquals((String)config.getGroupType("/toto"), (String)"toto_type");
        TestOrganizationService.assertEquals((String)config.getGroupType("/toto/lolo"), (String)"toto_type");
        TestOrganizationService.assertEquals((String)config.getGroupType("/toto/lolo/tutu"), (String)"toto_type");
    }

    public void testUserPageSize() throws Exception {
        for (String name : USERS) {
            this.createUser(name);
        }
        Query query = new Query();
        PageList users = this.userHandler_.findUsers(query);
        TestOrganizationService.assertEquals((int)16, (int)users.getAll().size());
        TestOrganizationService.assertEquals((int)1, (int)users.getAvailablePage());
        for (Object o : users.getPage(1)) {
            User u = (User)o;
            if (u.getUserName().equals("demo")) continue;
            TestOrganizationService.assertTrue((boolean)USERS.contains(u.getUserName()));
        }
    }

    public void testUser() throws Exception {
        this.createUser(USER);
        User user = this.userHandler_.findUserByName(USER);
        TestOrganizationService.assertTrue((String)"Found user instance ", (user != null ? 1 : 0) != 0);
        TestOrganizationService.assertEquals((String)"Expect user name is: ", (String)USER, (String)user.getUserName());
        UserProfile userProfile = this.profileHandler_.findUserProfileByName(USER);
        TestOrganizationService.assertNull((Object)this.profileHandler_.removeUserProfile(USER, true));
        TestOrganizationService.assertNotNull((Object)this.profileHandler_.findUserProfileByName(USER));
        userProfile = this.profileHandler_.createUserProfileInstance(USER);
        userProfile.getUserInfoMap().put("key", "value");
        this.profileHandler_.saveUserProfile(userProfile, true);
        userProfile = this.profileHandler_.findUserProfileByName(USER);
        TestOrganizationService.assertTrue((String)"Expect user profile is found: ", (userProfile != null ? 1 : 0) != 0);
        TestOrganizationService.assertEquals((String)((String)userProfile.getUserInfoMap().get("key")), (String)"value");
        PageList users = this.userHandler_.findUsers(new Query());
        TestOrganizationService.assertTrue((String)"Expect 1 user found ", (users.getAvailable() >= 1 ? 1 : 0) != 0);
        user.setFirstName("Exo(Update)");
        this.userHandler_.saveUser(user, false);
        userProfile.getUserInfoMap().put("user.gender", "male");
        this.profileHandler_.saveUserProfile(userProfile, true);
        userProfile = this.profileHandler_.findUserProfileByName(USER);
        TestOrganizationService.assertEquals((String)"expect first name is", (String)"Exo(Update)", (String)user.getFirstName());
        TestOrganizationService.assertEquals((String)"Expect profile is updated: user.gender is ", (String)"male", (String)((String)userProfile.getUserInfoMap().get("user.gender")));
        PageList piterator = this.userHandler_.getUserPageList(10);
        TestOrganizationService.assertEquals((int)2, (int)piterator.currentPage().size());
        this.userHandler_.removeUser(USER, true);
        piterator = this.userHandler_.getUserPageList(10);
        TestOrganizationService.assertEquals((int)1, (int)piterator.currentPage().size());
        TestOrganizationService.assertNull((String)"User: USER is removed: ", (Object)this.userHandler_.findUserByName(USER));
        TestOrganizationService.assertNull((String)" user's profile of USER was removed:", (Object)this.profileHandler_.findUserProfileByName(USER));
    }

    public void testUniqueAttribute() throws Exception {
        if (this.userHandler_ instanceof UserDAOImpl) {
            UserDAOImpl ud = (UserDAOImpl)this.userHandler_;
            User user = this.userHandler_.createUserInstance("toto");
            user.setEmail("toto@gatein.org");
            this.userHandler_.createUser(user, true);
            user = this.userHandler_.createUserInstance("lolo");
            user.setEmail("lolo@gatein.org");
            this.userHandler_.createUser(user, true);
            TestOrganizationService.assertNull((Object)ud.findUserByEmail("foobar"));
            user = ud.findUserByEmail("toto@gatein.org");
            TestOrganizationService.assertNotNull((Object)user);
            TestOrganizationService.assertEquals((String)"toto", (String)user.getUserName());
            user = ud.findUserByEmail("lolo@gatein.org");
            TestOrganizationService.assertNotNull((Object)user);
            TestOrganizationService.assertEquals((String)"lolo", (String)user.getUserName());
            ud.removeUser("toto", false);
            ud.removeUser("lolo", false);
        }
    }

    public void testFindUsers() throws Exception {
        if (this.userHandler_ instanceof UserDAOImpl) {
            UserDAOImpl ud = (UserDAOImpl)this.userHandler_;
            User user1 = ud.createUserInstance("foo");
            user1.setFirstName("foo");
            user1.setLastName("bar");
            user1.setEmail("foo@bar.com");
            ud.createUser(user1, true);
            User user2 = ud.createUserInstance("foobar");
            user2.setFirstName("foobar");
            user2.setLastName("foobar");
            user2.setEmail("foobar@foobar.com");
            ud.createUser(user2, true);
            Query query = new Query();
            List users = ud.findUsers(query).getAll();
            TestOrganizationService.assertEquals((int)3, (int)users.size());
            TestOrganizationService.assertEquals((String)"demo", (String)((User)users.get(0)).getUserName());
            TestOrganizationService.assertEquals((String)"foo", (String)((User)users.get(1)).getUserName());
            TestOrganizationService.assertEquals((String)"foobar", (String)((User)users.get(2)).getUserName());
            query.setEmail("*foo*");
            users = ud.findUsers(query).getAll();
            TestOrganizationService.assertEquals((int)2, (int)users.size());
            TestOrganizationService.assertEquals((String)"foo", (String)((User)users.get(0)).getUserName());
            TestOrganizationService.assertEquals((String)"foobar", (String)((User)users.get(1)).getUserName());
            query.setEmail("*bar*");
            users = ud.findUsers(query).getAll();
            TestOrganizationService.assertEquals((int)2, (int)users.size());
            TestOrganizationService.assertEquals((String)"foo", (String)((User)users.get(0)).getUserName());
            TestOrganizationService.assertEquals((String)"foobar", (String)((User)users.get(1)).getUserName());
            query.setEmail("*bar.com*");
            users = ud.findUsers(query).getAll();
            TestOrganizationService.assertEquals((int)2, (int)users.size());
            TestOrganizationService.assertEquals((String)"foo", (String)((User)users.get(0)).getUserName());
            TestOrganizationService.assertEquals((String)"foobar", (String)((User)users.get(1)).getUserName());
            query.setEmail("*foobar*");
            users = ud.findUsers(query).getAll();
            TestOrganizationService.assertEquals((int)1, (int)users.size());
            TestOrganizationService.assertEquals((String)"foobar", (String)((User)users.get(0)).getUserName());
        }
    }

    public void testGroup() throws Exception {
        String parentName = "GroupParent";
        Group groupParent = this.groupHandler_.createGroupInstance();
        groupParent.setGroupName(parentName);
        groupParent.setDescription("This is description");
        this.groupHandler_.addChild(null, groupParent, true);
        groupParent = this.groupHandler_.findGroupById(groupParent.getId());
        TestOrganizationService.assertEquals((String)"GroupParent", (String)groupParent.getGroupName());
        Group groupChild1 = this.groupHandler_.createGroupInstance();
        groupChild1.setGroupName(Group1);
        groupChild1.setLabel("Group1 Label");
        this.groupHandler_.addChild(groupParent, groupChild1, true);
        TestOrganizationService.assertEquals((String)this.groupHandler_.findGroupById(groupChild1.getId()).getLabel(), (String)"Group1 Label");
        groupChild1 = this.groupHandler_.findGroupById(groupChild1.getId());
        TestOrganizationService.assertEquals((String)groupChild1.getParentId(), (String)groupParent.getId());
        TestOrganizationService.assertEquals((String)"Expect group child's name is: ", (String)Group1, (String)groupChild1.getGroupName());
        groupChild1.setLabel("Group1 Label renamed");
        groupChild1.setDescription("new description ");
        this.groupHandler_.saveGroup(groupChild1, true);
        TestOrganizationService.assertEquals((String)this.groupHandler_.findGroupById(groupChild1.getId()).getLabel(), (String)"Group1 Label renamed");
        Group groupChild2 = this.groupHandler_.createGroupInstance();
        groupChild2.setGroupName(Group2);
        this.groupHandler_.addChild(groupParent, groupChild2, true);
        groupChild2 = this.groupHandler_.findGroupById(groupChild2.getId());
        TestOrganizationService.assertEquals((String)groupChild2.getParentId(), (String)groupParent.getId());
        TestOrganizationService.assertEquals((String)"Expect group child's name is: ", (String)Group2, (String)groupChild2.getGroupName());
        TestOrganizationService.assertEquals((String)"Expect number of child group in parent group is: ", (int)2, (int)this.groupHandler_.findGroups(groupParent).size());
        this.groupHandler_.removeGroup(this.groupHandler_.findGroupById(groupChild1.getId()), true);
        TestOrganizationService.assertNull((String)"Expect child group has been removed: ", (Object)this.groupHandler_.findGroupById(groupChild1.getId()));
        TestOrganizationService.assertEquals((String)"Expect only 1 child group in parent group", (int)1, (int)this.groupHandler_.findGroups(groupParent).size());
        this.groupHandler_.removeGroup(groupParent, true);
        TestOrganizationService.assertEquals((String)"Expect ParentGroup is removed:", null, (Object)this.groupHandler_.findGroupById(groupParent.getId()));
        TestOrganizationService.assertEquals((String)"Expect all child group is removed: ", (int)0, (int)this.groupHandler_.findGroups(groupParent).size());
    }

    public void testMembershipType() throws Exception {
        String testType = "testType";
        MembershipType mt = this.mtHandler_.createMembershipTypeInstance();
        mt.setName(testType);
        mt.setDescription("This is a test");
        mt.setOwner("exo");
        this.mtHandler_.createMembershipType(mt, true);
        TestOrganizationService.assertEquals((String)"Expect mebershiptype is:", (String)testType, (String)this.mtHandler_.findMembershipType(testType).getName());
        String desc = "This is a test (update)";
        mt.setDescription(desc);
        this.mtHandler_.saveMembershipType(mt, true);
        TestOrganizationService.assertEquals((String)"Expect membershiptype's description", (String)desc, (String)this.mtHandler_.findMembershipType(testType).getDescription());
        mt = this.mtHandler_.createMembershipTypeInstance();
        mt.setName("anothertype");
        mt.setOwner("exo");
        this.mtHandler_.createMembershipType(mt, true);
        TestOrganizationService.assertEquals((String)"Expect 3 membership in collection: ", (int)3, (int)this.mtHandler_.findMembershipTypes().size());
        this.mtHandler_.removeMembershipType(testType, true);
        TestOrganizationService.assertEquals((String)"Membership type has been removed:", null, (Object)this.mtHandler_.findMembershipType(testType));
        TestOrganizationService.assertEquals((String)"Expect 2 membership in collection(1 is default): ", (int)2, (int)this.mtHandler_.findMembershipTypes().size());
        this.mtHandler_.removeMembershipType("anothertype", true);
        TestOrganizationService.assertEquals((String)"Membership type has been removed:", null, (Object)this.mtHandler_.findMembershipType("anothertype"));
        TestOrganizationService.assertEquals((String)"Expect 1 membership in collection(default type): ", (int)1, (int)this.mtHandler_.findMembershipTypes().size());
    }

    public void testMembership() throws Exception {
        User userBenj = this.createUser(Benj);
        User userTuan = this.createUser(Tuan);
        Group group1 = this.groupHandler_.createGroupInstance();
        group1.setGroupName(Group1);
        this.groupHandler_.addChild(null, group1, true);
        Group group2 = this.groupHandler_.createGroupInstance();
        group2.setGroupName(Group2);
        this.groupHandler_.addChild(null, group2, true);
        MembershipType mt = this.mtHandler_.createMembershipTypeInstance();
        mt.setName("testmembership");
        this.mtHandler_.createMembershipType(mt, true);
        this.membershipHandler_.linkMembership(userBenj, group1, mt, true);
        this.membershipHandler_.linkMembership(userBenj, group2, mt, true);
        this.membershipHandler_.linkMembership(userTuan, group2, mt, true);
        mt = this.mtHandler_.createMembershipTypeInstance();
        mt.setName("membershipType2");
        this.mtHandler_.createMembershipType(mt, true);
        this.membershipHandler_.linkMembership(userBenj, group2, mt, true);
        mt = this.mtHandler_.createMembershipTypeInstance();
        mt.setName("membershipType3");
        this.mtHandler_.createMembershipType(mt, true);
        this.membershipHandler_.linkMembership(userBenj, group2, mt, true);
        TestOrganizationService.assertEquals((String)"Expect number of membership in group 2 is: ", (int)4, (int)this.membershipHandler_.findMembershipsByGroup(group2).size());
        TestOrganizationService.assertEquals((String)("Expect number of membership in " + Group2 + " relate with benj is: "), (int)3, (int)this.membershipHandler_.findMembershipsByUserAndGroup(Benj, group2.getId()).size());
        TestOrganizationService.assertEquals((String)"expect membership is: ", (int)5, (int)this.membershipHandler_.findMembershipsByUser(Benj).size());
        Membership membership = this.membershipHandler_.findMembershipByUserGroupAndType(Benj, group2.getId(), "testmembership");
        TestOrganizationService.assertNotNull((String)"Expect membership is found:", (Object)membership);
        TestOrganizationService.assertEquals((String)"Expect membership type is: ", (String)"testmembership", (String)membership.getMembershipType());
        TestOrganizationService.assertEquals((String)"Expect groupId of this membership is: ", (String)group2.getId(), (String)membership.getGroupId());
        TestOrganizationService.assertEquals((String)"Expect user of this membership is: ", (String)Benj, (String)membership.getUserName());
        TestOrganizationService.assertEquals((String)"expect group is: ", (int)3, (int)this.groupHandler_.findGroupsOfUser(Benj).size());
        TestOrganizationService.assertEquals((String)"expect group is: ", (int)2, (int)this.groupHandler_.findGroupByMembership(Benj, "testmembership").size());
        String memId = this.membershipHandler_.findMembershipByUserGroupAndType(Benj, group2.getId(), "membershipType3").getId();
        this.membershipHandler_.removeMembership(memId, true);
        TestOrganizationService.assertNull((String)"Membership was removed: ", (Object)this.membershipHandler_.findMembershipByUserGroupAndType(Benj, "/" + Group2, "membershipType3"));
        this.userHandler_.removeUser(Tuan, true);
        TestOrganizationService.assertNull((String)"This user was removed", (Object)this.userHandler_.findUserByName(Tuan));
        TestOrganizationService.assertTrue((String)"All membership related with this user was removed: ", (boolean)this.membershipHandler_.findMembershipsByUser(Tuan).isEmpty());
        this.groupHandler_.removeGroup(group1, true);
        TestOrganizationService.assertNull((String)"This group was removed ", (Object)this.groupHandler_.findGroupById(group1.getId()));
        TestOrganizationService.assertTrue((boolean)this.membershipHandler_.findMembershipsByGroup(group1).isEmpty());
        this.mtHandler_.removeMembershipType("testmembership", true);
        TestOrganizationService.assertNull((String)"This membershipType was removed: ", (Object)this.mtHandler_.findMembershipType("testmembership"));
        for (Object o : this.groupHandler_.findGroups(null)) {
            Group g = (Group)o;
            for (Object o1 : this.membershipHandler_.findMembershipsByGroup(g)) {
                Membership m = (Membership)o1;
                TestOrganizationService.assertFalse((String)"MembershipType of this membership is not: \"testmembership\"", (boolean)m.getMembershipType().equalsIgnoreCase("testmembership"));
            }
        }
    }

    public void testRemoveMembershipByUser() throws Exception {
        String Benj = "B";
        String Tuan = "T";
        User userBenj = this.createUser(Benj);
        User userTuan = this.createUser(Tuan);
        String Group1 = "G1";
        String Group2 = "G2";
        String Group3 = "G3";
        Group group1 = this.groupHandler_.createGroupInstance();
        group1.setGroupName(Group1);
        this.groupHandler_.addChild(null, group1, true);
        Group group2 = this.groupHandler_.createGroupInstance();
        group2.setGroupName(Group2);
        this.groupHandler_.addChild(null, group2, true);
        Group group3 = this.groupHandler_.createGroupInstance();
        group3.setGroupName(Group3);
        this.groupHandler_.addChild(null, group3, true);
        MembershipType mt = this.mtHandler_.createMembershipTypeInstance();
        mt.setName("testmembership_");
        this.mtHandler_.createMembershipType(mt, true);
        this.membershipHandler_.linkMembership(userBenj, group1, mt, true);
        this.membershipHandler_.linkMembership(userBenj, group2, mt, true);
        this.membershipHandler_.linkMembership(userBenj, group3, mt, true);
        this.membershipHandler_.linkMembership(userTuan, group1, mt, true);
        TestOrganizationService.assertEquals((int)this.membershipHandler_.removeMembershipByUser(Tuan, true).size(), (int)2);
        TestOrganizationService.assertEquals((int)this.membershipHandler_.removeMembershipByUser(Benj, true).size(), (int)4);
        this.mtHandler_.removeMembershipType("testmembership_", true);
        this.userHandler_.removeUser(Tuan, true);
        this.userHandler_.removeUser(Benj, true);
        this.groupHandler_.removeGroup(group1, true);
        this.groupHandler_.removeGroup(group2, true);
        this.groupHandler_.removeGroup(group3, true);
    }

    public void testLinkMembership() throws Exception {
        String g1 = "grp1";
        String usr1 = "usr1";
        String mstype1 = "mstype1";
        Group group1 = this.groupHandler_.createGroupInstance();
        group1.setGroupName(g1);
        this.groupHandler_.addChild(null, group1, true);
        User user = this.createUser(usr1);
        MembershipType mt = this.mtHandler_.createMembershipTypeInstance();
        mt.setName(mstype1);
        try {
            this.membershipHandler_.linkMembership(user, group1, mt, true);
            TestOrganizationService.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        TestOrganizationService.assertNull((Object)this.mtHandler_.findMembershipType(mstype1));
        this.userHandler_.removeUser(usr1, true);
        this.groupHandler_.removeGroup(group1, true);
    }

    public void testFindUsersByGroupId() throws Exception {
        PageList users = this.userHandler_.findUsersByGroup("/users");
        TestOrganizationService.assertTrue((users.getAvailable() > 0 ? 1 : 0) != 0);
    }

    public User createUser(String userName) throws Exception {
        User user = this.userHandler_.createUserInstance(userName);
        user.setPassword("default");
        user.setFirstName("default");
        user.setLastName("default");
        user.setEmail("exo@exoportal.org");
        this.userHandler_.createUser(user, true);
        return user;
    }

    static {
        for (int i = 0; i < 15; ++i) {
            USERS.add("test_" + i);
        }
    }

    private static class UserProfileListener
    extends UserProfileEventListener {
        boolean preSave;
        boolean postSave;
        boolean preDelete;
        boolean postDelete;

        private UserProfileListener() {
        }

        public void postDelete(UserProfile profile) throws Exception {
            Assert.assertEquals((String)TestOrganizationService.USER, (String)profile.getUserName());
            this.postDelete = true;
        }

        public void postSave(UserProfile profile, boolean isNew) throws Exception {
            Assert.assertEquals((String)TestOrganizationService.USER, (String)profile.getUserName());
            this.postSave = true;
        }

        public void preDelete(UserProfile profile) throws Exception {
            Assert.assertEquals((String)TestOrganizationService.USER, (String)profile.getUserName());
            this.preDelete = true;
        }

        public void preSave(UserProfile profile, boolean isNew) throws Exception {
            Assert.assertEquals((String)TestOrganizationService.USER, (String)profile.getUserName());
            this.preSave = true;
        }
    }
}

