/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization;

import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.impl.UserImpl;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.identity-configuration.xml")})
public class TestBootstrap
extends AbstractKernelTest {
    public void testWorkspace() throws Exception {
        PortalContainer container = PortalContainer.getInstance();
        HibernateService hibernate = (HibernateService)container.getComponentInstanceOfType(HibernateService.class);
        TestBootstrap.assertNotNull((Object)hibernate);
        OrganizationService organization = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
        TestBootstrap.assertNotNull((Object)organization);
    }

    public void testBasicOperation() throws Exception {
        PortalContainer container = PortalContainer.getInstance();
        OrganizationService organization = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
        TestBootstrap.assertNotNull((Object)organization);
        this.begin();
        UserImpl test = new UserImpl("testUser");
        organization.getUserHandler().createUser((User)test, false);
        test = organization.getUserHandler().findUserByName("toto");
        TestBootstrap.assertNull((Object)test);
        test = organization.getUserHandler().findUserByName("testUser");
        TestBootstrap.assertNotNull((Object)test);
        this.end();
    }
}

