/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.pc;

import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.pc.ExoPortletApplicationDeployer;
import org.exoplatform.portal.pc.ExoStateConverter;
import org.exoplatform.services.resources.ResourceBundleService;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.bridge.BridgeInterceptor;
import org.gatein.pc.federation.FederatingPortletInvoker;
import org.gatein.pc.federation.impl.FederatingPortletInvokerService;
import org.gatein.pc.portlet.PortletInvokerInterceptor;
import org.gatein.pc.portlet.aspects.CCPPInterceptor;
import org.gatein.pc.portlet.aspects.ConsumerCacheInterceptor;
import org.gatein.pc.portlet.aspects.ContextDispatcherInterceptor;
import org.gatein.pc.portlet.aspects.EventPayloadInterceptor;
import org.gatein.pc.portlet.aspects.PortletCustomizationInterceptor;
import org.gatein.pc.portlet.aspects.ProducerCacheInterceptor;
import org.gatein.pc.portlet.aspects.RequestAttributeConversationInterceptor;
import org.gatein.pc.portlet.aspects.SecureTransportInterceptor;
import org.gatein.pc.portlet.aspects.SessionInvalidatorInterceptor;
import org.gatein.pc.portlet.aspects.ValveInterceptor;
import org.gatein.pc.portlet.container.ContainerPortletDispatcher;
import org.gatein.pc.portlet.container.ContainerPortletInvoker;
import org.gatein.pc.portlet.container.managed.PortletApplicationRegistry;
import org.gatein.pc.portlet.impl.deployment.PortletApplicationDeployer;
import org.gatein.pc.portlet.impl.state.StateManagementPolicyService;
import org.gatein.pc.portlet.impl.state.producer.PortletStatePersistenceManagerService;
import org.gatein.pc.portlet.state.StateConverter;
import org.gatein.pc.portlet.state.StateManagementPolicy;
import org.gatein.pc.portlet.state.producer.PortletStatePersistenceManager;
import org.gatein.pc.portlet.state.producer.ProducerPortletInvoker;
import org.gatein.wci.impl.DefaultServletContainerFactory;
import org.picocontainer.Startable;

public class ExoKernelIntegration
implements Startable {
    protected PortletApplicationDeployer portletApplicationRegistry;
    private final ExoContainer container;
    private final ResourceBundleService resourceBundleService;
    private Logger log = LoggerFactory.getLogger(ExoKernelIntegration.class);

    public ExoKernelIntegration(ExoContainerContext context, ResourceBundleService resourceBundleService) {
        this.container = context.getContainer();
        this.resourceBundleService = resourceBundleService;
    }

    public void start() {
        ContainerPortletInvoker containerPortletInvoker = new ContainerPortletInvoker();
        this.portletApplicationRegistry = new ExoPortletApplicationDeployer();
        this.portletApplicationRegistry.setContainerPortletInvoker((PortletInvoker)containerPortletInvoker);
        String validation = PropertyManager.getProperty((String)"gatein.portlet.validation");
        boolean validated = validation == null || "true".equals(validation.trim().toLowerCase());
        this.log.debug((Object)("portlet xml validation is " + (validated ? "enabled" : " disabled")));
        this.portletApplicationRegistry.setSchemaValidated(validated);
        ContainerPortletDispatcher portletContainerDispatcher = new ContainerPortletDispatcher();
        ExoContainer topContainer = ExoContainerContext.getTopContainer();
        FederatingPortletInvoker federatingPortletInvoker = (FederatingPortletInvoker)topContainer.getComponentInstanceOfType(FederatingPortletInvoker.class);
        if (federatingPortletInvoker == null) {
            federatingPortletInvoker = new FederatingPortletInvokerService();
            topContainer.registerComponentInstance(FederatingPortletInvoker.class, (Object)federatingPortletInvoker);
        }
        EventPayloadInterceptor eventPayloadInterceptor = new EventPayloadInterceptor();
        eventPayloadInterceptor.setNext((PortletInvoker)portletContainerDispatcher);
        RequestAttributeConversationInterceptor requestAttributeConversationInterceptor = new RequestAttributeConversationInterceptor();
        requestAttributeConversationInterceptor.setNext((PortletInvoker)eventPayloadInterceptor);
        CCPPInterceptor ccppInterceptor = new CCPPInterceptor();
        ccppInterceptor.setNext((PortletInvoker)requestAttributeConversationInterceptor);
        BridgeInterceptor bridgepInterceptor = new BridgeInterceptor();
        bridgepInterceptor.setNext((PortletInvoker)ccppInterceptor);
        ProducerCacheInterceptor producerCacheInterceptor = new ProducerCacheInterceptor();
        producerCacheInterceptor.setNext((PortletInvoker)bridgepInterceptor);
        SessionInvalidatorInterceptor sessionInvalidatorInterceptor = new SessionInvalidatorInterceptor();
        sessionInvalidatorInterceptor.setNext((PortletInvoker)producerCacheInterceptor);
        ContextDispatcherInterceptor contextDispatcherInterceptor = new ContextDispatcherInterceptor();
        contextDispatcherInterceptor.setNext((PortletInvoker)sessionInvalidatorInterceptor);
        SecureTransportInterceptor secureTransportInterceptor = new SecureTransportInterceptor();
        secureTransportInterceptor.setNext((PortletInvoker)contextDispatcherInterceptor);
        ValveInterceptor valveInterceptor = new ValveInterceptor();
        valveInterceptor.setPortletApplicationRegistry((PortletApplicationRegistry)this.portletApplicationRegistry);
        valveInterceptor.setNext((PortletInvoker)secureTransportInterceptor);
        this.portletApplicationRegistry.setServletContainerFactory(DefaultServletContainerFactory.getInstance());
        contextDispatcherInterceptor.setServletContainerFactory(DefaultServletContainerFactory.getInstance());
        containerPortletInvoker.setNext((PortletInvoker)valveInterceptor);
        this.container.registerComponentInstance(ContainerPortletInvoker.class, (Object)containerPortletInvoker);
        PortletStatePersistenceManagerService producerPersistenceManager = new PortletStatePersistenceManagerService();
        StateManagementPolicyService producerStateManagementPolicy = new StateManagementPolicyService();
        producerStateManagementPolicy.setPersistLocally(false);
        ExoStateConverter producerStateConverter = new ExoStateConverter();
        ProducerPortletInvoker producerPortletInvoker = new ProducerPortletInvoker();
        producerPortletInvoker.setNext((PortletInvoker)containerPortletInvoker);
        producerPortletInvoker.setPersistenceManager((PortletStatePersistenceManager)producerPersistenceManager);
        producerPortletInvoker.setStateManagementPolicy((StateManagementPolicy)producerStateManagementPolicy);
        producerPortletInvoker.setStateConverter((StateConverter)producerStateConverter);
        if (!federatingPortletInvoker.isResolved("local")) {
            federatingPortletInvoker.registerInvoker("local", (PortletInvoker)producerPortletInvoker);
        }
        PortletCustomizationInterceptor portletCustomizationInterceptor = new PortletCustomizationInterceptor();
        portletCustomizationInterceptor.setNext((PortletInvoker)federatingPortletInvoker);
        ConsumerCacheInterceptor consumerCacheInterceptor = new ConsumerCacheInterceptor();
        consumerCacheInterceptor.setNext((PortletInvoker)portletCustomizationInterceptor);
        PortletInvokerInterceptor consumerPortletInvoker = new PortletInvokerInterceptor();
        consumerPortletInvoker.setNext((PortletInvoker)consumerCacheInterceptor);
        this.container.registerComponentInstance(PortletInvoker.class, (Object)consumerPortletInvoker);
        this.container.registerComponentInstance(FederatingPortletInvoker.class, (Object)federatingPortletInvoker);
        this.portletApplicationRegistry.start();
    }

    public void stop() {
        if (this.portletApplicationRegistry != null) {
            this.portletApplicationRegistry.stop();
        }
    }

    public PortletApplicationDeployer getPortletApplicationRegistry() {
        return this.portletApplicationRegistry;
    }
}

