/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.resources.jcr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.commons.utils.MapResourceBundle;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExpireKeyStartWithSelector;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.registry.RegistryEntry;
import org.exoplatform.services.jcr.ext.registry.RegistryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.resources.ExoResourceBundle;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.Query;
import org.exoplatform.services.resources.ResourceBundleData;
import org.exoplatform.services.resources.impl.BaseResourceBundleService;
import org.exoplatform.services.resources.jcr.DataMapper;
import org.picocontainer.Startable;

public class ResourceBundleServiceImpl
extends BaseResourceBundleService
implements Startable {
    RegistryService regService_;
    DataMapper mapper_ = new DataMapper();
    private static final String SERVICE_NAME = "ResourceBundles";
    private InitParams params_;

    public ResourceBundleServiceImpl(InitParams params, CacheService cService, RegistryService service, LocaleConfigService localeService) throws Exception {
        this.log_ = ExoLogger.getLogger((String)"org.exoplatform.services.resources");
        this.localeService_ = localeService;
        this.cache_ = cService.getCacheInstance(ResourceBundleData.class.getName());
        this.regService_ = service;
        this.params_ = params;
    }

    public void start() {
        try {
            this.initParams(this.params_);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceBundleData getResourceBundleData(String id) throws Exception {
        String resourceDataPath = this.getServiceRegistryPath() + "/" + id;
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            ResourceBundleData resourceData;
            RegistryEntry entry;
            try {
                entry = this.regService_.getEntry(sessionProvider, resourceDataPath);
            }
            catch (PathNotFoundException ie) {
                ResourceBundleData resourceBundleData = null;
                sessionProvider.close();
                return resourceBundleData;
            }
            ResourceBundleData resourceBundleData = resourceData = this.mapper_.toResourceBundleData(entry.getDocument());
            return resourceBundleData;
        }
        finally {
            sessionProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceBundleData removeResourceBundleData(String id) throws Exception {
        ResourceBundleData resource = this.getResourceBundleData(id);
        if (resource == null) {
            return null;
        }
        String resourceDataPath = this.getServiceRegistryPath() + "/" + id;
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            this.regService_.removeEntry(sessionProvider, resourceDataPath);
            this.cache_.remove((Serializable)((Object)id));
            ResourceBundleData resourceBundleData = resource;
            return resourceBundleData;
        }
        finally {
            sessionProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveResourceBundle(ResourceBundleData resourceData) throws Exception {
        String id = resourceData.getId();
        String servicePath = this.getServiceRegistryPath();
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            RegistryEntry entry;
            try {
                entry = this.regService_.getEntry(sessionProvider, servicePath + "/" + id);
            }
            catch (PathNotFoundException ie) {
                entry = new RegistryEntry(id);
                this.regService_.createEntry(sessionProvider, servicePath, entry);
            }
            this.mapper_.map(entry.getDocument(), resourceData);
            this.regService_.recreateEntry(sessionProvider, servicePath, entry);
            this.cache_.select((CachedObjectSelector)new ExpireKeyStartWithSelector(id));
        }
        finally {
            sessionProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageList findResourceDescriptions(Query q) throws Exception {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            Node regNode = this.regService_.getRegistry(sessionProvider).getNode();
            StringBuilder builder = new StringBuilder("select * from exo:registryEntry");
            this.generateScript(builder, "jcr:path", regNode.getPath() + "/" + this.getServiceRegistryPath() + "/%");
            this.generateScript(builder, "exo:type", "locale");
            this.generateScript(builder, "exo:resourceName", q.getName());
            this.generateScript(builder, "exo:resourceLanguage", q.getLanguage());
            builder.append("order by ").append("exo:resourceName").append(",").append("exo:resourceLanguage");
            Session session = regNode.getSession();
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            javax.jcr.query.Query query = queryManager.createQuery(builder.toString(), "sql");
            QueryResult result = query.execute();
            NodeIterator itr = result.getNodes();
            ArrayList<ResourceBundleData> resources = new ArrayList<ResourceBundleData>();
            while (itr.hasNext()) {
                String entryPath = itr.nextNode().getPath().substring(regNode.getPath().length() + 1);
                RegistryEntry entry = this.regService_.getEntry(sessionProvider, entryPath);
                ResourceBundleData data = this.mapper_.toResourceBundleData(entry.getDocument());
                resources.add(data);
            }
            ObjectPageList objectPageList = new ObjectPageList(resources, 20);
            return objectPageList;
        }
        finally {
            sessionProvider.close();
        }
    }

    protected ResourceBundle getResourceBundleFromDb(String id, ResourceBundle parent, Locale locale) throws Exception {
        ResourceBundleData data = this.getResourceBundleData(id);
        if (data == null) {
            return null;
        }
        ExoResourceBundle res = new ExoResourceBundle(data.getData(), parent);
        MapResourceBundle mres = new MapResourceBundle((ResourceBundle)res, locale);
        return mres;
    }

    private void generateScript(StringBuilder sql, String name, String value) {
        if (value == null || value.length() < 1) {
            return;
        }
        if (sql.indexOf(" where") < 0) {
            sql.append(" where ");
        } else {
            sql.append(" and ");
        }
        value = value.replace('*', '%');
        value = value.replaceAll("'", "&#39;");
        sql.append(name).append(" like '").append(value).append("'");
    }

    private String getServiceRegistryPath() {
        return "exo:services/ResourceBundles";
    }
}

