/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.groovyscript.text;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import groovy.lang.Writable;
import groovy.text.Template;
import groovy.text.TemplateEngine;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.exoplatform.commons.utils.Printer;

public class SimpleTemplateEngine
extends TemplateEngine {
    private final boolean verbose;

    public SimpleTemplateEngine() {
        this(false);
    }

    public SimpleTemplateEngine(boolean verbose) {
        this.verbose = verbose;
    }

    public Template createTemplate(Reader reader) throws CompilationFailedException, IOException {
        SimpleTemplate template = new SimpleTemplate();
        GroovyShell shell = new GroovyShell(Thread.currentThread().getContextClassLoader());
        String script = template.parse(reader);
        if (this.verbose) {
            System.out.println("\n-- script source --");
            System.out.print(script);
            System.out.println("\n-- script end --\n");
        }
        CompilerConfiguration config = new CompilerConfiguration();
        config.setScriptBaseClass(ExoScript.class.getName());
        byte[] bytes = script.getBytes(config.getSourceEncoding());
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        GroovyCodeSource gcs = new GroovyCodeSource((InputStream)in, "fic", "/groovy/shell");
        GroovyClassLoader loader = new GroovyClassLoader(Thread.currentThread().getContextClassLoader(), config);
        loader.parseClass(gcs, false);
        template.scriptClass = loader.parseClass(script);
        return template;
    }

    private static class SimpleTemplate
    implements Template {
        protected Class scriptClass;

        private SimpleTemplate() {
        }

        public Writable make() {
            return this.make(null);
        }

        public Writable make(final Map map) {
            return new Writable(){

                public Writer writeTo(Writer writer) {
                    Binding context = map == null ? new Binding() : new Binding(map);
                    ExoScript script = (ExoScript)InvokerHelper.createScript((Class)SimpleTemplate.this.scriptClass, (Binding)context);
                    script.printer = (Printer)writer;
                    script.setProperty("out", script.printer);
                    script.run();
                    script.flush();
                    return writer;
                }

                public String toString() {
                    try {
                        StringWriter sw = new StringWriter();
                        this.writeTo(sw);
                        return sw.toString();
                    }
                    catch (Exception e) {
                        return e.toString();
                    }
                }
            };
        }

        protected String parse(Reader reader) throws IOException {
            int c;
            if (!reader.markSupported()) {
                reader = new BufferedReader(reader);
            }
            StringWriter sw = new StringWriter();
            this.startScript(sw);
            while ((c = reader.read()) != -1) {
                if (c == 60) {
                    reader.mark(1);
                    c = reader.read();
                    if (c != 37) {
                        sw.write(60);
                        reader.reset();
                        continue;
                    }
                    reader.mark(1);
                    c = reader.read();
                    if (c == 61) {
                        this.groovyExpression(reader, sw);
                        continue;
                    }
                    reader.reset();
                    this.groovySection(reader, sw);
                    continue;
                }
                if (c == 34) {
                    sw.write(92);
                }
                if (c == 10 || c == 13) {
                    if (c == 13) {
                        reader.mark(1);
                        c = reader.read();
                        if (c != 10) {
                            reader.reset();
                        }
                    }
                    sw.write("\\n\");\nout.print(\"");
                    continue;
                }
                sw.write(c);
            }
            this.endScript(sw);
            String result = sw.toString();
            return result;
        }

        private void startScript(StringWriter sw) {
            sw.write("/* Generated by SimpleTemplateEngine */\n");
            sw.write("out.print(\"");
        }

        private void endScript(StringWriter sw) {
            sw.write("\");\n");
        }

        private void groovyExpression(Reader reader, StringWriter sw) throws IOException {
            int c;
            sw.write("\");out.print(\"${");
            while ((c = reader.read()) != -1) {
                if (c == 37) {
                    c = reader.read();
                    if (c == 62) break;
                    sw.write(37);
                }
                if (c == 10 || c == 13) continue;
                sw.write(c);
            }
            sw.write("}\");\nout.print(\"");
        }

        private void groovySection(Reader reader, StringWriter sw) throws IOException {
            int c;
            sw.write("\");");
            while ((c = reader.read()) != -1) {
                if (c == 37) {
                    c = reader.read();
                    if (c == 62) break;
                    sw.write(37);
                }
                sw.write(c);
            }
            sw.write(";\nout.print(\"");
        }
    }

    public static abstract class ExoScript
    extends Script {
        private Printer printer;

        protected ExoScript() {
        }

        protected ExoScript(Binding binding) {
            super(binding);
        }

        public void println(Object o) {
            this.printer.println(o);
        }

        public void println() {
            this.printer.println();
        }

        public void print(Object o) {
            this.printer.print(o);
        }

        public void flush() {
            try {
                this.printer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

