/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.groovyscript.text;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.groovyscript.text.TemplateService;
import org.exoplatform.groovyscript.text.TemplateStatistic;
import org.exoplatform.management.ManagementAware;
import org.exoplatform.management.ManagementContext;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.resolver.ResourceResolver;

@Managed
@NameTemplate(value={@Property(key="service", value="TemplateStatistic")})
@ManagedDescription(value="Template manager")
public class TemplateManaged
implements ManagementAware {
    private ManagementContext context;
    private Map<String, TemplateStatistic> apps = new ConcurrentHashMap<String, TemplateStatistic>();
    private final String ASC = "ASC";
    private final String DESC = "DESC";
    private TemplateService service;

    public void setContext(ManagementContext context) {
        this.context = context;
    }

    public TemplateManaged(TemplateService service) {
        this.service = service;
        service.managed = this;
    }

    public TemplateStatistic getTemplateStatistic(String name) {
        TemplateStatistic app = this.apps.get(name);
        if (app == null) {
            app = new TemplateStatistic(name);
            this.apps.put(name, app);
        }
        return app;
    }

    @Managed
    @ManagedDescription(value="returns a list of templateId sorted alphabetically")
    public String[] list() {
        LinkedList<Map.Entry<String, TemplateStatistic>> list = new LinkedList<Map.Entry<String, TemplateStatistic>>(this.apps.entrySet());
        String[] app = new String[list.size()];
        int index = 0;
        for (Map.Entry entry : list) {
            app[index] = (String)entry.getKey();
            ++index;
        }
        return app;
    }

    @Managed
    @ManagedDescription(value="Clear the template cache")
    public void reload() {
        try {
            this.service.getTemplatesCache().clearCache();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Managed
    @ManagedDescription(value="Clear the template cache")
    public void reload(String name) {
        try {
            TemplateStatistic app = this.apps.get(name);
            ResourceResolver resolver = app.getResolver();
            this.service.getTemplatesCache().remove((Serializable)((Object)resolver.createResourceId(name)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Managed
    @ManagedDescription(value="return max time of an specify template")
    public double getMaxTime(String name) {
        TemplateStatistic app = this.apps.get(name);
        return app.getMaxTime();
    }

    @Managed
    @ManagedDescription(value="return min time of an specify template")
    public double getMinTime(String name) {
        TemplateStatistic app = this.apps.get(name);
        return app.getMinTime();
    }

    @Managed
    @ManagedDescription(value="return count of an specify template")
    public long executionCount(String name) {
        TemplateStatistic app = this.apps.get(name);
        return app.executionCount();
    }

    @Managed
    @ManagedDescription(value="return average time of an specify template")
    public double getAverageTime(String name) {
        TemplateStatistic app = this.apps.get(name);
        return app.getAverageTime();
    }

    @Managed
    @ManagedDescription(value="returns 10 slowest template")
    public String[] slowestTemplate() {
        HashMap<String, Double> application = new HashMap<String, Double>();
        LinkedList<Map.Entry<String, TemplateStatistic>> list = new LinkedList<Map.Entry<String, TemplateStatistic>>(this.apps.entrySet());
        for (Map.Entry entry : list) {
            String url = (String)entry.getKey();
            application.put(url, this.getAverageTime(url));
        }
        return this.sort(application, "DESC");
    }

    @Managed
    @ManagedDescription(value="returns 10 most executed template")
    public String[] mostExecutedTemplate() {
        HashMap<String, Long> application = new HashMap<String, Long>();
        LinkedList<Map.Entry<String, TemplateStatistic>> list = new LinkedList<Map.Entry<String, TemplateStatistic>>(this.apps.entrySet());
        for (Map.Entry entry : list) {
            String url = (String)entry.getKey();
            application.put(url, this.executionCount(url));
        }
        return this.sort(application, "DESC");
    }

    @Managed
    @ManagedDescription(value="returns 10 fastest template")
    public String[] fastestApplications() {
        HashMap<String, Double> application = new HashMap<String, Double>();
        LinkedList<Map.Entry<String, TemplateStatistic>> list = new LinkedList<Map.Entry<String, TemplateStatistic>>(this.apps.entrySet());
        for (Map.Entry entry : list) {
            String url = (String)entry.getKey();
            application.put(url, this.getAverageTime(url));
        }
        return this.sort(application, "ASC");
    }

    private String[] sort(Map source, String order) {
        String[] app = new String[10];
        LinkedList list = new LinkedList(source.entrySet());
        if (order.equals("ASC")) {
            Collections.sort(list, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    double value2;
                    double value1 = Double.parseDouble(((Map.Entry)o1).getValue().toString());
                    if (value1 > (value2 = Double.parseDouble(((Map.Entry)o2).getValue().toString()))) {
                        return 1;
                    }
                    if (value1 < value2) {
                        return -1;
                    }
                    return 0;
                }
            });
        } else if (order.equals("DESC")) {
            Collections.sort(list, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    double value1 = Double.parseDouble(((Map.Entry)o1).getValue().toString());
                    double value2 = Double.parseDouble(((Map.Entry)o2).getValue().toString());
                    if (value2 > value1) {
                        return 1;
                    }
                    if (value2 < value1) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
        int index = 0;
        for (Map.Entry entry : list) {
            app[index] = (String)entry.getKey();
            if (++index < app.length) continue;
            break;
        }
        return app;
    }
}

