/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.groovyscript.text;

import org.exoplatform.management.ManagementAware;
import org.exoplatform.management.ManagementContext;
import org.exoplatform.resolver.ResourceResolver;

public class TemplateStatistic
implements ManagementAware {
    private ManagementContext context;
    private final long[] times = new long[1000];
    private String name;
    private int counter = 0;
    private long maxTime = 0L;
    private long minTime = 0L;
    private int length = 0;
    private long countRequest = 0L;
    private ResourceResolver resolver;

    public TemplateStatistic(String name) {
        this.name = name;
    }

    public void setTime(long time) {
        this.times[this.counter] = time;
        if (time > this.maxTime) {
            this.maxTime = time;
        }
        if (this.minTime == 0L) {
            this.minTime = time;
        }
        if (time < this.minTime) {
            this.minTime = time;
        }
        ++this.counter;
        ++this.length;
        ++this.countRequest;
        if (this.counter == this.times.length) {
            this.counter = 0;
        }
        if (this.length >= this.times.length) {
            this.length = this.times.length;
        }
    }

    public double getMaxTime() {
        return (double)this.maxTime / 60.0;
    }

    public double getMinTime() {
        return (double)this.minTime / 60.0;
    }

    public double getAverageTime() {
        long sumTime = 0L;
        for (int index = 0; index < this.length; ++index) {
            sumTime += this.times[index];
        }
        return this.length == 0 ? 0.0 : (double)sumTime / (double)this.length / 60.0;
    }

    public long executionCount() {
        return this.countRequest;
    }

    public void setContext(ManagementContext context) {
        this.context = context;
    }

    public void setResolver(ResourceResolver resolver) {
        this.resolver = resolver;
    }

    public ResourceResolver getResolver() {
        return this.resolver;
    }
}

