/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.util.concurrent.atomic.AtomicLong;

public class AtomicPositiveLong
extends AtomicLong {
    public AtomicPositiveLong(long initialValue) throws IllegalArgumentException {
        super(initialValue);
        if (initialValue == -1L) {
            throw new IllegalArgumentException();
        }
    }

    public AtomicPositiveLong() {
        super(-1L);
    }

    public void setIfGreater(long newValue) throws IllegalArgumentException {
        long oldValue;
        if (newValue < 0L) {
            throw new IllegalArgumentException();
        }
        while (newValue > (oldValue = this.get()) || oldValue == -1L) {
            this.compareAndSet(oldValue, newValue);
        }
    }

    public void setIfLower(long newValue) throws IllegalArgumentException {
        long oldValue;
        if (newValue < 0L) {
            throw new IllegalArgumentException();
        }
        while (newValue < (oldValue = this.get()) || oldValue == -1L) {
            this.compareAndSet(oldValue, newValue);
        }
    }
}

