/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.resolver;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletContext;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletResourceResolver
extends ResourceResolver {
    protected static Log log = ExoLogger.getLogger((String)"portlet:PortletResourceResolver");
    private PortletContext pcontext_;
    private String scheme_;

    public PortletResourceResolver(PortletContext context, String scheme) {
        this.pcontext_ = context;
        this.scheme_ = scheme;
    }

    @Override
    public URL getResource(String url) throws Exception {
        String path = this.removeScheme(url);
        return this.pcontext_.getResource(path);
    }

    @Override
    public InputStream getInputStream(String url) throws Exception {
        String path = this.removeScheme(url);
        return this.pcontext_.getResourceAsStream(path);
    }

    @Override
    public List<URL> getResources(String url) throws Exception {
        ArrayList<URL> urlList = new ArrayList<URL>();
        urlList.add(this.getResource(url));
        return urlList;
    }

    @Override
    public List<InputStream> getInputStreams(String url) throws Exception {
        ArrayList<InputStream> inputStreams = new ArrayList<InputStream>();
        inputStreams.add(this.getInputStream(url));
        return inputStreams;
    }

    @Override
    public String getRealPath(String url) {
        String path = this.removeScheme(url);
        return this.pcontext_.getRealPath(path);
    }

    @Override
    public boolean isModified(String url, long lastAccess) {
        File file = new File(this.getRealPath(url));
        if (log.isDebugEnabled()) {
            log.debug((Object)(url + ": " + file.lastModified() + " " + lastAccess));
        }
        return file.exists() && file.lastModified() > lastAccess;
    }

    @Override
    public String getWebAccessPath(String url) {
        return "/" + this.pcontext_.getPortletContextName() + this.removeScheme(url);
    }

    @Override
    public String getResourceScheme() {
        return this.scheme_;
    }
}

