/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import java.util.HashMap;
import java.util.Map;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.router.BitStack;
import org.exoplatform.web.controller.router.Regex;

public class RenderContext {
    private final Map<QualifiedName, Parameter> parameters;
    private BitStack stack = new BitStack();
    Regex.Matcher[] matchers = null;

    public RenderContext(Map<QualifiedName, String> map) {
        this();
        this.reset(map);
    }

    public RenderContext() {
        this.parameters = new HashMap<QualifiedName, Parameter>();
        this.stack = new BitStack();
    }

    Regex.Matcher matcher(Regex regex) {
        Regex.Matcher matcher = this.matchers[regex.index];
        if (matcher == null) {
            matcher = this.matchers[regex.index] = regex.matcher();
        }
        return matcher;
    }

    public void reset(Map<QualifiedName, String> map) {
        this.parameters.clear();
        this.stack.reset();
        for (Map.Entry<QualifiedName, String> entry : map.entrySet()) {
            this.addParameter(entry.getKey(), entry.getValue());
        }
    }

    void addParameter(QualifiedName name, String value) {
        if (this.stack.getDepth() > 0) {
            throw new IllegalStateException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        Parameter parameter = this.parameters.get(name);
        if (parameter == null) {
            parameter = new Parameter(value, this.parameters.size());
            this.parameters.put(name, parameter);
        } else {
            parameter.value = value;
        }
    }

    Parameter getParameter(QualifiedName name) {
        Parameter entry = this.parameters.get(name);
        if (this.stack.getDepth() == 0 || entry != null && !this.stack.get(entry.index)) {
            return entry;
        }
        return null;
    }

    String getParameterValue(QualifiedName name) {
        Parameter entry = this.getParameter(name);
        return entry != null ? entry.value : null;
    }

    boolean isEmpty() {
        return this.stack.getDepth() == 0 || this.stack.isEmpty();
    }

    void enter() {
        if (this.stack.getDepth() == 0) {
            this.stack.init(this.parameters.size());
        }
        this.stack.push();
    }

    void leave() {
        this.stack.pop();
    }

    class Parameter {
        private String value;
        private final int index;

        private Parameter(String value, int index) {
            this.value = value;
            this.index = index;
        }

        public String getValue() {
            return this.value;
        }

        public void remove() {
            if (RenderContext.this.stack.getDepth() < 1) {
                throw new IllegalStateException();
            }
            RenderContext.this.stack.set(this.index);
        }
    }
}

