/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.application;

import java.io.Serializable;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.exoplatform.web.application.AbstractApplicationMessage;
import org.exoplatform.web.application.ApplicationMessage;

public class CompoundApplicationMessage
extends AbstractApplicationMessage
implements Serializable {
    private Set<AbstractApplicationMessage> messages = new HashSet<AbstractApplicationMessage>(5);

    public CompoundApplicationMessage() {
        this(null);
    }

    public CompoundApplicationMessage(AbstractApplicationMessage initialMessage) {
        if (initialMessage != null) {
            this.messages.add(initialMessage);
        }
        this.setType(1);
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        super.setResourceBundle(resourceBundle);
        for (AbstractApplicationMessage message : this.messages) {
            message.setResourceBundle(resourceBundle);
        }
    }

    public String getMessage() {
        StringBuilder sb = new StringBuilder(255);
        for (AbstractApplicationMessage message : this.messages) {
            sb.append(message.getMessage()).append('\n');
        }
        return sb.toString();
    }

    public void addMessage(String messageKey, Object[] args) {
        ApplicationMessage message = new ApplicationMessage(messageKey, args, 1);
        message.setArgsLocalized(false);
        this.messages.add(message);
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }
}

