/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.imageio.ImageIO;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.commons.utils.BinaryOutput;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.web.AbstractFilter;
import org.exoplatform.portal.application.Image;
import org.exoplatform.portal.application.ImageType;
import org.exoplatform.portal.resource.ResourceRenderer;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ResourceRequestFilter
extends AbstractFilter {
    protected static Log log = ExoLogger.getLogger(ResourceRequestFilter.class);
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private FilterConfig cfg;
    private ImageType[] imageTypes = ImageType.values();
    private ConcurrentMap<String, FutureTask<Image>> mirroredImageCache = new ConcurrentHashMap<String, FutureTask<Image>>();
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String LAST_MODIFIED = "Last-Modified";

    public void afterInit(FilterConfig filterConfig) {
        this.cfg = filterConfig;
        log.info((Object)("Cache eXo Resource at client: " + !PropertyManager.isDevelopping()));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block19: {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            final String uri = URLDecoder.decode(httpRequest.getRequestURI(), "UTF-8");
            final HttpServletResponse httpResponse = (HttpServletResponse)response;
            ExoContainer portalContainer = this.getContainer();
            final SkinService skinService = (SkinService)portalContainer.getComponentInstanceOfType(SkinService.class);
            long ifModifiedSince = httpRequest.getDateHeader(IF_MODIFIED_SINCE);
            if (uri.endsWith(".css")) {
                long cssLastModified = skinService.getLastModified(uri);
                if (this.isNotModified(ifModifiedSince, cssLastModified)) {
                    httpResponse.setStatus(304);
                    return;
                }
                response.setContentType("text/css; charset=UTF-8");
                ServletOutputStream out = response.getOutputStream();
                final BinaryOutput output = new BinaryOutput((OutputStream)out){
                    final /* synthetic */ OutputStream val$out;
                    {
                        this.val$out = outputStream;
                    }

                    public Charset getCharset() {
                        return UTF_8;
                    }

                    public void write(byte b) throws IOException {
                        this.val$out.write(b);
                    }

                    public void write(byte[] bytes) throws IOException {
                        this.val$out.write(bytes);
                    }

                    public void write(byte[] bytes, int off, int len) throws IOException {
                        this.val$out.write(bytes, off, len);
                    }
                };
                ResourceRenderer renderer = new ResourceRenderer(){

                    @Override
                    public BinaryOutput getOutput() throws IOException {
                        return output;
                    }

                    @Override
                    public void setExpiration(long seconds) {
                        if (seconds > 0L) {
                            httpResponse.addHeader("Cache-Control", "max-age=" + seconds + ",s-maxage=" + seconds);
                        } else {
                            httpResponse.setHeader("Cache-Control", "no-cache");
                        }
                        long lastModified = skinService.getLastModified(uri);
                        ResourceRequestFilter.this.processIfModified(lastModified, httpResponse);
                    }
                };
                try {
                    skinService.renderCSS(renderer, uri);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Use a merged CSS: " + uri));
                    }
                    break block19;
                }
                catch (Exception e) {
                    if (!(e instanceof SocketException)) {
                        log.error((Object)("Could not render css " + uri), (Throwable)e);
                        httpResponse.setStatus(404);
                    }
                    break block19;
                }
            }
            int len = uri.length();
            if (len >= 7 && uri.charAt(len - 7) == '-' && uri.charAt(len - 6) == 'r' && uri.charAt(len - 5) == 't') {
                for (final ImageType imageType : this.imageTypes) {
                    FutureTask<Image> tmp;
                    if (!imageType.matches(uri)) continue;
                    final String resource = uri.substring(httpRequest.getContextPath().length(), len - 7) + uri.substring(len - 4);
                    FutureTask<Image> futureImg = (FutureTask<Image>)this.mirroredImageCache.get(resource);
                    if (futureImg == null && (futureImg = this.mirroredImageCache.putIfAbsent(resource, tmp = new FutureTask<Image>(new Callable<Image>(){

                        @Override
                        public Image call() throws Exception {
                            InputStream in = ResourceRequestFilter.this.cfg.getServletContext().getResourceAsStream(resource);
                            if (in == null) {
                                return null;
                            }
                            BufferedImage img = ImageIO.read(in);
                            log.debug((Object)("Read image " + uri + " (" + img.getWidth() + "," + img.getHeight() + ")"));
                            AffineTransform tx = AffineTransform.getScaleInstance(-1.0, 1.0);
                            tx.translate(-img.getWidth(null), 0.0);
                            AffineTransformOp op = new AffineTransformOp(tx, 1);
                            img = op.filter(img, null);
                            log.debug((Object)("Mirrored image " + uri + " (" + img.getWidth() + "," + img.getHeight() + ")"));
                            ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
                            ImageIO.write((RenderedImage)img, imageType.getFormat(), baos);
                            baos.close();
                            return new Image(imageType, baos.toByteArray());
                        }
                    }))) == null) {
                        futureImg = tmp;
                        futureImg.run();
                    }
                    try {
                        Image img = (Image)futureImg.get();
                        if (img != null) {
                            long imgLastModified = img.getLastModified();
                            if (this.isNotModified(ifModifiedSince, imgLastModified)) {
                                httpResponse.setStatus(304);
                                return;
                            }
                            httpResponse.setContentType(img.type.getMimeType());
                            httpResponse.setContentLength(img.bytes.length);
                            this.processIfModified(imgLastModified, httpResponse);
                            ServletOutputStream out = httpResponse.getOutputStream();
                            out.write(img.bytes);
                            out.close();
                        } else {
                            this.mirroredImageCache.remove(resource);
                            httpResponse.setStatus(404);
                        }
                        return;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                        this.mirroredImageCache.remove(resource);
                    }
                }
            }
            if (!PropertyManager.isDevelopping()) {
                httpResponse.addHeader("Cache-Control", "max-age=2592000,s-maxage=2592000");
            } else {
                if (uri.endsWith(".jstmpl") || uri.endsWith(".js")) {
                    httpResponse.setHeader("Cache-Control", "no-cache");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" Load Resource: " + uri));
                }
            }
            chain.doFilter(request, response);
        }
    }

    public void processIfModified(long lastModified, HttpServletResponse httpResponse) {
        httpResponse.setDateHeader(LAST_MODIFIED, lastModified);
    }

    public boolean isNotModified(long ifModifedSince, long lastModified) {
        return !PropertyManager.isDevelopping() && ifModifedSince >= lastModified;
    }

    public void destroy() {
    }
}

