/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.application.javascript;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.exoplatform.web.application.javascript.Javascript;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.exoplatform.web.application.javascript.JavascriptTask;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JavascriptConfigParser {
    public static final String JAVA_SCRIPT_TAG = "javascript";
    public static final String JAVA_SCRIPT_PARAM = "param";
    public static final String JAVA_SCRIPT_MODULE = "js-module";
    public static final String JAVA_SCRIPT_PATH = "js-path";
    public static final String JAVA_SCRIPT_PRIORITY = "js-priority";
    public static final String JAVA_SCRIPT_PORTAL_NAME = "portal-name";
    private ServletContext context;

    private JavascriptConfigParser(ServletContext context) {
        this.context = context;
    }

    public static void processConfigResource(InputStream is, JavascriptConfigService service, ServletContext scontext) {
        JavascriptConfigParser parser = new JavascriptConfigParser(scontext);
        List<JavascriptTask> tasks = parser.fetchTasks(is);
        if (tasks != null) {
            for (JavascriptTask task : tasks) {
                task.execute(service, scontext);
            }
        }
    }

    private List<JavascriptTask> fetchTasks(InputStream is) {
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = docBuilder.parse(is);
            return this.fetchTasksFromXMLConfig(document);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private List<JavascriptTask> fetchTasksFromXMLConfig(Document document) {
        ArrayList<JavascriptTask> tasks = new ArrayList<JavascriptTask>();
        Element element = document.getDocumentElement();
        NodeList nodes = element.getElementsByTagName(JAVA_SCRIPT_TAG);
        int length = nodes.getLength();
        for (int i = 0; i < length; ++i) {
            JavascriptTask task = this.xmlToTask((Element)nodes.item(i));
            if (task == null) continue;
            tasks.add(task);
        }
        return tasks;
    }

    private JavascriptTask xmlToTask(Element element) {
        if (!JAVA_SCRIPT_TAG.equals(element.getTagName())) {
            return null;
        }
        try {
            JavascriptTask task = new JavascriptTask();
            NodeList nodes = element.getElementsByTagName(JAVA_SCRIPT_PARAM);
            int length = nodes.getLength();
            for (int i = 0; i < length; ++i) {
                int priority;
                Element param_ele = (Element)nodes.item(i);
                String js_module = param_ele.getElementsByTagName(JAVA_SCRIPT_MODULE).item(0).getFirstChild().getNodeValue();
                String js_path = param_ele.getElementsByTagName(JAVA_SCRIPT_PATH).item(0).getFirstChild().getNodeValue();
                try {
                    priority = Integer.valueOf(param_ele.getElementsByTagName(JAVA_SCRIPT_PRIORITY).item(0).getFirstChild().getNodeValue());
                }
                catch (Exception e) {
                    priority = Integer.MAX_VALUE;
                }
                String portalName = null;
                try {
                    portalName = param_ele.getElementsByTagName(JAVA_SCRIPT_PORTAL_NAME).item(0).getFirstChild().getNodeValue();
                }
                catch (Exception e) {
                    // empty catch block
                }
                Javascript js = portalName == null ? new Javascript(js_module, js_path, this.context.getContextPath(), priority) : new Javascript.PortalJScript(js_module, js_path, this.context.getContextPath(), priority, portalName);
                task.addScript(js);
            }
            return task;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

