/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.application.javascript;

import org.gatein.portal.controller.resource.ResourceId;
import org.gatein.portal.controller.resource.script.Module;
import org.gatein.portal.controller.resource.script.ScriptResource;

public abstract class Javascript {
    protected final ResourceId resource;
    protected final String contextPath;
    protected final String module;
    protected final int priority;

    public static Javascript create(ResourceId resource, String module, String path, String contextPath, int priority) {
        if (path.startsWith("http://") || path.startsWith("https://")) {
            return new Remote(resource, module, contextPath, path, priority);
        }
        return new Local(resource, module, contextPath, path, null, priority);
    }

    public static Javascript create(Module module) {
        if (module instanceof Module.Remote) {
            Module.Remote remote = (Module.Remote)module;
            return new Remote(module.getResource().getId(), remote.getName(), remote.getContextPath(), remote.getURI(), remote.getPriority());
        }
        Module.Local local = (Module.Local)module;
        return new Local(local.getResource().getId(), local.getName(), local.getContextPath(), local.getPath(), local.getResourceBundle(), local.getPriority());
    }

    private Javascript(ResourceId resource, String module, String contextPath, int priority) {
        this.resource = resource;
        this.contextPath = contextPath;
        this.module = module;
        this.priority = priority < 0 ? Integer.MAX_VALUE : priority;
    }

    public ResourceId getResource() {
        return this.resource;
    }

    public String getModule() {
        return this.module;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public int getPriority() {
        return this.priority;
    }

    abstract Module addModuleTo(ScriptResource var1);

    public abstract boolean isExternalScript();

    public String toString() {
        return "Javascript[scope=" + this.resource + ", module=" + this.module + "]";
    }

    public static class Remote
    extends Javascript {
        protected final String uri;

        public Remote(ResourceId resource, String module, String contextPath, String uri, int priority) {
            super(resource, module, contextPath, priority);
            this.uri = uri;
        }

        @Override
        Module addModuleTo(ScriptResource resource) {
            return resource.addRemoteModule(this.contextPath, this.module, this.uri, this.priority);
        }

        @Override
        public boolean isExternalScript() {
            return true;
        }
    }

    public static class Local
    extends Javascript {
        protected final String path;
        protected final String resourceBundle;

        public Local(ResourceId resource, String module, String contextPath, String path, String resourceBundle, int priority) {
            super(resource, module, contextPath, priority);
            this.path = path;
            this.resourceBundle = resourceBundle;
        }

        @Override
        Module addModuleTo(ScriptResource resource) {
            return resource.addLocalModule(this.contextPath, this.module, this.path, this.resourceBundle, this.priority);
        }

        public String getResourceBundle() {
            return this.resourceBundle;
        }

        @Override
        public boolean isExternalScript() {
            return false;
        }
    }
}

