/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.application.javascript;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.exoplatform.commons.utils.I18N;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.javascript.DependencyDescriptor;
import org.exoplatform.web.application.javascript.Javascript;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.exoplatform.web.application.javascript.JavascriptTask;
import org.exoplatform.web.application.javascript.ScriptResourceDescriptor;
import org.gatein.common.xml.XMLTools;
import org.gatein.portal.controller.resource.ResourceId;
import org.gatein.portal.controller.resource.ResourceScope;
import org.gatein.portal.controller.resource.script.FetchMode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JavascriptConfigParser {
    public static final String JAVA_SCRIPT_TAG = "javascript";
    public static final String JAVA_SCRIPT_PARAM = "param";
    public static final String JAVA_SCRIPT_MODULE = "js-module";
    public static final String JAVA_SCRIPT_PATH = "js-path";
    public static final String JAVA_SCRIPT_PRIORITY = "js-priority";
    public static final String JAVA_SCRIPT_PORTAL_NAME = "portal-name";
    public static final String LEGACY_JAVA_SCRIPT = "merged";
    public static final String SCRIPT_TAG = "script";
    public static final String SCRIPTS_TAG = "scripts";
    public static final String PORTLET_TAG = "portlet";
    public static final String PORTAL_TAG = "portal";
    public static final String RESOURCE_TAG = "resource";
    public static final String SCOPE_TAG = "scope";
    public static final String NAME_TAG = "name";
    public static final String MODULE_TAG = "module";
    public static final String PATH_TAG = "path";
    public static final String DEPENDS_TAG = "depends";
    public static final String URL_TAG = "url";
    public static final String AS_TAG = "as";
    private final String contextPath;
    private static final Log log = ExoLogger.getExoLogger(JavascriptConfigParser.class);

    public JavascriptConfigParser(String contextPath) {
        this.contextPath = contextPath;
    }

    public static void processConfigResource(InputStream is, JavascriptConfigService service, ServletContext scontext) {
        JavascriptConfigParser parser = new JavascriptConfigParser(scontext.getContextPath());
        JavascriptTask task = new JavascriptTask();
        for (ScriptResourceDescriptor script : parser.parseConfig(is)) {
            task.addDescriptor(script);
        }
        task.execute(service, scontext);
    }

    public List<ScriptResourceDescriptor> parseConfig(InputStream is) {
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = docBuilder.parse(is);
            return this.parseScripts(document);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private List<ScriptResourceDescriptor> parseScripts(Document document) {
        ArrayList<ScriptResourceDescriptor> tasks = new ArrayList<ScriptResourceDescriptor>();
        Element element = document.getDocumentElement();
        for (String tagName : Arrays.asList(JAVA_SCRIPT_TAG, MODULE_TAG, SCRIPTS_TAG, PORTLET_TAG, PORTAL_TAG)) {
            for (Element childElt : XMLTools.getChildren((Element)element, (String)tagName)) {
                Collection<ScriptResourceDescriptor> task = this.parseScripts(childElt);
                if (task == null) continue;
                tasks.addAll(task);
            }
        }
        return tasks;
    }

    private Collection<ScriptResourceDescriptor> parseScripts(Element element) {
        LinkedHashMap<ResourceId, ScriptResourceDescriptor> scripts = new LinkedHashMap<ResourceId, ScriptResourceDescriptor>();
        if (JAVA_SCRIPT_TAG.equals(element.getTagName())) {
            try {
                NodeList nodes = element.getElementsByTagName(JAVA_SCRIPT_PARAM);
                int length = nodes.getLength();
                for (int i = 0; i < length; ++i) {
                    int priority;
                    Element param_ele = (Element)nodes.item(i);
                    String js_module = param_ele.getElementsByTagName(JAVA_SCRIPT_MODULE).item(0).getFirstChild().getNodeValue();
                    String js_path = param_ele.getElementsByTagName(JAVA_SCRIPT_PATH).item(0).getFirstChild().getNodeValue();
                    log.warn("<javascript> tag define for javascript: {} has ben deprecated, please use <scripts> or <module> instead", new Object[]{js_path});
                    try {
                        priority = Integer.valueOf(param_ele.getElementsByTagName(JAVA_SCRIPT_PRIORITY).item(0).getFirstChild().getNodeValue());
                    }
                    catch (Exception e) {
                        priority = Integer.MAX_VALUE;
                    }
                    String portalName = null;
                    try {
                        portalName = param_ele.getElementsByTagName(JAVA_SCRIPT_PORTAL_NAME).item(0).getFirstChild().getNodeValue();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    Javascript js = portalName == null ? Javascript.create(new ResourceId(ResourceScope.SHARED, LEGACY_JAVA_SCRIPT), js_module, js_path, this.contextPath, priority) : Javascript.create(new ResourceId(ResourceScope.PORTAL, portalName), js_module, js_path, this.contextPath, priority);
                    ScriptResourceDescriptor desc = (ScriptResourceDescriptor)scripts.get(js.getResource());
                    if (desc == null) {
                        desc = new ScriptResourceDescriptor(js.getResource(), FetchMode.IMMEDIATE);
                        scripts.put(js.getResource(), desc);
                    }
                    desc.modules.add(js);
                }
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else if (PORTAL_TAG.equals(element.getTagName()) || PORTLET_TAG.equals(element.getTagName())) {
            FetchMode fetchMode;
            ResourceScope resourceScope;
            String resourceName = XMLTools.asString((Element)XMLTools.getUniqueChild((Element)element, (String)NAME_TAG, (boolean)true));
            if (PORTLET_TAG.equals(element.getTagName())) {
                resourceName = this.contextPath.substring(1) + "/" + resourceName;
                resourceScope = ResourceScope.PORTLET;
            } else {
                resourceScope = ResourceScope.PORTAL;
            }
            ResourceId id = new ResourceId(resourceScope, resourceName);
            Element resourceElt = XMLTools.getUniqueChild((Element)element, (String)MODULE_TAG, (boolean)false);
            if (resourceElt != null) {
                fetchMode = FetchMode.ON_LOAD;
            } else {
                resourceElt = XMLTools.getUniqueChild((Element)element, (String)SCRIPTS_TAG, (boolean)false);
                fetchMode = FetchMode.IMMEDIATE;
            }
            if (resourceElt != null) {
                ScriptResourceDescriptor desc = (ScriptResourceDescriptor)scripts.get(id);
                if (desc == null) {
                    desc = new ScriptResourceDescriptor(id, fetchMode, this.parseAlias(element));
                    scripts.put(id, desc);
                } else {
                    desc.fetchMode = fetchMode;
                }
                this.parseDesc(resourceElt, desc);
            }
        } else if (MODULE_TAG.equals(element.getTagName()) || SCRIPTS_TAG.equals(element.getTagName())) {
            String resourceName = XMLTools.asString((Element)XMLTools.getUniqueChild((Element)element, (String)NAME_TAG, (boolean)true));
            ResourceId id = new ResourceId(ResourceScope.SHARED, resourceName);
            FetchMode fetchMode = MODULE_TAG.equals(element.getTagName()) ? FetchMode.ON_LOAD : FetchMode.IMMEDIATE;
            ScriptResourceDescriptor desc = (ScriptResourceDescriptor)scripts.get(id);
            if (desc == null) {
                desc = new ScriptResourceDescriptor(id, fetchMode, this.parseAlias(element));
                scripts.put(id, desc);
            }
            this.parseDesc(element, desc);
        }
        return scripts.values();
    }

    private void parseDesc(Element element, ScriptResourceDescriptor desc) {
        Element urlElement = XMLTools.getUniqueChild((Element)element, (String)URL_TAG, (boolean)false);
        if (urlElement != null) {
            String remoteURL = XMLTools.asString((Element)urlElement);
            desc.modules.add(new Javascript.Remote(desc.id, remoteURL, this.contextPath, remoteURL, 0));
        } else {
            for (Element localeElt : XMLTools.getChildren((Element)element, (String)"supported-locale")) {
                String localeValue = XMLTools.asString((Element)localeElt);
                Locale locale = I18N.parseTagIdentifier((String)localeValue);
                desc.supportedLocales.add(locale);
            }
            for (Element scriptElt : XMLTools.getChildren((Element)element, (String)SCRIPT_TAG)) {
                String scriptName = XMLTools.asString((Element)XMLTools.getUniqueChild((Element)scriptElt, (String)NAME_TAG, (boolean)true));
                Element path = XMLTools.getUniqueChild((Element)scriptElt, (String)PATH_TAG, (boolean)true);
                String resourceBundle = null;
                Element bundleElt = XMLTools.getUniqueChild((Element)scriptElt, (String)"resource-bundle", (boolean)false);
                if (bundleElt != null) {
                    resourceBundle = XMLTools.asString((Element)bundleElt);
                }
                String scriptPath = XMLTools.asString((Element)path);
                Javascript.Local script = new Javascript.Local(desc.id, scriptName, this.contextPath, scriptPath, resourceBundle, 0);
                desc.modules.add(script);
            }
        }
        for (Element moduleElt : XMLTools.getChildren((Element)element, (String)DEPENDS_TAG)) {
            Element dependencyElt = XMLTools.getUniqueChild((Element)moduleElt, (String)MODULE_TAG, (boolean)false);
            if (dependencyElt == null) {
                dependencyElt = XMLTools.getUniqueChild((Element)moduleElt, (String)SCRIPTS_TAG, (boolean)false);
            }
            ResourceId resourceId = new ResourceId(ResourceScope.SHARED, XMLTools.asString((Element)dependencyElt));
            DependencyDescriptor dependency = new DependencyDescriptor(resourceId, this.parseAlias(moduleElt));
            desc.dependencies.add(dependency);
        }
    }

    private String parseAlias(Element element) {
        Element aliasElt = XMLTools.getUniqueChild((Element)element, (String)AS_TAG, (boolean)false);
        return aliasElt == null ? null : XMLTools.asString((Element)aliasElt, (boolean)true);
    }
}

