/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.application.javascript;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import org.exoplatform.commons.utils.CompositeReader;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.resource.AbstractResourceService;
import org.exoplatform.portal.resource.compressor.ResourceCompressor;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.application.javascript.JavascriptConfigDeployer;
import org.exoplatform.web.controller.router.URIWriter;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.portal.controller.resource.ResourceId;
import org.gatein.portal.controller.resource.ResourceScope;
import org.gatein.portal.controller.resource.script.FetchMode;
import org.gatein.portal.controller.resource.script.Module;
import org.gatein.portal.controller.resource.script.ScriptGraph;
import org.gatein.portal.controller.resource.script.ScriptResource;
import org.gatein.wci.WebApp;
import org.gatein.wci.WebAppListener;
import org.gatein.wci.impl.DefaultServletContainerFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.picocontainer.Startable;

public class JavascriptConfigService
extends AbstractResourceService
implements Startable {
    private final Logger log = LoggerFactory.getLogger(JavascriptConfigService.class);
    final ScriptGraph scripts = new ScriptGraph();
    private final WebAppListener deployer;
    public static final Comparator<Module> MODULE_COMPARATOR = new Comparator<Module>(){

        @Override
        public int compare(Module o1, Module o2) {
            return o1.getPriority() - o2.getPriority();
        }
    };

    public JavascriptConfigService(ExoContainerContext context, ResourceCompressor compressor) {
        super(compressor);
        this.deployer = new JavascriptConfigDeployer(context.getPortalContainerName(), this);
    }

    public Collection<String> getAvailableScripts() {
        ArrayList<String> list = new ArrayList<String>();
        for (ScriptResource shared : this.scripts.getResources(ResourceScope.SHARED)) {
            list.addAll(shared.getModulesNames());
        }
        return list;
    }

    public Collection<String> getAvailableScriptsPaths() {
        ArrayList<Module> sharedModules = new ArrayList<Module>();
        for (ScriptResource shared : this.scripts.getResources(ResourceScope.SHARED)) {
            sharedModules.addAll(shared.getModules());
        }
        Collections.sort(sharedModules, MODULE_COMPARATOR);
        ArrayList<String> paths = new ArrayList<String>();
        for (Module module : sharedModules) {
            paths.add(module.getURI());
        }
        return paths;
    }

    public Reader getScript(ResourceId id, String name, Locale locale) {
        ScriptResource script = this.getResource(id);
        if (script != null && !"merged".equals(name)) {
            return this.getJavascript(script, name, locale);
        }
        return this.getScript(id, locale);
    }

    public Reader getScript(ResourceId resourceId, Locale locale) {
        ScriptResource resource = this.getResource(resourceId);
        if (resource != null) {
            ArrayList<Module> modules = new ArrayList<Module>(resource.getModules());
            Collections.sort(modules, MODULE_COMPARATOR);
            ArrayList<Reader> readers = new ArrayList<Reader>(modules.size() * 2);
            StringBuilder buffer = new StringBuilder();
            boolean isModule = FetchMode.ON_LOAD.equals((Object)resource.getFetchMode());
            if (isModule) {
                buffer.append("define('").append(resourceId).append("', ");
                buffer.append(new JSONArray(resource.getDependencies()));
                buffer.append(", function(");
                for (ResourceId resId : resource.getDependencies()) {
                    String alias = resource.getDependencyAlias(resId);
                    ScriptResource dep = this.getResource(resId);
                    if (dep == null) continue;
                    buffer.append(alias == null ? dep.getAlias() : alias).append(",");
                }
                if (buffer.charAt(buffer.length() - 1) == ',') {
                    buffer.deleteCharAt(buffer.length() - 1);
                }
                buffer.append(") { var _module = {};(function() {");
            }
            for (Module js : modules) {
                Reader jScript = this.getJavascript(resource, js.getName(), locale);
                if (jScript == null) continue;
                buffer.append("// Begin ").append(js.getName()).append("\n");
                readers.add(new StringReader(buffer.toString()));
                buffer.setLength(0);
                readers.add(jScript);
                buffer.append("// End ").append(js.getName()).append("\n");
            }
            if (isModule) {
                buffer.append("})();");
                buffer.append("return _module;});");
            } else {
                buffer.append("if (typeof define === 'function' && define.amd) {");
                buffer.append("define('").append(resourceId).append("');}");
            }
            readers.add(new StringReader(buffer.toString()));
            return new CompositeReader(readers);
        }
        return null;
    }

    public Map<String, FetchMode> resolveURLs(ControllerContext controllerContext, Map<ResourceId, FetchMode> ids, boolean merge, boolean minified, Locale locale) throws IOException {
        ScriptResource resource;
        LinkedHashMap<String, FetchMode> urls = new LinkedHashMap<String, FetchMode>();
        StringBuilder buffer = new StringBuilder();
        URIWriter writer = new URIWriter((Appendable)buffer);
        if (ids.size() > 0 && (resource = this.getResource(ids.keySet().iterator().next())) != null) {
            FetchMode mode = resource.getFetchMode();
            List<Module> modules = resource.getModules();
            if (modules.size() > 0 && modules.get(0) instanceof Module.Remote) {
                urls.put(((Module.Remote)modules.get(0)).getURI(), mode);
            } else {
                controllerContext.renderURL(resource.getParameters(minified, locale), writer);
                urls.put(buffer.toString(), mode);
                buffer.setLength(0);
                writer.reset((Appendable)buffer);
            }
        }
        return urls;
    }

    public Map<ScriptResource, FetchMode> resolveIds(Map<ResourceId, FetchMode> ids) {
        return this.scripts.resolve(ids);
    }

    public JSONObject getJSConfig(ControllerContext controllerContext, Locale locale) throws Exception {
        JSONObject paths = new JSONObject();
        JSONObject shim = new JSONObject();
        for (ScriptResource resource : this.getAllResources()) {
            JSONArray deps;
            String name = resource.getId().toString();
            if (resource.isEmpty() && !ResourceScope.SHARED.equals((Object)resource.getId().getScope())) continue;
            HashMap<ResourceId, FetchMode> ids = new HashMap<ResourceId, FetchMode>();
            ids.put(resource.getId(), null);
            Map<String, FetchMode> urlMap = this.resolveURLs(controllerContext, ids, !PropertyManager.isDevelopping(), !PropertyManager.isDevelopping(), locale);
            String url = urlMap.keySet().iterator().next();
            paths.put(name, (Object)url.substring(0, url.length() - ".js".length()));
            List<Module> modules = resource.getModules();
            if (!FetchMode.IMMEDIATE.equals((Object)resource.getFetchMode()) && (modules.size() <= 0 || !(modules.get(0) instanceof Module.Remote)) || (deps = new JSONArray(resource.getDependencies())).length() <= 0) continue;
            shim.put(name, (Object)new JSONObject().put("deps", (Object)deps));
        }
        JSONObject config = new JSONObject();
        config.put("paths", (Object)paths);
        config.put("shim", (Object)shim);
        return config;
    }

    private List<ScriptResource> getAllResources() {
        LinkedList<ScriptResource> resources = new LinkedList<ScriptResource>();
        for (ResourceScope scope : ResourceScope.values()) {
            resources.addAll(this.scripts.getResources(scope));
        }
        return resources;
    }

    public ScriptResource getResource(ResourceId resource) {
        return this.scripts.getResource(resource);
    }

    public ScriptResource getResourceIncludingModule(String moduleName) {
        for (ScriptResource sharedRes : this.scripts.getResources(ResourceScope.SHARED)) {
            if (sharedRes.getModule(moduleName) == null) continue;
            return sharedRes;
        }
        for (ScriptResource portletRes : this.scripts.getResources(ResourceScope.PORTLET)) {
            if (portletRes.getModule(moduleName) == null) continue;
            return portletRes;
        }
        for (ScriptResource portalRes : this.scripts.getResources(ResourceScope.PORTAL)) {
            if (portalRes.getModule(moduleName) == null) continue;
            return portalRes;
        }
        return null;
    }

    public boolean isModuleLoaded(CharSequence module) {
        return this.getAvailableScripts().contains(((Object)module).toString());
    }

    public boolean isJavascriptLoaded(String path) {
        for (ScriptResource shared : this.scripts.getResources(ResourceScope.SHARED)) {
            for (Module module : shared.getModules()) {
                if (!module.getURI().equals(path)) continue;
                return true;
            }
        }
        return false;
    }

    public void start() {
        this.log.debug((Object)"Registering JavascriptConfigService for servlet container events");
        DefaultServletContainerFactory.getInstance().getServletContainer().addWebAppListener(this.deployer);
    }

    public void stop() {
        this.log.debug((Object)"Unregistering JavascriptConfigService for servlet container events");
        DefaultServletContainerFactory.getInstance().getServletContainer().removeWebAppListener(this.deployer);
    }

    private Reader getJavascript(ScriptResource resource, String moduleName, Locale locale) {
        Module.Local localModule;
        WebApp webApp;
        Module module = resource.getModule(moduleName);
        if (module instanceof Module.Local && (webApp = (WebApp)this.contexts.get((localModule = (Module.Local)module).getContextPath())) != null) {
            ServletContext sc = webApp.getServletContext();
            return localModule.read(locale, sc, webApp.getClassLoader());
        }
        return null;
    }
}

