/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portal.controller.resource.script;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import org.exoplatform.commons.utils.PropertyResolverReader;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.QualifiedName;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.portal.controller.resource.ResourceRequestHandler;
import org.gatein.portal.controller.resource.script.ScriptResource;

public abstract class Module {
    private static final Logger log = LoggerFactory.getLogger(Module.class);
    public static final ResourceBundle.Control CONTROL = new ResourceBundle.Control(){

        @Override
        public Locale getFallbackLocale(String baseName, Locale locale) {
            return locale.equals(Locale.ENGLISH) ? null : Locale.ENGLISH;
        }
    };
    protected ScriptResource resource;
    protected final String contextPath;
    protected final String name;
    protected int priority;

    Module(ScriptResource resource, String contextPath, String name, int priority) {
        this.resource = resource;
        this.contextPath = contextPath;
        this.name = name;
        this.priority = priority;
    }

    public ScriptResource getResource() {
        return this.resource;
    }

    public abstract boolean isRemote();

    public abstract String getURI();

    public String getContextPath() {
        return this.contextPath;
    }

    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }

    private static String escapeJavascriptStringLiteral(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"') {
                sb.append("\\\"");
                continue;
            }
            if (c == '\'') {
                sb.append("\\'");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static class Local
    extends Module {
        private final String path;
        private final String resourceBundle;
        private final Map<QualifiedName, String> parameters;

        Local(ScriptResource resource, String contextPath, String name, String path, String resourceBundle, int priority) {
            super(resource, contextPath, name, priority);
            HashMap<QualifiedName, String> parameters = new HashMap<QualifiedName, String>();
            parameters.put(WebAppController.HANDLER_PARAM, "script");
            parameters.put(ResourceRequestHandler.RESOURCE_QN, resource.getId().getName());
            parameters.put(ResourceRequestHandler.SCOPE_QN, resource.getId().getScope().name());
            parameters.put(ResourceRequestHandler.MODULE_QN, name);
            this.path = path;
            this.parameters = parameters;
            this.resourceBundle = resourceBundle;
        }

        public String getPath() {
            return this.path;
        }

        public String getResourceBundle() {
            return this.resourceBundle;
        }

        public Map<QualifiedName, String> getParameters() {
            return this.parameters;
        }

        @Override
        public boolean isRemote() {
            return false;
        }

        @Override
        public String getURI() {
            return this.contextPath + this.path;
        }

        public Reader read(Locale locale, ServletContext scriptLoader, ClassLoader bundleLoader) {
            InputStream in = scriptLoader.getResourceAsStream(this.path);
            if (in != null) {
                InputStreamReader reader = new InputStreamReader(in);
                if (this.resourceBundle != null) {
                    if (locale == null) {
                        locale = Locale.ENGLISH;
                    }
                    log.debug((Object)("About to load a bundle for locale " + locale + " and bundle " + this.resourceBundle));
                    final ResourceBundle bundle = ResourceBundle.getBundle(this.resourceBundle, locale, bundleLoader, CONTROL);
                    if (bundle != null) {
                        log.debug((Object)("Found bundle " + bundle + " for locale " + locale + " and bundle " + this.resourceBundle));
                        reader = new PropertyResolverReader(reader){

                            protected String resolve(String name) throws IOException {
                                try {
                                    String val = bundle.getString(name);
                                    return Module.escapeJavascriptStringLiteral(val);
                                }
                                catch (MissingResourceException e) {
                                    log.debug((Object)("Could not resolve property " + name + " when filtering JS"));
                                    return "";
                                }
                            }
                        };
                    }
                }
                return reader;
            }
            return null;
        }
    }

    public static class Remote
    extends Module {
        private final String uri;

        Remote(ScriptResource resource, String contextPath, String name, String uri, int priority) {
            super(resource, contextPath, name, priority);
            this.uri = uri;
        }

        @Override
        public boolean isRemote() {
            return true;
        }

        @Override
        public String getURI() {
            return this.uri;
        }
    }
}

