/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class DoLoginServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(DoLoginServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String initialURI = req.getParameter("initialURI");
        log.debug((Object)("Performing the do login send redirect with initialURI=" + initialURI + " and remoteUser=" + req.getRemoteUser()));
        if (initialURI == null || initialURI.length() == 0) {
            initialURI = req.getContextPath();
        }
        try {
            URI uri = new URI(initialURI);
            if (uri.isAbsolute() && !uri.getHost().equals(req.getServerName())) {
                log.warn((Object)"Cannot redirect to an URI outside of the current host when using a login redirect. Redirecting to the portal context path instead.");
                initialURI = req.getContextPath();
            }
        }
        catch (URISyntaxException e) {
            log.warn((Object)"Initial URI in login link is malformed. Redirecting to the portal context path instead.");
            initialURI = req.getContextPath();
        }
        resp.sendRedirect(resp.encodeRedirectURL(initialURI));
    }
}

